/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.DSFA;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VER;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.wizards.AlterDataSetWizardPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AlterDataSetWizard
extends Wizard {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(AlterDataSetWizard.class);
    private Pattern vrmPattern = Pattern.compile("FMNBA001.+?(\\d{1,2}).+?(\\d{1,2}).+?(\\d{1,2})");
    public static final int MIN_NULLRETN_EXT_VERSION = 140114;
    private String cachedDsName;
    private IPDHost host;

    public AlterDataSetWizard(IPDHost host) {
        this.host = host;
        this.setWindowTitle(Messages.ActionHistoryFactory_ALTER_DATA_SET);
    }

    public void addPages() {
        this.addPage((IWizardPage)new AlterDataSetWizardPage(this.host));
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        IWizardPage incompletePage = null;
        while (currentPage != null) {
            if (!currentPage.isPageComplete()) {
                incompletePage = currentPage;
                break;
            }
            currentPage = currentPage.getNextPage();
        }
        return incompletePage == null;
    }

    public boolean performFinish() {
        String dataSetName;
        AlterDataSetWizardPage alterDataSetWizardpage = (AlterDataSetWizardPage)this.getPage(Messages.AlterWizardPageFirst_ALTER_ATTRIBUTES);
        this.cachedDsName = dataSetName = AlterDataSetWizard.getDataSetName(alterDataSetWizardpage);
        String crossRegion = AlterDataSetWizard.getCrossRegion(alterDataSetWizardpage);
        String crossSystem = AlterDataSetWizard.getCrossSystem(alterDataSetWizardpage);
        final String mgtClass = alterDataSetWizardpage.getMgtClass();
        final String storeClass = alterDataSetWizardpage.getStoreClass();
        Calendar calender = alterDataSetWizardpage.getExpireDate();
        List<DataSet> association = alterDataSetWizardpage.getAssociation();
        Object expiryDate = "";
        expiryDate = alterDataSetWizardpage.getwExpirationChoice()[1].getSelection() ? calender.get(1) + "." + calender.get(6) : (alterDataSetWizardpage.getwExpirationChoice()[2].getSelection() ? "1999.365" : null);
        Object date = expiryDate;
        boolean nullRetention = false;
        if (alterDataSetWizardpage.getwExpirationChoice()[0].getSelection()) {
            nullRetention = true;
        }
        boolean nullretn = nullRetention;
        Job job = new Job(Messages.MSG_ALTER_WIZARD_PROCESS_ALTERING, (String)date, nullretn, association, crossRegion, crossSystem){
            private final /* synthetic */ String val$date;
            private final /* synthetic */ boolean val$nullretn;
            private final /* synthetic */ List val$association;
            private final /* synthetic */ String val$crossRegion;
            private final /* synthetic */ String val$crossSystem;
            {
                this.val$date = string4;
                this.val$nullretn = bl;
                this.val$association = list;
                this.val$crossRegion = string5;
                this.val$crossSystem = string6;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    Result result;
                    boolean status;
                    DSFA dsfa = new DSFA();
                    dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.DSNIN, (Object)dataSetName, AlterDataSetWizard.this.host);
                    if (mgtClass != null && storeClass != null) {
                        dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.MGMTCLAS, (Object)mgtClass, AlterDataSetWizard.this.host);
                        dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.STORCLAS, (Object)storeClass, AlterDataSetWizard.this.host);
                    }
                    dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.TO, (Object)this.val$date, AlterDataSetWizard.this.host);
                    if (this.val$nullretn && AlterDataSetWizard.this.requestFMVRM() >= 140114) {
                        dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.NULLRETN, (Object)this.val$nullretn, AlterDataSetWizard.this.host);
                    }
                    if (status = (result = UtilityFunctionRunner.execute((IPDHost)AlterDataSetWizard.this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)AlterDataSetWizard.this.host), (UtilityFunction)dsfa, (IHowIsGoing)howIsGoing)).isSuccessfulWithoutWarnings()) {
                        int i = 1;
                        while (i < this.val$association.size()) {
                            DataSet dataSet = (DataSet)this.val$association.get(i);
                            dsfa = new DSFA();
                            dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.DSNIN, (Object)dataSet.getName(), AlterDataSetWizard.this.host);
                            dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.SHRREG, (Object)this.val$crossRegion, AlterDataSetWizard.this.host);
                            dsfa.setValue((NewUtilityFunction.IUtilFuncParam)DSFA.SHRSYS, (Object)this.val$crossSystem, AlterDataSetWizard.this.host);
                            result = UtilityFunctionRunner.execute((IPDHost)AlterDataSetWizard.this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)AlterDataSetWizard.this.host), (UtilityFunction)dsfa, (IHowIsGoing)howIsGoing);
                            status = result.isSuccessfulWithoutWarnings();
                            if (!status) break;
                            ++i;
                        }
                    }
                    if (status) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult().equals(Status.OK_STATUS)) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_COMPLETED, (String)Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_COMPLETED);
                        } else {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_FAILED, (String)Messages.MSG_ALTER_WIZARD_PROCESS_ALTER_FAILED);
                        }
                    }
                });
            }
        });
        job.setUser(true);
        job.schedule();
        return true;
    }

    private static String getCrossSystem(AlterDataSetWizardPage alterDataSetWizardpage) {
        return alterDataSetWizardpage.getCrossSystem();
    }

    private static String getCrossRegion(AlterDataSetWizardPage alterDataSetWizardpage) {
        return alterDataSetWizardpage.getCrossRegion();
    }

    private static String getDataSetName(AlterDataSetWizardPage alterDataSetWizardpage) {
        return alterDataSetWizardpage.getDataSetName();
    }

    public int requestFMVRM() {
        int vrm = 0;
        try {
            String s;
            Matcher matcher;
            VER ver = new VER();
            IHowIsGoing monitor = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor());
            Result result = UtilityFunctionRunner.execute((IPDHost)this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.host), (UtilityFunction)ver, (IHowIsGoing)monitor);
            if (result == null || result.getOutput() == null) {
                result = UtilityFunctionRunner.execute((IPDHost)this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.host), (UtilityFunction)ver, (IHowIsGoing)monitor);
            }
            if (result != null && result.getOutput() != null && (matcher = this.vrmPattern.matcher(s = ((StringBuffer)result.getOutput()).toString())).find() && matcher.groupCount() > 2) {
                vrm = Integer.parseInt(matcher.group(1)) * 10000 + Integer.parseInt(matcher.group(2)) * 100 + Integer.parseInt(matcher.group(3));
            }
        }
        catch (IllegalArgumentException | InterruptedException e) {
            logger.trace((Object)("Attempt to determine FM version failed: " + e.getMessage()));
        }
        return vrm;
    }

    public String getCachedDsName() {
        return this.cachedDsName;
    }
}

