/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class AllocateHFSWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.AllocateHFSWizardPageFirst_BASIC_SETTINGS;
    private final AllocateHFSModel model;

    protected AllocateHFSWizardPageFirst(AllocateHFSModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group resourceGroup = GUI.group((Composite)parent, (String)Messages.AllocateHFSWizardPageFirst_RESOURCE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)resourceGroup, (String)Messages.Label__RESOURCE, (Object)GUI.grid.d.left1());
        Combo wResource = GUI.combo.editable((Composite)resourceGroup, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)resourceGroup), wResource, this.model).types(UssFile.class).noAllocate().onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof UssFile) {
                    AllocateHFSWizardPageFirst.this.model.setResource(zrl.getFormattedName());
                }
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        GUI.grid.padding((Composite)resourceGroup, (int)1);
        Button wBinaryMode = GUI.button.checkbox((Composite)resourceGroup, (String)Messages.AllocateHFSWizardPageFirst_BINARY_MODE_LABEL, (Object)GUI.grid.d.fillH((int)2));
        Group permissionGroup = GUI.group((Composite)parent, (String)Messages.AllocateHFSWizardPageFirst_PERMISSIONS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite checkComp = GUI.composite((Composite)permissionGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        GUI.label.left((Composite)checkComp, (String)Messages.AllocateHFSWizardPageFirst_USER_LABEL, (Object)GUI.grid.d.left1());
        Composite userComp = GUI.composite((Composite)checkComp, (Layout)GUI.grid.l.noMargins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        Button wUserPermissionR = GUI.button.checkbox((Composite)userComp, (String)Messages.AllocateHFSWizardPageFirst_READ, (Object)GUI.grid.d.fillH((int)1));
        Button wUserPermissionW = GUI.button.checkbox((Composite)userComp, (String)Messages.AllocateHFSWizardPageFirst_WRITE, (Object)GUI.grid.d.fillH((int)1));
        Button wUserPermissionX = GUI.button.checkbox((Composite)userComp, (String)Messages.AllocateHFSWizardPageFirst_EXECUTE, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)checkComp, (String)Messages.AllocateHFSWizardPageFirst_GROUP_LABEL, (Object)GUI.grid.d.left1());
        Composite groupComp = GUI.composite((Composite)checkComp, (Layout)GUI.grid.l.noMargins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        Button wGroupPermissionR = GUI.button.checkbox((Composite)groupComp, (String)Messages.AllocateHFSWizardPageFirst_READ, (Object)GUI.grid.d.fillH((int)1));
        Button wGroupPermissionW = GUI.button.checkbox((Composite)groupComp, (String)Messages.AllocateHFSWizardPageFirst_WRITE, (Object)GUI.grid.d.fillH((int)1));
        Button wGroupPermissionX = GUI.button.checkbox((Composite)groupComp, (String)Messages.AllocateHFSWizardPageFirst_EXECUTE, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)checkComp, (String)Messages.AllocateHFSWizardPageFirst_OTHER_LABEL, (Object)GUI.grid.d.left1());
        Composite otherComp = GUI.composite((Composite)checkComp, (Layout)GUI.grid.l.noMargins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        Button wOtherPermissionR = GUI.button.checkbox((Composite)otherComp, (String)Messages.AllocateHFSWizardPageFirst_READ, (Object)GUI.grid.d.fillH((int)1));
        Button wOtherPermissionW = GUI.button.checkbox((Composite)otherComp, (String)Messages.AllocateHFSWizardPageFirst_WRITE, (Object)GUI.grid.d.fillH((int)1));
        Button wOtherPermissionX = GUI.button.checkbox((Composite)otherComp, (String)Messages.AllocateHFSWizardPageFirst_EXECUTE, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)permissionGroup, (String)Messages.AllocateHFSWizardPageFirst_ADVANCED_FORM_LABEL, (Object)GUI.grid.d.left1());
        Combo wPermissionAdvanced = GUI.combo.editable((Composite)permissionGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(wPermissionAdvanced, ((Object)((Object)this)).getClass().getCanonicalName() + "PermAdv");
        wResource.setFocus();
        wResource.setSelection(new Point(0, wResource.getText().length()));
        this.setupDatabinding(wResource, wBinaryMode, wUserPermissionR, wUserPermissionW, wUserPermissionX, wGroupPermissionR, wGroupPermissionW, wGroupPermissionX, wOtherPermissionR, wOtherPermissionW, wOtherPermissionX, wPermissionAdvanced);
        this.setControl((Control)parent);
    }

    private void setupDatabinding(Combo wResource, Button wBinaryMode, Button wUserPermissionR, Button wUserPermissionW, Button wUserPermissionX, Button wGroupPermissionR, Button wGroupPermissionW, Button wGroupPermissionX, Button wOtherPermissionR, Button wOtherPermissionW, Button wOtherPermissionX, final Combo wPermissionAdvanced) {
        DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        IObservableValue modelResource = BeanProperties.value((String)"resource").observe((Object)this.model);
        final ISWTObservableValue targetResource = WidgetProperties.text().observe((Widget)wResource);
        dbc.bindValue((IObservableValue)targetResource, modelResource);
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wBinaryMode), BeanProperties.value((String)"binaryMode").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wUserPermissionR), BeanProperties.value((String)"ownerRead").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wUserPermissionW), BeanProperties.value((String)"ownerWrite").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wUserPermissionX), BeanProperties.value((String)"ownerExecute").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wGroupPermissionR), BeanProperties.value((String)"groupRead").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wGroupPermissionW), BeanProperties.value((String)"groupWrite").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wGroupPermissionX), BeanProperties.value((String)"groupExecute").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wOtherPermissionR), BeanProperties.value((String)"otherRead").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wOtherPermissionW), BeanProperties.value((String)"otherWrite").observe((Object)this.model));
        dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)wOtherPermissionX), BeanProperties.value((String)"otherExecute").observe((Object)this.model));
        ISWTObservableValue targetAdvanced = WidgetProperties.text().observe((Widget)wPermissionAdvanced);
        dbc.bindValue((IObservableValue)targetAdvanced, BeanProperties.value((String)"advancedValue").observe((Object)this.model), new UpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return wPermissionAdvanced.getText().trim().matches("[0-7]{3}") ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.AllocateHFSWizardPageFirst_PleaseSpecify3digitPerm);
            }
        }), null);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                if (AllocateHFSWizardPageFirst.this.model.getSystem() == null) {
                    return ValidationStatus.error((String)Messages.VALID_SYSTEM_REQUIRED);
                }
                if (((String)targetResource.getValue()).trim().isEmpty()) {
                    return ValidationStatus.error((String)Messages.AllocateHFSWizardPageFirst_SPECIFY_VALID_HFS_NAME);
                }
                if (((String)targetResource.getValue()).endsWith("/")) {
                    return ValidationStatus.error((String)Messages.AllocateHFSWizardPageFirst_DIR_NOT_SUPPORTED);
                }
                return ValidationStatus.info((String)Messages.AllocateHFSWizardPageFirst_ENTER_DETAILS);
            }
        });
    }
}

