/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UFAL;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.model.PDPropertyChangeSupport;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class AllocateHFSModel
extends PDPropertyChangeSupport
implements IHostProvider {
    private IPDHost host;
    private String advancedValue;
    private boolean binaryMode;
    private boolean ownerRead;
    private boolean ownerWrite;
    private boolean ownerExecute;
    private boolean groupRead;
    private boolean groupWrite;
    private boolean groupExecute;
    private boolean otherRead;
    private boolean otherWrite;
    private boolean otherExecute;
    public static final String ADVANCED_VALUE = "advancedValue";
    public static final String OWNER_EXECUTE = "ownerExecute";
    public static final String OWNER_READ = "ownerRead";
    public static final String OWNER_WRITE = "ownerWrite";
    public static final String GROUP_EXECUTE = "groupExecute";
    public static final String GROUP_READ = "groupRead";
    public static final String GROUP_WRITE = "groupWrite";
    public static final String OTHER_EXECUTE = "otherExecute";
    public static final String OTHER_WRITE = "otherWrite";
    public static final String OTHER_READ = "otherRead";
    public static final String RESOURCE = "resource";
    public static final String BINARY_MODE = "binaryMode";
    public static final String GROUP_PERMISSION = "groupPermission";
    public static final String OTHER_PERMISSION = "otherPermission";
    public static final String OWNER_PERMISSION = "ownerPermission";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String DEFAULT_OWNER_PERMISSION = "6";
    public static final String DEFAULT_GROUP_PERMISSION = "0";
    public static final String DEFAULT_OTHER_PERMISSION = "0";
    private String resource;
    private UssFile resourceLoaded;

    private void updateOwnerRead(boolean ownerRead) {
        this.ownerRead = ownerRead;
        this.firePropertyChange(OWNER_READ, this.ownerRead, this.ownerRead);
    }

    private void updateOwnerWrite(boolean ownerWrite) {
        this.ownerWrite = ownerWrite;
        this.firePropertyChange(OWNER_WRITE, this.ownerWrite, this.ownerWrite);
    }

    private void updateOwnerExecute(boolean ownerExecute) {
        this.ownerExecute = ownerExecute;
        this.firePropertyChange(OWNER_EXECUTE, this.ownerExecute, this.ownerExecute);
    }

    private void updateGroupRead(boolean groupRead) {
        this.groupRead = groupRead;
        this.firePropertyChange(GROUP_READ, this.groupRead, this.groupRead);
    }

    private void updateGroupWrite(boolean groupWrite) {
        this.groupWrite = groupWrite;
        this.firePropertyChange(GROUP_WRITE, this.groupWrite, this.groupWrite);
    }

    private void updateGroupExecute(boolean groupExecute) {
        this.groupExecute = groupExecute;
        this.firePropertyChange(GROUP_EXECUTE, this.groupExecute, this.groupExecute);
    }

    private void updateOtherExecute(boolean otherExecute) {
        this.otherExecute = otherExecute;
        this.firePropertyChange(OTHER_EXECUTE, this.otherExecute, this.otherExecute);
    }

    private void updateOtherWrite(boolean otherWrite) {
        this.otherWrite = otherWrite;
        this.firePropertyChange(OTHER_WRITE, this.otherWrite, this.otherWrite);
    }

    private void updateOtherRead(boolean otherRead) {
        this.otherRead = otherRead;
        this.firePropertyChange(OTHER_READ, this.otherRead, this.otherRead);
    }

    private void updateAdvancedValue(String advancedValue) {
        this.advancedValue = advancedValue;
        this.firePropertyChange(ADVANCED_VALUE, this.advancedValue, this.advancedValue);
    }

    public String getAdvancedValue() {
        return this.advancedValue;
    }

    public boolean isOwnerRead() {
        return this.ownerRead;
    }

    public boolean isOwnerWrite() {
        return this.ownerWrite;
    }

    public boolean isOwnerExecute() {
        return this.ownerExecute;
    }

    public boolean isGroupRead() {
        return this.groupRead;
    }

    public boolean isGroupWrite() {
        return this.groupWrite;
    }

    public boolean isGroupExecute() {
        return this.groupExecute;
    }

    public boolean isOtherRead() {
        return this.otherRead;
    }

    public boolean isOtherExecute() {
        return this.otherExecute;
    }

    public boolean isOtherWrite() {
        return this.otherWrite;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setOwnerRead(boolean ownerRead) {
        this.updateOwnerRead(ownerRead);
        this.updateAdvancedValueFromBooleans();
    }

    public void setOwnerWrite(boolean ownerWrite) {
        this.updateOwnerWrite(ownerWrite);
        this.updateAdvancedValueFromBooleans();
    }

    public void setOwnerExecute(boolean ownerExecute) {
        this.updateOwnerExecute(ownerExecute);
        this.updateAdvancedValueFromBooleans();
    }

    public void setGroupRead(boolean groupRead) {
        this.updateGroupRead(groupRead);
        this.updateAdvancedValueFromBooleans();
    }

    public void setGroupWrite(boolean groupWrite) {
        this.updateGroupWrite(groupWrite);
        this.updateAdvancedValueFromBooleans();
    }

    public void setGroupExecute(boolean groupExecute) {
        this.updateGroupExecute(groupExecute);
        this.updateAdvancedValueFromBooleans();
    }

    public void setOtherRead(boolean otherRead) {
        this.updateOtherRead(otherRead);
        this.updateAdvancedValueFromBooleans();
    }

    public void setOtherWrite(boolean otherWrite) {
        this.updateOtherWrite(otherWrite);
        this.updateAdvancedValueFromBooleans();
    }

    public void setOtherExecute(boolean otherExecute) {
        this.updateOtherExecute(otherExecute);
        this.updateAdvancedValueFromBooleans();
    }

    private void updateAdvancedValueFromBooleans() {
        int ownerVal = AllocateHFSModel.getIntPermission(this.ownerRead, this.ownerWrite, this.ownerExecute);
        int groupVal = AllocateHFSModel.getIntPermission(this.groupRead, this.groupWrite, this.groupExecute);
        int otherVal = AllocateHFSModel.getIntPermission(this.otherRead, this.otherWrite, this.otherExecute);
        this.updateAdvancedValue("" + ownerVal + groupVal + otherVal);
    }

    private static String charToBinary(int value) {
        String binaryString;
        if (value >= 0 && value <= 7 && (binaryString = Integer.toBinaryString(value)).length() <= 3) {
            return "000".substring(binaryString.length()) + binaryString;
        }
        throw new IllegalArgumentException("Must provide a permission value in range 0 to 7");
    }

    public void setAdvancedValue(String advancedValue) {
        Objects.requireNonNull(advancedValue, "Must provide non-null advanced value.");
        advancedValue = advancedValue.trim();
        if (advancedValue.matches("[0-7]{3}")) {
            this.updateOwnerValue(Integer.parseInt(advancedValue.substring(0, 1)));
            this.updateGroupValue(Integer.parseInt(advancedValue.substring(1, 2)));
            this.updateOther(Integer.parseInt(advancedValue.substring(2, 3)));
            this.updateAdvancedValue(advancedValue);
        } else {
            this.updateOwnerValue(0);
            this.updateGroupValue(0);
            this.updateOther(0);
            this.updateAdvancedValue("000");
        }
    }

    private void updateOther(int value) {
        String other = AllocateHFSModel.charToBinary(value);
        this.updateOtherRead(other.charAt(0) == '1');
        this.updateOtherWrite(other.charAt(1) == '1');
        this.updateOtherExecute(other.charAt(2) == '1');
    }

    private void updateGroupValue(int value) {
        String group = AllocateHFSModel.charToBinary(value);
        this.updateGroupRead(group.charAt(0) == '1');
        this.updateGroupWrite(group.charAt(1) == '1');
        this.updateGroupExecute(group.charAt(2) == '1');
    }

    private void updateOwnerValue(int value) {
        String owner = AllocateHFSModel.charToBinary(value);
        this.updateOwnerRead(owner.charAt(0) == '1');
        this.updateOwnerWrite(owner.charAt(1) == '1');
        this.updateOwnerExecute(owner.charAt(2) == '1');
    }

    private static int getIntPermission(boolean read, boolean write, boolean execute) {
        int val = 0;
        if (read) {
            val += 4;
        }
        if (write) {
            val += 2;
        }
        if (execute) {
            ++val;
        }
        return val;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
        this.firePropertyChange(BINARY_MODE, this.binaryMode, this.binaryMode);
    }

    public AllocateHFSModel(IPDHost host) {
        this(host, null, null);
    }

    public AllocateHFSModel(IPDHost host, String resource) {
        this(host, resource, null);
    }

    public AllocateHFSModel(IPDHost host, String resource, String advancedPermission) {
        this.host = Objects.requireNonNull(host);
        this.setResource(resource == null ? "" : resource);
        this.setAdvancedValue(advancedPermission == null ? "600" : advancedPermission);
        this.setBinaryMode(false);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        UFAL ufal = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)ufal, (IHowIsGoing)monitor);
    }

    public UFAL toUtilityFunction() {
        UFAL ufal = new UFAL();
        ufal.setValue((NewUtilityFunction.IUtilFuncParam)UFAL.PATH, (Object)this.getResourceUssFile().getFormattedName(), this.getSystem());
        ufal.setValue((NewUtilityFunction.IUtilFuncParam)UFAL.OWNER, (Object)this.getOwnerPermission(), this.getSystem());
        ufal.setValue((NewUtilityFunction.IUtilFuncParam)UFAL.GROUP, (Object)this.getGroupPermission(), this.getSystem());
        ufal.setValue((NewUtilityFunction.IUtilFuncParam)UFAL.OTHER, (Object)this.getOtherPermission(), this.getSystem());
        ufal.setValue((NewUtilityFunction.IUtilFuncParam)UFAL.BINMODE, (Object)this.isBinaryMode(), this.getSystem());
        return ufal;
    }

    public void fromUtilityFunction(UFAL function) {
        this.setResource((String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)UFAL.PATH, this.getSystem()));
        String inOwnerPermission = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)UFAL.OWNER, this.getSystem());
        this.updateGroupValue(Integer.parseInt(inOwnerPermission.length() == 1 ? inOwnerPermission.substring(0, 1) : DEFAULT_OWNER_PERMISSION));
        String inGroupPermission = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)UFAL.GROUP, this.getSystem());
        this.updateGroupValue(Integer.parseInt(inGroupPermission.length() == 1 ? inGroupPermission.substring(0, 1) : "0"));
        String inOtherPermission = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)UFAL.OTHER, this.getSystem());
        this.updateOther(Integer.parseInt(inOtherPermission.length() == 1 ? inOtherPermission.substring(0, 1) : "0"));
        this.setBinaryMode((Boolean)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)UFAL.BINMODE, this.getSystem()));
    }

    public AllocateHFSModel clone() {
        AllocateHFSModel clone = new AllocateHFSModel(this.getSystem());
        clone.resource = this.resource;
        clone.resourceLoaded = this.resourceLoaded;
        clone.ownerExecute = this.ownerExecute;
        clone.ownerRead = this.ownerRead;
        clone.ownerWrite = this.ownerWrite;
        clone.groupExecute = this.groupExecute;
        clone.groupRead = this.groupRead;
        clone.groupWrite = this.groupWrite;
        clone.otherExecute = this.otherExecute;
        clone.otherRead = this.otherRead;
        clone.otherWrite = this.otherWrite;
        clone.advancedValue = this.advancedValue;
        clone.binaryMode = this.binaryMode;
        return clone;
    }

    public String getResource() {
        return this.resource;
    }

    public UssFile getResourceUssFile() {
        if (this.getSystem() != null && UssFile.isParseableAbsolutePath((IPDHost)this.getSystem(), (String)this.resource)) {
            if (this.resourceLoaded != null && this.resourceLoaded.equals(UssFile.isParseableAbsolutePath((IPDHost)this.getSystem(), (String)this.resource) ? UssFile.parse((IPDHost)this.getSystem(), (String)this.resource) : null)) {
                return this.resourceLoaded;
            }
            return UssFile.isParseableAbsolutePath((IPDHost)this.getSystem(), (String)this.resource) ? UssFile.parse((IPDHost)this.getSystem(), (String)this.resource) : null;
        }
        return null;
    }

    public void setResource(String path) {
        UssFile parsed;
        Objects.requireNonNull(path, "Must provide a non-null path.");
        this.resource = path;
        this.firePropertyChange(RESOURCE, this.resource, this.resource);
        if (UssFile.isParseableAbsolutePath((IPDHost)this.getSystem(), (String)path) && (parsed = UssFile.parse((IPDHost)this.getSystem(), (String)path)).getConfirmedExists()) {
            this.resourceLoaded = parsed;
        }
    }

    public String getOwnerPermission() {
        return Integer.toString(AllocateHFSModel.getIntPermission(this.ownerRead, this.ownerWrite, this.ownerExecute));
    }

    public String getGroupPermission() {
        return Integer.toString(AllocateHFSModel.getIntPermission(this.groupRead, this.groupWrite, this.groupExecute));
    }

    public String getOtherPermission() {
        return Integer.toString(AllocateHFSModel.getIntPermission(this.otherRead, this.otherWrite, this.otherExecute));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocateHFSModel) {
            AllocateHFSModel other = (AllocateHFSModel)((Object)obj);
            return this.getSystem().equals(other.getSystem()) && this.toUtilityFunction().equals((Object)other.toUtilityFunction());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.toUtilityFunction().hashCode();
    }

    public IPDHost getSystem() {
        return this.host;
    }
}

