/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.socket.func.UFAL;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.etools.fm.ui.wizards.AllocateHFSRunnable;
import com.ibm.etools.fm.ui.wizards.AllocateHFSWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AllocateHFSActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static AllocateHFSActionItemPropertySource propSource;
    private AllocateHFSModel model = null;

    public AllocateHFSActionItem(AllocateHFSModel model) {
        super(ActionType.ALLOCATE_HFS, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.AllocateHFSActionItem_LABEL, this.model.getResourceUssFile().getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        UFAL function = new UFAL();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        AllocateHFSModel model = new AllocateHFSModel(system);
        model.fromUtilityFunction(function);
        return new AllocateHFSActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        AllocateHFSRunnable runnable = new AllocateHFSRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void execute(List<SystemsTreeNode> draggedObjects) {
    }

    @Override
    public void modify() {
        this.beginExecution();
        final AllocateHFSModel clone = this.model.clone();
        AllocateHFSWizard wizard = new AllocateHFSWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                AllocateHFSActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public boolean isValidInput(List<SystemsTreeNode> draggedObjects) {
        return false;
    }

    @Override
    public AllocateHFSActionItem clone() {
        AllocateHFSActionItem clone = new AllocateHFSActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AllocateHFSActionItem) {
            AllocateHFSActionItem other = (AllocateHFSActionItem)obj;
            return this.getSystem().equals(other.getSystem()) && this.model.toUtilityFunction().equals((Object)other.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 37 * result + this.getSystem().hashCode();
        result = 37 * result + this.model.toUtilityFunction().hashCode();
        return result;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new AllocateHFSActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class AllocateHFSActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private AllocateHFSModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        private String resource = "resource";
        private String ownerPermission = "ownerPermission";
        private String groupPermission = "groupPermission";
        private String otherPermission = "otherPermission";
        private String binaryMode = "binaryMode";

        public AllocateHFSActionItemPropertySource(AllocateHFSModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(AllocateHFSModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)this.resource, Messages.AllocateHFSActionItem_RESOURCE));
            temp.add(new PropertyDescriptor((Object)this.ownerPermission, Messages.AllocateHFSActionItem_OWNER_PERMISSION));
            temp.add(new PropertyDescriptor((Object)this.groupPermission, Messages.AllocateHFSActionItem_GROUP_PERMISSION));
            temp.add(new PropertyDescriptor((Object)this.otherPermission, Messages.AllocateHFSActionItem_OTHER_PERMISSION));
            temp.add(new PropertyDescriptor((Object)this.binaryMode, Messages.AllocateHFSActionItem_BINARY_MODE));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.resource)) {
                    return this.model.getResource();
                }
                if (id.equals(this.ownerPermission)) {
                    return this.model.getOwnerPermission();
                }
                if (id.equals(this.groupPermission)) {
                    return this.model.getGroupPermission();
                }
                if (id.equals(this.otherPermission)) {
                    return this.model.getOtherPermission();
                }
                if (id.equals(this.binaryMode)) {
                    return this.model.isBinaryMode();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

