/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageStorage;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageVSAM3KSDS
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final AllocateDataSetModel params;
    private Combo wIndexComponent;
    private Combo wIndexCISize;
    private Combo wIndexSpacePrimary;
    private Combo wIndexSpaceSecondary;
    private Combo wIndexAllocationUnit;
    private Combo wIndexVolumeSerial;

    public AllocateDataSetWizardPageVSAM3KSDS(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_VSAM3KSDS);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM3KSDS_SPECIFY_OPTIONS);
    }

    public void setPageComplete(boolean complete) {
        if (complete && this.getWizard().getContainer().getCurrentPage() == this) {
            if (this.wIndexComponent != null) {
                this.params.setVSAMindexComponent(this.wIndexComponent.getText());
            }
            if (this.wIndexCISize != null) {
                this.params.setVSAMindexCISize(this.wIndexCISize.getText());
            }
            if (this.wIndexSpacePrimary != null) {
                this.params.setVSAMindexSpacePrimary(this.wIndexSpacePrimary.getText());
            }
            if (this.wIndexSpaceSecondary != null) {
                this.params.setVSAMindexSpaceSecondary(this.wIndexSpaceSecondary.getText());
            }
            if (this.wIndexAllocationUnit != null) {
                this.params.setVSAMindexAllocationUnit((DSAQ.SpaceUnit)EnumUtils.lookup(DSAQ.SpaceUnit.class, (String)this.wIndexAllocationUnit.getText()));
            }
            if (this.wIndexVolumeSerial != null) {
                this.params.setVSAMindexVolumeSerial(this.wIndexVolumeSerial.getText());
            }
        }
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__INDEX_COMPONENT, (Object)GUI.grid.d.left1());
        this.wIndexComponent = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(parent), this.wIndexComponent, this.params).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "IndexComponent").create();
        this.wIndexComponent.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        IPDHost system = this.params.getSystem();
        new FMWizardPage.ManagedWidget(this, this.wIndexComponent, system){

            @Override
            protected boolean isValid() {
                String text2 = AllocateDataSetWizardPageVSAM3KSDS.this.wIndexComponent.getText();
                if (text2.isEmpty()) {
                    return true;
                }
                return Member.isParseable((String)text2, (boolean)false, (String)this.ipdHost.getCodePage());
            }
        };
        GUI.label.left((Composite)parent, (String)Messages.Label__CONTROL_INTERVAL_SIZE, (Object)GUI.grid.d.left1());
        this.wIndexCISize = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wIndexCISize, ((Object)((Object)this)).getClass().getCanonicalName() + "IndexCISize");
        new FMWizardPage.ManagedWidget(this, this.wIndexCISize, this.params.getHost());
        Group storageGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_VSAM3KSDS_SPACE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__PRIMARY, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__SECONDARY, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__UNITS, (Object)GUI.grid.d.left1());
        this.wIndexSpacePrimary = GUI.combo.editable((Composite)storageGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfISP = NumberForcer.addTo(this.wIndexSpacePrimary, ((Object)((Object)this)).getClass().getCanonicalName() + "IndexSpacePrimary");
        nfISP.setLowerBound(1, true);
        new FMWizardPage.ManagedWidget(this, this.wIndexSpacePrimary, Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM3KSDS_SPECIFY_PRIMARY_SPACE, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (AllocateDataSetWizardPageVSAM3KSDS.this.getWizard().getContainer().getCurrentPage() == AllocateDataSetWizardPageVSAM3KSDS.this) {
                    return !AllocateDataSetWizardPageVSAM3KSDS.this.isEmpty(AllocateDataSetWizardPageVSAM3KSDS.this.wIndexSpacePrimary);
                }
                return AllocateDataSetWizardPageVSAM3KSDS.this.params.getVSAMindexSpacePrimary().length() > 0;
            }
        };
        this.wIndexSpaceSecondary = GUI.combo.editable((Composite)storageGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfISS = NumberForcer.addTo(this.wIndexSpaceSecondary, ((Object)((Object)this)).getClass().getCanonicalName() + "IndexSpaceSecondary");
        nfISS.setLowerBound(1, true);
        new FMWizardPage.ManagedWidget(this, this.wIndexSpaceSecondary, this.params.getHost());
        this.wIndexAllocationUnit = GUI.combo.readOnly((Composite)storageGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])DSAQ.SpaceUnit.values());
        new ComboValueSaver(this.wIndexAllocationUnit, ((Object)((Object)this)).getClass().getCanonicalName() + "IndexAllocationUnit");
        new FMWizardPage.ManagedWidget(this, this.wIndexAllocationUnit, this.params.getHost());
        Group volsersGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_VOLUMES, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)volsersGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM_SPECIFY_VOLUMES, (Object)GUI.grid.d.fillH((int)1));
        this.wIndexVolumeSerial = GUI.combo.editable((Composite)volsersGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wIndexVolumeSerial, ((Object)((Object)this)).getClass().getCanonicalName() + "IndexVolumeSerial");
        new FMWizardPage.ManagedWidget(this, this.wIndexVolumeSerial, this.params.getHost());
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel tempParams = this.params.clone();
        this.wIndexComponent.setText(tempParams.getVSAMindexComponent());
        this.wIndexCISize.setText(tempParams.getVSAMindexCISize());
        this.wIndexSpacePrimary.setText(tempParams.getVSAMindexSpacePrimary());
        this.wIndexSpaceSecondary.setText(tempParams.getVSAMindexSpaceSecondary());
        this.wIndexAllocationUnit.select(ArrayUtils.findIndexOf((Object)tempParams.getVSAMindexAllocationUnit(), (Object[])DSAQ.SpaceUnit.values(), (int)0));
        this.wIndexVolumeSerial.setText(tempParams.getVSAMindexVolumeSerial());
    }

    public IWizardPage getNextPage() {
        return this.getPage(AllocateDataSetWizardPageStorage.class);
    }
}

