/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageStorage;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageVSAM3KSDS;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageVSAM2
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final AllocateDataSetModel params;
    private Combo wDataComponent;
    private Combo wCatalog;
    private Combo wRecsizeAverage;
    private Combo wRecsizeMaximum;
    private Combo wFreespaceCI;
    private Combo wFreespaceCA;
    private Combo wVolumeSerial;

    public AllocateDataSetWizardPageVSAM2(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_VSAM2);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM2_SPECIFY_SETTINGS);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            if (this.wDataComponent != null) {
                this.params.setVSAMdataComponent(this.wDataComponent.getText());
            }
            if (this.wCatalog != null) {
                this.params.setVSAMcatalog(this.wCatalog.getText());
            }
            if (this.wRecsizeAverage != null) {
                this.params.setVSAMrecsizeAverage(this.wRecsizeAverage.getText());
            }
            if (this.wRecsizeMaximum != null) {
                this.params.setVSAMrecsizeMaximum(this.wRecsizeMaximum.getText());
            }
            if (this.wFreespaceCI != null) {
                this.params.setVSAMfreespaceCI(this.wFreespaceCI.getText());
            }
            if (this.wFreespaceCA != null) {
                this.params.setVSAMfreespaceCA(this.wFreespaceCA.getText());
            }
            if (this.wVolumeSerial != null) {
                this.params.setVSAMvolumeSerial(this.wVolumeSerial.getText());
            }
        }
        boolean allocatingLDS = this.params.getDataSetType() == DataSetType.LDS;
        this.setEnabledIf((Control)this.wRecsizeAverage, !allocatingLDS);
        this.setEnabledIf((Control)this.wRecsizeMaximum, !allocatingLDS);
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_COMPONENT, (Object)GUI.grid.d.left1());
        this.wDataComponent = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(parent), this.wDataComponent, this.params).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "DataComponent").create();
        this.wDataComponent.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        IPDHost system = this.params.getSystem();
        new FMWizardPage.ManagedWidget(this, this.wDataComponent, system){

            @Override
            protected boolean isValid() {
                String text2 = AllocateDataSetWizardPageVSAM2.this.wDataComponent.getText();
                if (text2.isEmpty()) {
                    return true;
                }
                return Member.isParseable((String)text2, (boolean)false, (String)this.ipdHost.getCodePage());
            }
        };
        GUI.label.left((Composite)parent, (String)Messages.Label__CATALOG, (Object)GUI.grid.d.left1());
        this.wCatalog = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(parent), this.wCatalog, this.params).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Catalog").create();
        this.wCatalog.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new FMWizardPage.ManagedWidget(this, this.wCatalog, system){

            @Override
            protected boolean isValid() {
                String text2 = AllocateDataSetWizardPageVSAM2.this.wCatalog.getText();
                if (text2.isEmpty()) {
                    return true;
                }
                return Member.isParseable((String)text2, (boolean)false, (String)this.ipdHost.getCodePage());
            }
        };
        Group recsizeGroup = GUI.group((Composite)parent, (String)Messages.Title__RECORD_SIZE, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)recsizeGroup, (String)Messages.Label__AVERAGE, (Object)GUI.grid.d.left1());
        this.wRecsizeAverage = GUI.combo.editable((Composite)recsizeGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer recAvgNF = NumberForcer.addTo(this.wRecsizeAverage, ((Object)((Object)this)).getClass().getCanonicalName() + "RecsizeAverage");
        recAvgNF.setLowerBound(0, true);
        new FMWizardPage.ManagedWidget(this, this.wRecsizeAverage, Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM2_SPECIFY_MAX_RECSIZE, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageVSAM2.this.wRecsizeAverage.getText().isEmpty()) {
                    if (AllocateDataSetWizardPageVSAM2.this.wRecsizeMaximum != null) {
                        return AllocateDataSetWizardPageVSAM2.this.wRecsizeMaximum.getText().length() > 0;
                    }
                    return false;
                }
                return true;
            }
        };
        GUI.label.left((Composite)recsizeGroup, (String)Messages.Label__MAXIMUM, (Object)GUI.grid.d.left1());
        this.wRecsizeMaximum = GUI.combo.editable((Composite)recsizeGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer recMaxNF = NumberForcer.addTo(this.wRecsizeMaximum, ((Object)((Object)this)).getClass().getCanonicalName() + "RecsizeMaximum");
        recMaxNF.setLowerBound(0, true);
        new FMWizardPage.ManagedWidget(this, this.wRecsizeMaximum, Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM2_SPECIFY_AVG_RECSIZE, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageVSAM2.this.wRecsizeMaximum.getText().isEmpty()) {
                    if (AllocateDataSetWizardPageVSAM2.this.wRecsizeAverage != null) {
                        return AllocateDataSetWizardPageVSAM2.this.wRecsizeAverage.getText().length() > 0;
                    }
                    return false;
                }
                return true;
            }
        };
        Group freespaceGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_VSAM2_FREE_SPACE_PERC, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)freespaceGroup, (String)Messages.Label__CONTROL_INTERVAL, (Object)GUI.grid.d.left1());
        this.wFreespaceCI = GUI.combo.editable((Composite)freespaceGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfFCI = NumberForcer.addTo(this.wFreespaceCI, ((Object)((Object)this)).getClass().getCanonicalName() + "FreespaceCI");
        nfFCI.setUpperBound(100, true);
        new FMWizardPage.ManagedWidget(this, this.wFreespaceCI, this.params.getHost());
        GUI.label.left((Composite)freespaceGroup, (String)Messages.Label__CONTROL_AREA, (Object)GUI.grid.d.left1());
        this.wFreespaceCA = GUI.combo.editable((Composite)freespaceGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfFCA = NumberForcer.addTo(this.wFreespaceCA, ((Object)((Object)this)).getClass().getCanonicalName() + "FreespaceCA");
        nfFCA.setUpperBound(100, true);
        new FMWizardPage.ManagedWidget(this, this.wFreespaceCA, this.params.getHost());
        Group volsersGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_VOLUMES, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)volsersGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM_SPECIFY_VOLUMES, (Object)GUI.grid.d.fillH((int)1));
        this.wVolumeSerial = GUI.combo.editable((Composite)volsersGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wVolumeSerial, ((Object)((Object)this)).getClass().getCanonicalName() + "VolumeSerial");
        new FMWizardPage.ManagedWidget(this, this.wVolumeSerial, this.params.getHost());
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel tempParams = this.params.clone();
        this.wDataComponent.setText(tempParams.getVSAMdataComponent());
        this.wCatalog.setText(tempParams.getVSAMcatalog());
        this.wRecsizeAverage.setText(tempParams.getVSAMrecsizeAverage());
        this.wRecsizeMaximum.setText(tempParams.getVSAMrecsizeMaximum());
        this.wFreespaceCI.setText(tempParams.getVSAMfreespaceCI());
        this.wFreespaceCA.setText(tempParams.getVSAMfreespaceCA());
        this.wVolumeSerial.setText(tempParams.getVSAMvolumeSerial());
        boolean isESDSorKSDS = tempParams.getDataSetType() == DataSetType.ESDS || tempParams.getDataSetType() == DataSetType.ESDSIAM || tempParams.getDataSetType() == DataSetType.KSDS || this.params.getDataSetType() == DataSetType.KSDSIAM;
        this.wFreespaceCI.setEnabled(isESDSorKSDS);
        this.wFreespaceCA.setEnabled(isESDSorKSDS);
    }

    public IWizardPage getNextPage() {
        if (this.params.getDataSetType() == DataSetType.KSDS || this.params.getDataSetType() == DataSetType.KSDSIAM) {
            return this.getPage(AllocateDataSetWizardPageVSAM3KSDS.class);
        }
        return this.getPage(AllocateDataSetWizardPageStorage.class);
    }
}

