/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageVSAM2;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageVSAM1
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final AllocateDataSetModel params;
    private Combo wKeyLength;
    private Combo wKeyOffset;
    private Combo wCISize;
    private Combo wBufferSpace;
    private Button wShareCrossRegion1;
    private Button wShareCrossRegion2;
    private Button wShareCrossRegion3;
    private Button wShareCrossRegion4;
    private Button wShareCrossSystem3;
    private Button wShareCrossSystem4;
    private Button wReuse;
    private Button wRecovery;
    private Button wErase;
    private Button wSpanned;
    private Button wWriteCheck;
    private Combo keyLabelText;

    protected AllocateDataSetWizardPageVSAM1(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_VSAM1);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM1_SPECIFY_OPTIONS);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            if (this.wKeyLength != null) {
                this.params.setVSAMkeyLength(this.wKeyLength.getText());
            }
            if (this.wKeyOffset != null) {
                this.params.setVSAMkeyOffset(this.wKeyOffset.getText());
            }
            if (this.wCISize != null) {
                this.params.setVSAMciSize(this.wCISize.getText());
            }
            if (this.wBufferSpace != null) {
                this.params.setVSAMbufferSpace(this.wBufferSpace.getText());
            }
            if (this.isSelected((Control)this.wShareCrossRegion1)) {
                this.params.setVSAMshareCrossRegion(1);
            } else if (this.isSelected((Control)this.wShareCrossRegion2)) {
                this.params.setVSAMshareCrossRegion(2);
            } else if (this.isSelected((Control)this.wShareCrossRegion3)) {
                this.params.setVSAMshareCrossRegion(3);
            } else if (this.isSelected((Control)this.wShareCrossRegion4)) {
                this.params.setVSAMshareCrossRegion(4);
            }
            if (this.isSelected((Control)this.wShareCrossSystem3)) {
                this.params.setVSAMshareCrossSystem(3);
            } else if (this.isSelected((Control)this.wShareCrossSystem4)) {
                this.params.setVSAMshareCrossSystem(4);
            }
            if (this.wReuse != null) {
                this.params.setVSAMreuse(this.wReuse.getSelection());
            }
            if (this.wRecovery != null) {
                this.params.setVSAMrecovery(this.wRecovery.getSelection());
            }
            if (this.wErase != null) {
                this.params.setVSAMerase(this.wErase.getSelection());
            }
            if (this.wSpanned != null) {
                this.params.setVSAMspanned(this.wSpanned.getSelection());
            }
            if (this.wWriteCheck != null) {
                this.params.setVSAMwriteCheck(this.wWriteCheck.getSelection());
            }
        }
        if (this.isSelected((Control)this.wShareCrossRegion3)) {
            this.disable((Control)this.wShareCrossSystem4);
        } else {
            this.enable((Control)this.wShareCrossSystem4);
        }
        boolean allocatingLDS = this.params.getDataSetType() == DataSetType.LDS;
        boolean allocatingESDS = this.params.getDataSetType() == DataSetType.ESDS || this.params.getDataSetType() == DataSetType.ESDSIAM;
        this.setEnabledIf((Control)this.wKeyLength, !allocatingLDS && !allocatingESDS);
        this.setEnabledIf((Control)this.wKeyOffset, !allocatingLDS && !allocatingESDS);
        this.setEnabledIf((Control)this.wCISize, !allocatingLDS);
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 4;
        int controlWidth = 1;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)parent, (String)Messages.Label__KEY_LENGTH, (Object)GUI.grid.d.left1());
        this.wKeyLength = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)controlWidth));
        NumberForcer keyLenNF = NumberForcer.addTo(this.wKeyLength, ((Object)((Object)this)).getClass().getCanonicalName() + "KeyLength");
        keyLenNF.setLowerBound(0, true);
        new FMWizardPage.ManagedWidget(this, this.wKeyLength, Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM1_KEY_OFFSET_REQUIRED_STATES, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageVSAM1.this.wKeyLength.getText().isEmpty()) {
                    if (AllocateDataSetWizardPageVSAM1.this.wKeyOffset != null) {
                        return AllocateDataSetWizardPageVSAM1.this.wKeyOffset.getText().length() > 0;
                    }
                    return false;
                }
                return AllocateDataSetWizardPageVSAM1.this.params.getDataSetType() != DataSetType.KSDS && AllocateDataSetWizardPageVSAM1.this.params.getDataSetType() != DataSetType.KSDSIAM;
            }
        };
        GUI.label.left((Composite)parent, (String)Messages.Label__KEY_OFFSET, (Object)GUI.grid.d.left1());
        this.wKeyOffset = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)controlWidth));
        NumberForcer keyOffNF = NumberForcer.addTo(this.wKeyOffset, ((Object)((Object)this)).getClass().getCanonicalName() + "KeyOffset");
        keyOffNF.setLowerBound(0, true);
        new FMWizardPage.ManagedWidget(this, this.wKeyOffset, Messages.Msg_ALLOCATE_WIZARD_PAGE_VSAM1_KEY_LENGTH_REQUIRED_STATES, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageVSAM1.this.wKeyOffset.getText().isEmpty()) {
                    if (AllocateDataSetWizardPageVSAM1.this.wKeyLength != null) {
                        return AllocateDataSetWizardPageVSAM1.this.wKeyLength.getText().length() > 0;
                    }
                    return false;
                }
                return AllocateDataSetWizardPageVSAM1.this.params.getDataSetType() != DataSetType.KSDS && AllocateDataSetWizardPageVSAM1.this.params.getDataSetType() != DataSetType.KSDSIAM;
            }
        };
        GUI.label.left((Composite)parent, (String)Messages.Label__CONTROL_INTERVAL_SIZE, (Object)GUI.grid.d.left1());
        this.wCISize = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)controlWidth));
        NumberForcer.addTo(this.wCISize, ((Object)((Object)this)).getClass().getCanonicalName() + "ClSize");
        new FMWizardPage.ManagedWidget(this, this.wCISize, this.params.getHost());
        GUI.label.left((Composite)parent, (String)Messages.Label__BUFFER_SPACE, (Object)GUI.grid.d.left1());
        this.wBufferSpace = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)controlWidth));
        NumberForcer.addTo(this.wBufferSpace, ((Object)((Object)this)).getClass().getCanonicalName() + "BufferSpace");
        new FMWizardPage.ManagedWidget(this, this.wBufferSpace, this.params.getHost());
        Group sharingGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_VSAM1_SHARING, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)sharingGroup, (String)Messages.Label__CROSS_REGION, (Object)GUI.grid.d.left1());
        Composite regionGroup = GUI.composite((Composite)sharingGroup, (Layout)GUI.grid.l.customMargins((int)4, (boolean)true, (int)0, (int)0), (Object)GUI.grid.d.fillH((int)1));
        this.wShareCrossRegion1 = GUI.button.radio((Composite)regionGroup, (String)Integer.toString(1), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossRegion1, this.params.getHost());
        this.wShareCrossRegion2 = GUI.button.radio((Composite)regionGroup, (String)Integer.toString(2), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossRegion2, this.params.getHost());
        this.wShareCrossRegion3 = GUI.button.radio((Composite)regionGroup, (String)Integer.toString(3), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossRegion3, this.params.getHost()){

            @Override
            public void onChange(Event event) {
                if (AllocateDataSetWizardPageVSAM1.this.isSelected((Control)AllocateDataSetWizardPageVSAM1.this.wShareCrossRegion3)) {
                    AllocateDataSetWizardPageVSAM1.this.select((Control)AllocateDataSetWizardPageVSAM1.this.wShareCrossSystem3);
                    AllocateDataSetWizardPageVSAM1.this.unselect((Control)AllocateDataSetWizardPageVSAM1.this.wShareCrossSystem4);
                }
            }
        };
        this.wShareCrossRegion4 = GUI.button.radio((Composite)regionGroup, (String)Integer.toString(4), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossRegion4, this.params.getHost());
        GUI.label.left((Composite)sharingGroup, (String)Messages.Label__CROSS_SYSTEM, (Object)GUI.grid.d.left1());
        Composite systemGroup = GUI.composite((Composite)sharingGroup, (Layout)GUI.grid.l.customMargins((int)4, (boolean)true, (int)0, (int)0), (Object)GUI.grid.d.fillH((int)1));
        GUI.grid.padding((Composite)systemGroup, (int)2);
        this.wShareCrossSystem3 = GUI.button.radio((Composite)systemGroup, (String)Integer.toString(3), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossSystem3, this.params.getHost());
        this.wShareCrossSystem4 = GUI.button.radio((Composite)systemGroup, (String)Integer.toString(4), (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wShareCrossSystem4, this.params.getHost());
        Group optionsGroup = GUI.group((Composite)parent, (String)Messages.Title__OPTIONS, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        this.wReuse = GUI.button.checkbox((Composite)optionsGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_REUSE, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wReuse, this.params.getHost());
        this.wRecovery = GUI.button.checkbox((Composite)optionsGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_RECOVERY, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wRecovery, this.params.getHost());
        this.wErase = GUI.button.checkbox((Composite)optionsGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_ERASE, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wErase, this.params.getHost());
        this.wSpanned = GUI.button.checkbox((Composite)optionsGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_SPANNED, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wSpanned, this.params.getHost());
        this.wWriteCheck = GUI.button.checkbox((Composite)optionsGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_WRITE_CHECK, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wWriteCheck, this.params.getHost());
        if (HostVersion.getInstance().getVersion() >= 150105) {
            GUI.grid.padding((Composite)optionsGroup, (int)1);
            GUI.label.left((Composite)optionsGroup, (String)Messages.DataSetProperties_PROPERTY_ENCRYPTION_KEY_LABEL, (Object)GUI.grid.d.left1());
            this.keyLabelText = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.keyLabelText, ((Object)((Object)this)).getClass().getCanonicalName() + "keyLabel");
            new FMWizardPage.ManagedWidget(this, this.keyLabelText, Messages.DataSetProperties_PROPERTY_KEY_LABEL, this.params.getHost()){

                @Override
                public void onChange(Event event) {
                    AllocateDataSetWizardPageVSAM1.this.params.setKeyLabel(AllocateDataSetWizardPageVSAM1.this.keyLabelText.getText().trim());
                }
            };
        }
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel tempParams = this.params.clone();
        this.wKeyLength.setText(tempParams.getVSAMkeyLength());
        this.wKeyOffset.setText(tempParams.getVSAMkeyOffset());
        this.wCISize.setText(tempParams.getVSAMciSize());
        this.wBufferSpace.setText(tempParams.getVSAMbufferSpace());
        if (tempParams.getVSAMshareCrossRegion() == 1) {
            this.select((Control)this.wShareCrossRegion1);
        } else if (tempParams.getVSAMshareCrossRegion() == 2) {
            this.select((Control)this.wShareCrossRegion2);
        } else if (tempParams.getVSAMshareCrossRegion() == 3) {
            this.select((Control)this.wShareCrossRegion3);
        } else if (tempParams.getVSAMshareCrossRegion() == 4) {
            this.select((Control)this.wShareCrossRegion4);
        }
        if (tempParams.getVSAMshareCrossSystem() == 3) {
            this.select((Control)this.wShareCrossSystem3);
        } else if (tempParams.getVSAMshareCrossSystem() == 4) {
            this.select((Control)this.wShareCrossSystem4);
        }
        this.wReuse.setSelection(tempParams.isVSAMreuse());
        this.wRecovery.setSelection(tempParams.isVSAMrecovery());
        this.wErase.setSelection(tempParams.isVSAMerase());
        this.wSpanned.setSelection(tempParams.isVSAMspanned());
        this.wSpanned.setEnabled(tempParams.getDataSetType() == DataSetType.ESDS || tempParams.getDataSetType() == DataSetType.KSDS || this.params.getDataSetType() == DataSetType.KSDSIAM);
        this.wWriteCheck.setSelection(tempParams.isVSAMwriteCheck());
        this.wWriteCheck.setEnabled(tempParams.getDataSetType() == DataSetType.KSDS || this.params.getDataSetType() == DataSetType.KSDSIAM);
        if (HostVersion.getInstance().getVersion() >= 150105) {
            this.keyLabelText.setText(this.params.getKeyLabel());
        }
    }

    public IWizardPage getNextPage() {
        return this.getPage(AllocateDataSetWizardPageVSAM2.class);
    }
}

