/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Objects;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageStorage
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final AllocateDataSetModel params;
    private DateTime wExpirationDate;
    private Button[] wExpirationChoice = new Button[3];
    private Combo wAllocationPrimary;
    private Combo wAllocationSecondary;
    private Combo wAllocationUnits;
    private Combo wDataClass;
    private Combo wStoreClass;
    private Combo wManagementClass;

    public AllocateDataSetWizardPageStorage(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE2);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_SPECIFY_OPTIONS);
    }

    public void setPageComplete(boolean complete) {
        if (complete && this.getWizard().getContainer().getCurrentPage() == this) {
            if (this.isSelected((Control)this.wExpirationChoice[1])) {
                this.params.setExpirationDate(GUI.datetime.get((DateTime)this.wExpirationDate));
            } else if (this.isSelected((Control)this.wExpirationChoice[2])) {
                Calendar nonExpiryDate = Calendar.getInstance();
                nonExpiryDate.set(1, 1999);
                nonExpiryDate.set(6, 365);
                this.params.setExpirationDate(nonExpiryDate);
            } else {
                this.params.setExpirationDate(null);
            }
            if (this.wAllocationPrimary != null) {
                this.params.setAllocationPrimary(this.wAllocationPrimary.getText());
            }
            if (this.wAllocationSecondary != null) {
                this.params.setAllocationSecondary(this.wAllocationSecondary.getText());
            }
            if (this.wAllocationUnits != null) {
                this.params.setAllocationUnits((DSAQ.SpaceUnit)EnumUtils.lookup(DSAQ.SpaceUnit.class, (String)this.wAllocationUnits.getText()));
            }
            if (this.wDataClass != null) {
                this.params.setDataClass(this.wDataClass.getText());
            }
            if (this.wStoreClass != null) {
                this.params.setStoreClass(this.wStoreClass.getText());
            }
            if (this.wManagementClass != null) {
                this.params.setManagementClass(this.wManagementClass.getText());
            }
        }
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)true), (Object)GUI.grid.d.fillAll());
        Group expirationGroup = GUI.group((Composite)parent, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_TITLE, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        this.wExpirationChoice[0] = GUI.button.radio((Composite)expirationGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_UNSET, (Object)GUI.grid.d.fillH((int)2));
        this.wExpirationChoice[1] = GUI.button.radio((Composite)expirationGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_SPECIFY, (Object)GUI.grid.d.left1());
        this.wExpirationDate = GUI.datetime.date((Composite)expirationGroup, (Object)GUI.grid.d.left1());
        new FMWizardPage.ManagedWidget(this, this.wExpirationDate, this.params.getHost());
        this.wExpirationChoice[2] = GUI.button.radio((Composite)expirationGroup, (String)Messages.Msg_ALLOCATE_WIZARD_PAGE_STORAGE_EXPIRATION_NOLIMIT, (Object)GUI.grid.d.fillH((int)2));
        new FMWizardPage.ManagedWidget(this, this.wExpirationChoice, this.params.getHost()){

            @Override
            public void onChange(Event event) {
                AllocateDataSetWizardPageStorage.this.wExpirationDate.setEnabled(AllocateDataSetWizardPageStorage.this.isSelected((Control)AllocateDataSetWizardPageStorage.this.wExpirationChoice[1]));
            }
        };
        GUI.grid.padding((Composite)parent, (int)1);
        Group storageGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE_SPACE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__PRIMARY, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__SECONDARY, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)storageGroup, (String)Messages.Label__UNITS, (Object)GUI.grid.d.left1());
        this.wAllocationPrimary = GUI.combo.editable((Composite)storageGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfAP = NumberForcer.addTo(this.wAllocationPrimary, ((Object)((Object)this)).getClass().getCanonicalName() + "AllocationPrimary");
        nfAP.setLowerBound(1, true);
        new FMWizardPage.ManagedWidget(this, this.wAllocationPrimary, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__PRIMARY), this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (AllocateDataSetWizardPageStorage.this.params.getDataSetType() != DataSetType.PS && AllocateDataSetWizardPageStorage.this.params.getDataSetType() != DataSetType.DA) {
                    if (AllocateDataSetWizardPageStorage.this.getWizard().getContainer().getCurrentPage() == AllocateDataSetWizardPageStorage.this) {
                        return !AllocateDataSetWizardPageStorage.this.isEmpty(AllocateDataSetWizardPageStorage.this.wAllocationPrimary);
                    }
                    return AllocateDataSetWizardPageStorage.this.params.getAllocationPrimary().length() > 0;
                }
                return true;
            }
        };
        this.wAllocationSecondary = GUI.combo.editable((Composite)storageGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer nfAS = NumberForcer.addTo(this.wAllocationSecondary, ((Object)((Object)this)).getClass().getCanonicalName() + "AllocationSecondary");
        nfAS.setLowerBound(0, true);
        new FMWizardPage.ManagedWidget(this, this.wAllocationSecondary, this.params.getHost());
        this.wAllocationUnits = GUI.combo.readOnly((Composite)storageGroup, (Object)GUI.grid.d.left1(), (Object[])DSAQ.SpaceUnit.values());
        new ComboValueSaver(this.wAllocationUnits, ((Object)((Object)this)).getClass().getCanonicalName() + "AllocationUnits");
        new FMWizardPage.ManagedWidget(this, this.wAllocationUnits, this.params.getHost());
        Group smsGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE_SMS, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)compWidth));
        GUI.label.left((Composite)smsGroup, (String)Messages.Label__DATA_CLASS, (Object)GUI.grid.d.left1());
        this.wDataClass = GUI.combo.editable((Composite)smsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDataClass, ((Object)((Object)this)).getClass().getCanonicalName() + "DataClass");
        new FMWizardPage.ManagedWidget(this, this.wDataClass, this.params.getHost());
        GUI.label.left((Composite)smsGroup, (String)Messages.Label__STORE_CLASS, (Object)GUI.grid.d.left1());
        this.wStoreClass = GUI.combo.editable((Composite)smsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wStoreClass, ((Object)((Object)this)).getClass().getCanonicalName() + "StoreClass");
        new FMWizardPage.ManagedWidget(this, this.wStoreClass, this.params.getHost());
        GUI.label.left((Composite)smsGroup, (String)Messages.Label__MANAGEMENT_CLASS, (Object)GUI.grid.d.left1());
        this.wManagementClass = GUI.combo.editable((Composite)smsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wManagementClass, ((Object)((Object)this)).getClass().getCanonicalName() + "ManagementClass");
        new FMWizardPage.ManagedWidget(this, this.wManagementClass, this.params.getHost());
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel params = this.params.clone();
        if (params.getExpirationDate() == null) {
            this.wExpirationChoice[0].setSelection(true);
            this.wExpirationDate.setEnabled(false);
        } else if (params.getExpirationDate().get(1) == 1999 && params.getExpirationDate().get(6) == 365) {
            this.wExpirationChoice[2].setSelection(true);
            this.wExpirationDate.setEnabled(false);
        } else {
            this.wExpirationChoice[1].setSelection(true);
            this.wExpirationDate.setEnabled(true);
            GUI.datetime.set((DateTime)this.wExpirationDate, (Calendar)params.getExpirationDate());
        }
        this.wAllocationPrimary.setText(params.getAllocationPrimary());
        this.wAllocationSecondary.setText(params.getAllocationSecondary());
        if (params.getAllocationUnits() != null) {
            this.wAllocationUnits.select(ArrayUtils.findIndexOf((Object)params.getAllocationUnits(), (Object[])DSAQ.SpaceUnit.values(), (int)0));
        }
        this.wDataClass.setText(params.getDataClass());
        this.wStoreClass.setText(params.getStoreClass());
        this.wManagementClass.setText(params.getManagementClass());
    }
}

