/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageStorage;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.NumberUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AllocateDataSetWizardPageQSAM
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String RECORD_FORMAT_CHOICE_KEY = "wRecordFormatChoice";
    private static final String[] DEVICE_TYPE_DEFAULT_VALUES = new String[]{"SYSDA", "SYSALLDA", "3390"};
    private final AllocateDataSetModel params;
    private Combo wVolumeSerial;
    private Combo wDeviceType;
    private Combo wSpaceType;
    private Combo wDirectoryBlocks;
    private Label wDirectoryBlocksLabel;
    private Button[] wRecordFormatChoice = new Button[2];
    private Label[] wRecordFormatOptionsLabels = new Label[3];
    private Button[] wRecordFormatOptionsLength = new Button[3];
    private Button[] wRecordFormatOptionsMisc = new Button[3];
    private Button[] wRecordFormatOptionsControl = new Button[2];
    private Text wRecordFormat;
    private Combo wRecordLength;
    private Combo wBlockSize;
    private Label dataSetVersionLabel;
    private Label maxgenerationLabel;
    private Combo wDataSetVersion;
    private Combo wMaxgeneration;
    private Combo keyLabelText;
    private ArrayList<Control> recfmControls = new ArrayList();

    protected AllocateDataSetWizardPageQSAM(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_PAGE_STORAGE1);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_SPECIFY_OPTIONS);
    }

    public void setPageComplete(boolean complete) {
        Control focusControl = null;
        for (Control c : this.recfmControls) {
            if (!c.isFocusControl()) continue;
            focusControl = c;
        }
        if (complete) {
            if (this.wVolumeSerial != null) {
                this.params.setQSAMvolumeSerial(this.wVolumeSerial.getText());
            }
            if (this.wDeviceType != null) {
                this.params.setQSAMdeviceType(this.wDeviceType.getText());
            }
            if (this.wSpaceType != null) {
                this.params.setQSAMdataSetType((DSAQ.QsamSpaceType)EnumUtils.lookup(DSAQ.QsamSpaceType.class, (String)this.wSpaceType.getText()));
            }
            if (this.wRecordLength != null) {
                this.params.setQSAMrecordLength(this.wRecordLength.getText());
            }
            if (this.wBlockSize != null) {
                this.params.setQSAMblockSize(this.wBlockSize.getText());
            }
            if (this.wDirectoryBlocks != null) {
                this.params.setQSAMdirectoryBlocks(this.wDirectoryBlocks.getText());
            }
            if (this.isSelected((Control)this.wRecordFormatChoice[0]) && this.wRecordFormat != null) {
                Object text2 = "";
                if (this.isSelected((Control)this.wRecordFormatOptionsLength[0])) {
                    text2 = (String)text2 + "U";
                } else if (this.isSelected((Control)this.wRecordFormatOptionsLength[1])) {
                    text2 = (String)text2 + "F";
                } else if (this.isSelected((Control)this.wRecordFormatOptionsLength[2])) {
                    text2 = this.isSelected((Control)this.wRecordFormatOptionsMisc[0]) ? (String)text2 + "D" : (String)text2 + "V";
                }
                if (this.isSelected((Control)this.wRecordFormatOptionsMisc[1])) {
                    text2 = (String)text2 + "B";
                }
                if (this.isSelected((Control)this.wRecordFormatOptionsMisc[2])) {
                    text2 = (String)text2 + "S";
                }
                if (this.isSelected((Control)this.wRecordFormatOptionsControl[0])) {
                    text2 = (String)text2 + "M";
                } else if (this.isSelected((Control)this.wRecordFormatOptionsControl[1])) {
                    text2 = (String)text2 + "A";
                }
                this.params.setQSAMrecordFormat((DSAQ.QsamRecordFormat)EnumUtils.lookup(DSAQ.QsamRecordFormat.class, (String)text2));
                if (!((String)text2).equals(this.wRecordFormat.getText())) {
                    this.enable((Control)this.wRecordFormat);
                    if (this.params.getQSAMrecordFormat() == null) {
                        this.wRecordFormat.setText("U");
                    } else {
                        this.wRecordFormat.setText(this.params.getQSAMrecordFormat().toString());
                    }
                }
            }
            if (this.isSelected((Control)this.wRecordFormatChoice[1]) && this.wRecordFormat != null) {
                this.params.setQSAMrecordFormat((DSAQ.QsamRecordFormat)EnumUtils.lookup(DSAQ.QsamRecordFormat.class, (String)this.wRecordFormat.getText()));
            }
            FMUIPlugin.getDefault().getDialogSettings().put(RECORD_FORMAT_CHOICE_KEY, this.wRecordFormatChoice[1].getSelection());
        }
        if (this.isSelected((Control)this.wRecordFormatChoice[1])) {
            this.enable((Control[])this.wRecordFormatOptionsLabels);
            this.enable((Control[])this.wRecordFormatOptionsLength);
            this.enable((Control[])this.wRecordFormatOptionsControl);
            this.enable((Control[])this.wRecordFormatOptionsMisc);
            this.updateRecordFormatOptionSelections();
        }
        this.disable((Control[])this.wRecordFormatOptionsLabels);
        this.disable((Control[])this.wRecordFormatOptionsLength);
        this.disable((Control[])this.wRecordFormatOptionsMisc);
        this.disable((Control[])this.wRecordFormatOptionsControl);
        this.disable((Control)this.wRecordFormat);
        if (this.isSelected((Control)this.wRecordFormatChoice[0])) {
            this.enable((Control[])this.wRecordFormatOptionsLength);
            if (this.isSelected((Control)this.wRecordFormatOptionsLength[0])) {
                this.enable((Control)this.wRecordFormatOptionsLabels[0]);
            } else {
                this.enable((Control[])this.wRecordFormatOptionsLabels);
            }
            if (this.isSelected((Control)this.wRecordFormatOptionsLength[1])) {
                this.enable((Control)this.wRecordFormatOptionsMisc[1]);
                this.enable((Control[])this.wRecordFormatOptionsControl);
            }
            if (this.isSelected((Control)this.wRecordFormatOptionsLength[2])) {
                this.enable((Control[])this.wRecordFormatOptionsMisc);
                if (!this.isSelected((Control)this.wRecordFormatOptionsMisc[0])) {
                    this.enable((Control)this.wRecordFormatOptionsControl[0]);
                }
                this.enable((Control)this.wRecordFormatOptionsControl[1]);
            }
        } else if (this.isSelected((Control)this.wRecordFormatChoice[1])) {
            this.enable((Control)this.wRecordFormat);
        }
        if (focusControl != null) {
            focusControl.setFocus();
        }
        this.setEnabledIf((Control)this.wBlockSize, this.isSelected((Control)this.wRecordFormatOptionsMisc[1]) || this.isSelected((Control)this.wRecordFormatOptionsLength[0]));
        this.setEnabledIf((Control)this.wRecordLength, this.isSelected((Control)this.wRecordFormatOptionsLength[1]) || this.isSelected((Control)this.wRecordFormatOptionsLength[2]));
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group basicGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_QSAM_ALLOCATION_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wVolumeSerial = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wVolumeSerial, ((Object)((Object)this)).getClass().getCanonicalName() + "VolumeSerial");
        new FMWizardPage.ManagedWidget(this, this.wVolumeSerial, Messages.INVALID_VOLSER, this.params.getHost()){

            @Override
            protected boolean isValid() {
                String volser = AllocateDataSetWizardPageQSAM.this.wVolumeSerial.getText();
                return volser.isEmpty() || Volume.isValid((String)volser, (String)AllocateDataSetWizardPageQSAM.this.params.getSystem().getCodePage());
            }
        };
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__SPACE_TYPE, (Object)GUI.grid.d.left1());
        this.wSpaceType = GUI.combo.readOnly((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])new Object[0]);
        new FMWizardPage.ManagedWidget(this, this.wSpaceType, this.params.getHost());
        GUI.label.left((Composite)basicGroup, (String)Messages.Label__DEVICE_TYPE, (Object)GUI.grid.d.left1());
        this.wDeviceType = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        ComboValueSaver cvsDT = new ComboValueSaver(this.wDeviceType, ((Object)((Object)this)).getClass().getCanonicalName() + "DeviceType");
        cvsDT.setCustomItems(DEVICE_TYPE_DEFAULT_VALUES, false, false);
        new FMWizardPage.ManagedWidget(this, this.wDeviceType, this.params.getHost());
        this.wDirectoryBlocksLabel = GUI.label.left((Composite)basicGroup, (String)Messages.Label__DIRECTORY_BLOCKS_LIBRARY_ONLY, (Object)GUI.grid.d.left1());
        this.wDirectoryBlocks = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDirectoryBlocks, ((Object)((Object)this)).getClass().getCanonicalName() + "DirectoryBlocks");
        new FMWizardPage.ManagedWidget(this, this.wDirectoryBlocks, this.params.getHost());
        this.dataSetVersionLabel = GUI.label.left((Composite)basicGroup, (String)Messages.Label_DATASET_VERSION, (Object)GUI.grid.d.left1());
        this.wDataSetVersion = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wDataSetVersion, ((Object)((Object)this)).getClass().getCanonicalName() + "DataSetVersion");
        new FMWizardPage.ManagedWidget(this, this.wDataSetVersion, this.params.getHost()){

            @Override
            public void onChange(Event event) {
                int dataSetVer = Integer.parseInt(AllocateDataSetWizardPageQSAM.this.wDataSetVersion.getText());
                if (dataSetVer <= 1) {
                    AllocateDataSetWizardPageQSAM.this.wMaxgeneration.setText("");
                    AllocateDataSetWizardPageQSAM.this.wMaxgeneration.setEnabled(false);
                    AllocateDataSetWizardPageQSAM.this.params.setDataSetVersion("" + dataSetVer);
                } else {
                    AllocateDataSetWizardPageQSAM.this.wMaxgeneration.setEnabled(true);
                    AllocateDataSetWizardPageQSAM.this.params.setDataSetVersion("" + dataSetVer);
                }
            }
        };
        this.maxgenerationLabel = GUI.label.left((Composite)basicGroup, (String)Messages.Label_DATASET_MAXGENS, (Object)GUI.grid.d.left1());
        this.wMaxgeneration = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wMaxgeneration, ((Object)((Object)this)).getClass().getCanonicalName() + "MaxGenration");
        new FMWizardPage.ManagedWidget(this, this.wMaxgeneration, this.params.getHost()){

            @Override
            public void onChange(Event event) {
                AllocateDataSetWizardPageQSAM.this.params.setMaxgens(AllocateDataSetWizardPageQSAM.this.wMaxgeneration.getText());
            }
        };
        if (HostVersion.getInstance().getVersion() >= 150105) {
            GUI.label.left((Composite)basicGroup, (String)Messages.DataSetProperties_PROPERTY_ENCRYPTION_KEY_LABEL, (Object)GUI.grid.d.left1());
            this.keyLabelText = GUI.combo.editable((Composite)basicGroup, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.keyLabelText, ((Object)((Object)this)).getClass().getCanonicalName() + "keyLabel");
            new FMWizardPage.ManagedWidget(this, this.keyLabelText, Messages.DataSetProperties_PROPERTY_KEY_LABEL, this.params.getHost()){

                @Override
                public void onChange(Event event) {
                    AllocateDataSetWizardPageQSAM.this.params.setKeyLabel(AllocateDataSetWizardPageQSAM.this.keyLabelText.getText().trim());
                }
            };
        }
        Group recfmGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_QSAM_RECORD_FORMAT, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.wRecordFormatChoice[0] = GUI.button.radio((Composite)recfmGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_RECORD_FORMAT_BY_OPTIONS, (Object)GUI.grid.d.fillH((int)4));
        this.wRecordFormatOptionsLabels[0] = GUI.label.left((Composite)recfmGroup, (String)Messages.Label__LENGTH, (Object)GUI.grid.d.left1());
        Composite recfmLengthComp = GUI.composite((Composite)recfmGroup, (Layout)GUI.grid.l.customMargins((int)4, (boolean)false, (int)0, (int)0), (Object)GUI.grid.d.fillH((int)3));
        this.wRecordFormatOptionsLength[0] = GUI.button.radio((Composite)recfmLengthComp, (String)Messages.__UNDEFINED, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordFormatOptionsLength[1] = GUI.button.radio((Composite)recfmLengthComp, (String)Messages.__FIXED, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordFormatOptionsLength[2] = GUI.button.radio((Composite)recfmLengthComp, (String)Messages.__VARIABLE, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wRecordFormatOptionsLength, Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_SPECIFY_RECFM_LENGTH_TYPE, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatChoice[0])) {
                    return true;
                }
                return AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[0]) || AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[1]) || AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[2]);
            }

            @Override
            public void onChange(Event event) {
                if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[0])) {
                    AllocateDataSetWizardPageQSAM.this.unselect((Control[])AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc);
                    AllocateDataSetWizardPageQSAM.this.unselect((Control[])AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsControl);
                } else if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[1])) {
                    AllocateDataSetWizardPageQSAM.this.unselect((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[0]);
                    AllocateDataSetWizardPageQSAM.this.unselect((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[2]);
                }
                if (!AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[1]) && !AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[2])) {
                    AllocateDataSetWizardPageQSAM.this.wRecordLength.setText("");
                }
            }
        };
        this.wRecordFormatOptionsLabels[2] = GUI.label.left((Composite)recfmGroup, (String)Messages.Label__MISC_OPTIONS, (Object)GUI.grid.d.left1());
        this.wRecordFormatOptionsMisc[0] = GUI.button.checkbox((Composite)recfmGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_QSAM_RECFM_ASCII, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordFormatOptionsMisc[1] = GUI.button.checkbox((Composite)recfmGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_QSAM_RECFM_BLOCKED, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordFormatOptionsMisc[2] = GUI.button.checkbox((Composite)recfmGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_QSAM_RECFM_SPANNED, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wRecordFormatOptionsMisc, this.params.getHost()){

            @Override
            public void onChange(Event event) {
                if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[0])) {
                    AllocateDataSetWizardPageQSAM.this.unselect((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsControl[0]);
                }
                if (!AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[1])) {
                    AllocateDataSetWizardPageQSAM.this.wBlockSize.setText("");
                }
            }
        };
        this.wRecordFormatOptionsLabels[1] = GUI.label.left((Composite)recfmGroup, (String)Messages.Label__PRINTING_CONTROL, (Object)GUI.grid.d.fillH((int)1));
        Composite recfmControlComp = GUI.composite((Composite)recfmGroup, (Layout)GUI.grid.l.customMargins((int)2, (boolean)false, (int)0, (int)0), (Object)GUI.grid.d.fillH((int)3));
        this.wRecordFormatOptionsControl[0] = GUI.button.checkbox((Composite)recfmControlComp, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_QSAM_RECFM_MACHINE_CHARS, (Object)GUI.grid.d.fillH((int)1));
        this.wRecordFormatOptionsControl[1] = GUI.button.checkbox((Composite)recfmControlComp, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_QSAM_RECFM_ASA_ANSI_CHARS, (Object)GUI.grid.d.fillH((int)1));
        new FMWizardPage.ManagedWidget(this, this.wRecordFormatOptionsControl, Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_PRINTING_CONTROL_EITHER_NOT_BOTH, this.params.getHost()){

            @Override
            protected boolean isValid() {
                return !AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsControl[0]) || !AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsControl[1]);
            }
        };
        this.wRecordFormatChoice[1] = GUI.button.radio((Composite)recfmGroup, (String)Messages._ALLOCATE_WIZARD_ALLOCATE_RECORD_FORMAT_BY_TEXT, (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)2));
        this.wRecordFormat = GUI.text.field((Composite)recfmGroup, (Object)GUI.grid.d.fillH((int)2));
        new FMWizardPage.ManagedWidget(this, this.wRecordFormat, Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_INVALID_MANUAL_RECFM, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatChoice[1])) {
                    return true;
                }
                return EnumUtils.lookup(DSAQ.QsamRecordFormat.class, (String)AllocateDataSetWizardPageQSAM.this.wRecordFormat.getText()) != null;
            }
        };
        new FMWizardPage.ManagedWidget(this, this.wRecordFormatChoice, Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_CHOOSE_RECFM_METHOD, this.params.getHost()){

            @Override
            protected boolean isValid() {
                return AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatChoice[0]) || AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatChoice[1]);
            }
        };
        this.recfmControls.addAll(Arrays.asList(this.wRecordFormatChoice));
        this.recfmControls.addAll(Arrays.asList(this.wRecordFormatOptionsLength));
        this.recfmControls.addAll(Arrays.asList(this.wRecordFormatOptionsMisc));
        this.recfmControls.addAll(Arrays.asList(this.wRecordFormatOptionsControl));
        this.recfmControls.add((Control)this.wRecordFormat);
        Group recfmOptionsGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_PAGE_QSAM_RECORD_FORMAT_OPTIONS, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        GUI.label.left((Composite)recfmOptionsGroup, (String)Messages.Label__RECORD_LENGTH, (Object)GUI.grid.d.left1());
        this.wRecordLength = GUI.combo.editable((Composite)recfmOptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wRecordLength, ((Object)((Object)this)).getClass().getCanonicalName() + "RecordLength");
        new FMWizardPage.ManagedWidget(this, this.wRecordLength, Messages.Msg_ALLOCATE_WIZARD_PAGE_QSAM_SPECIFY_RECFM_LENGTH_SIZE, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[1]) || AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[2])) {
                    String text2 = AllocateDataSetWizardPageQSAM.this.wRecordLength.getText();
                    try {
                        int recSize = Integer.parseInt(text2);
                        return text2.length() > 0 && recSize > 0;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void onChange(Event event) {
                if (AllocateDataSetWizardPageQSAM.this.params.getQSAMrecordFormat() == DSAQ.QsamRecordFormat.V) {
                    String recsize = AllocateDataSetWizardPageQSAM.this.wRecordLength.getText();
                    if (!recsize.isEmpty()) {
                        int blockSize = Integer.parseInt(recsize) + 4;
                        AllocateDataSetWizardPageQSAM.this.wBlockSize.setText(Integer.toString(blockSize));
                    } else {
                        AllocateDataSetWizardPageQSAM.this.wBlockSize.setText("");
                    }
                }
            }
        };
        GUI.label.left((Composite)recfmOptionsGroup, (String)Messages.Label__BLOCK_SIZE, (Object)GUI.grid.d.left1());
        this.wBlockSize = GUI.combo.editable((Composite)recfmOptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.wBlockSize, ((Object)((Object)this)).getClass().getCanonicalName() + "BlockSize");
        new FMWizardPage.ManagedWidget(this, this.wBlockSize, Messages.AllocateDataSetWizardPageQSAM_0, this.params.getHost()){

            @Override
            protected boolean isValid() {
                int blockSize = NumberUtils.parseInt((String)AllocateDataSetWizardPageQSAM.this.wBlockSize.getText());
                if (blockSize <= 0) {
                    DSAQ.SpaceUnit u = AllocateDataSetWizardPageQSAM.this.params.getAllocationUnits();
                    return u == null || !u.equals((Object)DSAQ.SpaceUnit.BLK);
                }
                int recordLength = NumberUtils.parseInt((String)AllocateDataSetWizardPageQSAM.this.wRecordLength.getText().trim());
                if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[1]) && recordLength > 0 && blockSize > 0) {
                    if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[2])) {
                        if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsMisc[2])) {
                            return true;
                        }
                        return blockSize >= recordLength + 4;
                    }
                    if (AllocateDataSetWizardPageQSAM.this.isSelected((Control)AllocateDataSetWizardPageQSAM.this.wRecordFormatOptionsLength[1])) {
                        return blockSize % recordLength == 0;
                    }
                    return AllocateDataSetWizardPageQSAM.this.wBlockSize.getText().length() > 0;
                }
                return true;
            }
        };
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel params = this.params.clone();
        this.wVolumeSerial.setText(params.getQSAMvolumeSerial());
        this.wDeviceType.setText(params.getQSAMdeviceType());
        if (params.getDataSetType() == DataSetType.LIBRARY) {
            this.wSpaceType.setItems(new String[]{DSAQ.QsamSpaceType.LIBRARY.toString()});
            this.wSpaceType.select(0);
        } else if (params.getDataSetType() == DataSetType.PDS) {
            this.wSpaceType.setItems(new String[]{DSAQ.QsamSpaceType.PDS.toString()});
            this.wSpaceType.select(0);
        } else {
            this.wSpaceType.setItems(new String[]{DSAQ.QsamSpaceType.BASIC.toString(), DSAQ.QsamSpaceType.EXTR.toString(), DSAQ.QsamSpaceType.EXTP.toString(), DSAQ.QsamSpaceType.LARGE.toString()});
            this.wSpaceType.select(ArrayUtils.findIndexOf((Object)params.getQSAMdataSetType(), (Object[])DSAQ.QsamSpaceType.values(), (int)0));
        }
        this.wRecordFormat.setText(params.getQSAMrecordFormat() == null ? "" : params.getQSAMrecordFormat().toString());
        if (FMUIPlugin.getDefault().getDialogSettings().getBoolean(RECORD_FORMAT_CHOICE_KEY)) {
            this.wRecordFormatChoice[0].setSelection(false);
            this.wRecordFormatChoice[1].setSelection(true);
        } else {
            this.wRecordFormatChoice[0].setSelection(true);
            this.wRecordFormatChoice[1].setSelection(false);
        }
        this.updateRecordFormatOptionSelections();
        this.wRecordLength.setText(params.getQSAMrecordLength());
        this.wBlockSize.setText(params.getQSAMblockSize());
        this.wDirectoryBlocks.setText(params.getQSAMdirectoryBlocks());
        this.wDirectoryBlocks.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY || params.getQSAMdataSetType() == DSAQ.QsamSpaceType.PDS);
        this.wDirectoryBlocksLabel.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY || params.getQSAMdataSetType() == DSAQ.QsamSpaceType.PDS);
        this.wDataSetVersion.setText(params.getDataSetVersion());
        this.wMaxgeneration.setText(params.getMaxgens());
        this.dataSetVersionLabel.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY);
        this.wDataSetVersion.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY);
        this.maxgenerationLabel.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY);
        this.wMaxgeneration.setEnabled(params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY);
        if (HostVersion.getInstance().getVersion() >= 150105) {
            this.keyLabelText.setText(params.getKeyLabel());
        }
    }

    private void updateRecordFormatOptionSelections() {
        char[] text2;
        this.unselect((Control[])this.wRecordFormatOptionsLength);
        this.unselect((Control[])this.wRecordFormatOptionsControl);
        this.unselect((Control[])this.wRecordFormatOptionsMisc);
        if (this.params.getQSAMrecordFormat() == null) {
            return;
        }
        char[] cArray = text2 = this.params.getQSAMrecordFormat().toString().toCharArray();
        int n = text2.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'U': {
                    this.select((Control)this.wRecordFormatOptionsLength[0]);
                    this.unselect((Control[])this.wRecordFormatOptionsControl);
                    this.unselect((Control[])this.wRecordFormatOptionsMisc);
                    break;
                }
                case 'F': {
                    this.select((Control)this.wRecordFormatOptionsLength[1]);
                    this.unselect((Control)this.wRecordFormatOptionsMisc[2]);
                    break;
                }
                case 'V': {
                    this.select((Control)this.wRecordFormatOptionsLength[2]);
                    break;
                }
                case 'D': {
                    this.select((Control)this.wRecordFormatOptionsLength[2]);
                    this.unselect((Control)this.wRecordFormatOptionsControl[0]);
                    this.select((Control)this.wRecordFormatOptionsMisc[0]);
                    break;
                }
                case 'M': {
                    this.select((Control)this.wRecordFormatOptionsControl[0]);
                    break;
                }
                case 'A': {
                    this.select((Control)this.wRecordFormatOptionsControl[1]);
                    break;
                }
                case 'B': {
                    this.select((Control)this.wRecordFormatOptionsMisc[1]);
                    break;
                }
                case 'S': {
                    this.select((Control)this.wRecordFormatOptionsMisc[2]);
                    break;
                }
            }
            ++n2;
        }
    }

    public IWizardPage getNextPage() {
        return this.getPage(AllocateDataSetWizardPageStorage.class);
    }
}

