/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageGDG
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2024. All rights reserved.";
    private final AllocateDataSetModel params;
    private Combo wLimit;
    private Combo wCatalog;
    private Combo wOwner;
    private Button wEmpty;
    private Button wScratch;
    private Button wExtended;
    private Button wFifo;
    private Button wPurge;

    protected AllocateDataSetWizardPageGDG(AllocateDataSetModel params) {
        super(Messages.Title_ALLOCATE_WIZARD_GDG);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_GDG_SPECIFY_OPTIONS);
        params.setFMVRM(params.requestFMVRM());
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            if (this.wLimit != null) {
                this.params.setVSAMlimit(this.wLimit.getText());
            }
            if (this.wCatalog != null) {
                this.params.setVSAMcatalog(this.wCatalog.getText());
            }
            if (this.wOwner != null) {
                this.params.setVSAMowner(this.wOwner.getText());
            }
            this.params.setVSAMempty(this.isSelected((Control)this.wEmpty));
            this.params.setVSAMscratch(this.isSelected((Control)this.wScratch));
            this.params.setVSAMextended(this.isSelected((Control)this.wExtended));
            this.params.setVSAMfifo(this.isSelected((Control)this.wFifo));
            this.params.setVSAMpurge(this.isSelected((Control)this.wPurge));
        }
        super.setPageComplete(complete);
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 1;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)compWidth, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group requiredGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_GDG_REQUIRED, (Layout)GUI.grid.l.margins((int)6, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)requiredGroup, (String)Messages.Label__LIMIT, (Object)GUI.grid.d.left1());
        this.wLimit = GUI.combo.editable((Composite)requiredGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wLimit.setToolTipText(Messages.AllocateDataSetWizardGDG_LIMIT_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wLimit, Messages.AllocateDataSetWizardGDG_LIMIT_VALIDATION, this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (!AllocateDataSetWizardPageGDG.this.wLimit.getText().isEmpty()) {
                    return AllocateDataSetWizardPageGDG.validLimit(AllocateDataSetWizardPageGDG.this.wLimit.getText());
                }
                return AllocateDataSetWizardPageGDG.this.params.getDataSetType() != DataSetType.GDG;
            }
        };
        GUI.grid.padding((Composite)requiredGroup, (int)4);
        Group optionalGroup = GUI.group((Composite)parent, (String)Messages.Title_ALLOCATE_WIZARD_GDG_OPTIONAL, (Layout)GUI.grid.l.margins((int)6, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)optionalGroup, (String)Messages.Label__CATALOG, (Object)GUI.grid.d.left1());
        this.wCatalog = GUI.combo.editable((Composite)optionalGroup, (Object)GUI.grid.d.fillH((int)5));
        this.wCatalog.setToolTipText(Messages.AllocateDataSetWizardGDG_CATALOG_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wCatalog, this.params.getHost());
        GUI.label.left((Composite)optionalGroup, (String)Messages.Label__OWNER, (Object)GUI.grid.d.left1());
        this.wOwner = GUI.combo.editable((Composite)optionalGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wOwner.setToolTipText(Messages.AllocateDataSetWizardGDG_OWNER_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wOwner, this.params.getHost());
        GUI.grid.padding((Composite)optionalGroup, (int)3);
        this.wEmpty = GUI.button.checkbox((Composite)optionalGroup, (String)Messages.Label__EMPTY, (Object)GUI.grid.d.fillH((int)1));
        this.wEmpty.setToolTipText(Messages.AllocateDataSetWizardGDG_EMPTY_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wEmpty, this.params.getHost());
        this.wScratch = GUI.button.checkbox((Composite)optionalGroup, (String)Messages.Label__SCRATCH, (Object)GUI.grid.d.fillH((int)1));
        this.wScratch.setToolTipText(Messages.AllocateDataSetWizardGDG_SCRATCH_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wScratch, this.params.getHost());
        this.wExtended = GUI.button.checkbox((Composite)optionalGroup, (String)Messages.Label__EXTENDED, (Object)GUI.grid.d.fillH((int)1));
        this.wExtended.setToolTipText(Messages.AllocateDataSetWizardGDG_EXTENDED_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wExtended, this.params.getHost());
        this.wFifo = GUI.button.checkbox((Composite)optionalGroup, (String)Messages.Label__FIFO, (Object)GUI.grid.d.fillH((int)1));
        this.wFifo.setToolTipText(Messages.AllocateDataSetWizardGDG_FIFO_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wFifo, this.params.getHost());
        this.wPurge = GUI.button.checkbox((Composite)optionalGroup, (String)Messages.Label__PURGE, (Object)GUI.grid.d.fillH((int)1));
        this.wPurge.setToolTipText(Messages.AllocateDataSetWizardGDG_PURGE_TOOLTIP);
        new FMWizardPage.ManagedWidget(this, this.wPurge, this.params.getHost());
        if (this.params.getFMVRM() < 140113) {
            this.wExtended.setEnabled(false);
            this.wFifo.setEnabled(false);
            this.wPurge.setEnabled(false);
        }
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel tempParams = this.params.clone();
        this.wLimit.setText(tempParams.getVSAMlimit());
        this.wCatalog.setText(tempParams.getVSAMcatalog());
        this.wOwner.setText(tempParams.getVSAMowner());
        if (tempParams.isVSAMempty()) {
            this.select((Control)this.wEmpty);
        }
        if (tempParams.isVSAMscratch()) {
            this.select((Control)this.wScratch);
        }
        if (this.params.getFMVRM() >= 140113) {
            if (tempParams.isVSAMextended()) {
                this.select((Control)this.wExtended);
            }
            if (tempParams.isVSAMfifo()) {
                this.select((Control)this.wFifo);
            }
            if (tempParams.isVSAMpurge()) {
                this.select((Control)this.wPurge);
            }
        }
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private static boolean validLimit(String value) {
        int limit;
        try {
            limit = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            limit = 0;
        }
        return limit >= 1 && limit <= 999;
    }
}

