/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.jhost.core.util.EnumUtils;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageGDG;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageQSAM;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageStorage;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageVSAM1;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizardPageVSAM3KSDS;
import com.ibm.etools.fm.ui.wizards.FMWizardPage;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AllocateDataSetWizardPageFirst
extends FMWizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final long ALLOCATE_LIKE_UPDATE_DELAY = 750L;
    private final AllocateDataSetModel params;
    private Set<IPDHost> possibleHosts = new HashSet<IPDHost>();
    private ComboViewer wDataSetSystemViewer;
    private Combo wDataSet;
    private ComboViewer wAllocateLikeSystemViewer;
    private Combo wAllocateLike;
    private Combo wDataSetType;
    private boolean updateAllocateLikeCompleted = false;
    private Job updateAllocateLikeJob = new Job(Messages.Job__LOADING_PROPERTIES){

        protected IStatus run(IProgressMonitor monitor) {
            DataSet allocateLike = AllocateDataSetWizardPageFirst.this.params.getAllocateLike();
            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
            if (allocateLike != null && allocateLike.getProperties() == null) {
                try {
                    allocateLike.refreshSelf(howIsGoing);
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"cancelled allocate data set properties fetching via refreshSelf()");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
            }
            AllocateDataSetWizardPageFirst.this.params.updateFromAllocateLikeProperties();
            AllocateDataSetWizardPageFirst.this.updateAllocateLikeCompleted = true;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AllocateDataSetModel params = (this).AllocateDataSetWizardPageFirst.this.params.clone();
                    int index = ArrayUtils.findIndexOf((Object)params.getDataSetType(), (Object[])params.getPossibleTypes(), (int)0);
                    if (!(this).AllocateDataSetWizardPageFirst.this.wDataSetType.isDisposed()) {
                        (this).AllocateDataSetWizardPageFirst.this.wDataSetType.select(index);
                    }
                    AllocateDataSetWizardPageFirst.this.safeValidateManagedWidgets();
                }
            });
            return Status.OK_STATUS;
        }
    };

    protected AllocateDataSetWizardPageFirst(AllocateDataSetModel params) {
        super(Messages.Title__BASIC_OPTIONS);
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
        this.possibleHosts = new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all());
        this.setMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_FIRST_SPECIFY_OPTIONS);
        this.setPageComplete(false);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            this.params.setDataSetName(this.wDataSet.getText().toUpperCase());
            StructuredSelection structuredSelection = (StructuredSelection)this.wAllocateLikeSystemViewer.getSelection();
            Object firstElement = structuredSelection.getFirstElement();
            this.params.setAllocateLikeSystem((IPDHost)firstElement);
            if (this.wAllocateLike != null && DataSet.isValidName((String)this.wAllocateLike.getText(), (String)this.params.getHost().getCodePage())) {
                DataSet newAllocateLike;
                IPDHost host = this.params.getSystem();
                if (this.params.getAllocateLikeSystem() != null) {
                    host = this.params.getAllocateLikeSystem();
                }
                if (!(newAllocateLike = DataSet.create((IPDHost)host, (String)this.wAllocateLike.getText())).equals((Object)this.params.getAllocateLike())) {
                    this.params.setAllocateLike(newAllocateLike);
                    this.updateAllocateLikeCompleted = false;
                    this.updateAllocateLikeJob.cancel();
                }
            } else {
                this.params.setAllocateLike(null);
            }
            if (this.params.getAllocateLike() != null) {
                boolean bl = this.updateAllocateLikeCompleted = this.updateAllocateLikeCompleted || this.params.getAllocateLike().getProperties() != null && this.params.isUpdatedFromAllocateLike();
            }
            if (!this.updateAllocateLikeCompleted && this.params.getAllocateLike() != null) {
                if (this.params.getAllocateLike().getProperties() == null) {
                    this.updateAllocateLikeJob.schedule(750L);
                } else {
                    this.updateAllocateLikeJob.schedule();
                }
            }
            this.updateDataSetType(this.wDataSetType.getText());
            this.getPage(AllocateDataSetWizardPageStorage.class).safeValidateManagedWidgets();
            this.getPage(AllocateDataSetWizardPageVSAM3KSDS.class).safeValidateManagedWidgets();
        }
        if (this.updateAllocateLikeCompleted && this.params.getAllocateLike() != null && this.params.getAllocateLike().getProperties() == null) {
            this.setErrorMessage(Messages.Msg_ALLOCATE_WIZARD_PAGE_FIRST_NONEXISTENT_ALLOCATE_LIKE);
        } else if (this.updateAllocateLikeCompleted && this.params.getAllocateLike() != null && (this.params.getAllocateLike().getType() == null || ArrayUtils.findIndexOf((Object)this.params.getAllocateLike().getType(), (Object[])this.params.getPossibleTypes(), (int)-1) == -1)) {
            this.setErrorMessage(MessageFormat.format(Messages.AllocateDataSetWizardPageFirst_ALLOCATE_LIKE_TYPE_NOT_SUPPORTED, this.params.getAllocateLike().getType().toString()));
        } else if (complete) {
            this.setErrorMessage(null);
        }
        if (!complete && this.wAllocateLike != null && !this.wAllocateLike.isDisposed() && this.wAllocateLike.isFocusControl()) {
            this.updateAllocateLikeJob.cancel();
        }
        if (this.params.getAllocateLike() != null) {
            boolean allocateLikeTypeIsValid = ArrayUtils.findIndexOf((Object)this.params.getAllocateLike().getType(), (Object[])this.params.getPossibleTypes(), (int)-1) != -1;
            super.setPageComplete(complete && this.updateAllocateLikeCompleted && this.params.getAllocateLike().getProperties() != null && allocateLikeTypeIsValid);
        } else {
            super.setPageComplete(complete);
        }
    }

    private void updateDataSetType(String text2) {
        this.params.setDataSetType((DataSetType)EnumUtils.lookup(DataSetType.class, (String)text2));
        if (this.params.getDataSetType() == DataSetType.PDS) {
            this.params.setQSAMdataSetType(DSAQ.QsamSpaceType.PDS);
        } else if (this.params.getDataSetType() == DataSetType.LIBRARY) {
            this.params.setQSAMdataSetType(DSAQ.QsamSpaceType.LIBRARY);
        } else if (this.params.getQSAMdataSetType() == DSAQ.QsamSpaceType.PDS || this.params.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY) {
            this.params.setQSAMdataSetType(DSAQ.QsamSpaceType.BASIC);
        }
    }

    @Override
    public void createControl(Composite parent) {
        int compWidth = 3;
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.wDataSetSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer(parent, this.possibleHosts, this.params.getSystem());
        this.wDataSetSystemViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)parent, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_SET, (Object)GUI.grid.d.left1());
        this.wDataSet = GUI.combo.editable((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupResourceButtonLeft1(parent), this.wDataSet, this.params).noAllocate().addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "DataSet").create();
        this.wDataSet.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new FMWizardPage.ManagedWidget(this, this.wDataSet, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__DATA_SET), this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (AllocateDataSetWizardPageFirst.this.wAllocateLike != null && !AllocateDataSetWizardPageFirst.this.wAllocateLike.isDisposed() && AllocateDataSetWizardPageFirst.this.wAllocateLike.getText().toUpperCase().equals(AllocateDataSetWizardPageFirst.this.wDataSet.getText().toUpperCase())) {
                    return false;
                }
                if (!AllocateDataSetWizardPageFirst.this.wDataSet.isDisposed()) {
                    return DataSet.isValidNameOrGDG((String)AllocateDataSetWizardPageFirst.this.wDataSet.getText(), (String)AllocateDataSetWizardPageFirst.this.params.getHost().getCodePage());
                }
                return false;
            }
        };
        GUI.label.left((Composite)parent, (String)Messages.Label__DATA_SET_TYPE, (Object)GUI.grid.d.left1());
        this.wDataSetType = GUI.combo.readOnly((Composite)parent, (Object)GUI.grid.d.fillH((int)1), (Object[])this.params.getPossibleTypes());
        new ComboValueSaver(this.wDataSetType, ((Object)((Object)this)).getClass().getCanonicalName() + "DataSetType"){

            public void onRestore() {
                if (AllocateDataSetWizardPageFirst.this.params.getAllocateLike() == null) {
                    AllocateDataSetWizardPageFirst.this.safeValidateManagedWidgets();
                }
            }
        }.setDoRestore(this.params.getDataSetType() == DataSetType.UNKNOWN);
        new FMWizardPage.ManagedWidget(this, this.wDataSetType, this.params.getHost());
        Group allocateLikeGroup = GUI.group((Composite)parent, (String)Messages.AllocateDataSetWizardPageFirst_0, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)new GridData(4, 4, true, false, 3, 1));
        this.wAllocateLikeSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)allocateLikeGroup, this.possibleHosts, this.params.getSystem());
        this.wAllocateLikeSystemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!AllocateDataSetWizardPageFirst.this.wDataSet.getText().trim().equals("") && !AllocateDataSetWizardPageFirst.this.wAllocateLike.getText().trim().equals("")) {
                    AllocateDataSetWizardPageFirst.this.setPageComplete(true);
                }
            }
        });
        GUI.label.left((Composite)allocateLikeGroup, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)allocateLikeGroup, (String)Messages.Label__ALLOCATE_LIKE, (Object)GUI.grid.d.left1());
        this.wAllocateLike = GUI.combo.editable((Composite)allocateLikeGroup, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)allocateLikeGroup), this.wAllocateLike, new IHostProvider(){

            public IPDHost getSystem() {
                return (IPDHost)((StructuredSelection)AllocateDataSetWizardPageFirst.this.wAllocateLikeSystemViewer.getSelection()).getFirstElement();
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                AllocateDataSetWizardPageFirst.this.params.setAllocateLikeSystem(selectedHost);
                AllocateDataSetWizardPageFirst.this.params.setAllocateLike((DataSet)zrl);
                AllocateDataSetWizardPageFirst.this.updateControlValues();
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "AllocateLike").create();
        this.wAllocateLike.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new FMWizardPage.ManagedWidget(this, this.wAllocateLike, MessageFormat.format(Messages.Msg__X_IS_INVALID, Messages.Label__DATA_SET), this.params.getHost()){

            @Override
            protected boolean isValid() {
                if (AllocateDataSetWizardPageFirst.this.wDataSet != null && AllocateDataSetWizardPageFirst.this.wAllocateLike.getText().toUpperCase().equals(AllocateDataSetWizardPageFirst.this.wDataSet.getText().toUpperCase())) {
                    return false;
                }
                return AllocateDataSetWizardPageFirst.this.wAllocateLike.getText().isEmpty() || DataSet.isValidName((String)AllocateDataSetWizardPageFirst.this.wAllocateLike.getText(), (String)AllocateDataSetWizardPageFirst.this.params.getHost().getCodePage());
            }
        };
        this.refreshControlState();
        this.setControl((Control)parent);
    }

    @Override
    public void updateControlValues() {
        AllocateDataSetModel tempParams = this.params.clone();
        this.wDataSet.setText(tempParams.getDataSetName());
        this.wAllocateLikeSystemViewer.setSelection((ISelection)new StructuredSelection((Object)tempParams.getAllocateLikeSystem()));
        this.wAllocateLike.setText(tempParams.getAllocateLike() == null ? "" : tempParams.getAllocateLike().getName());
        this.wDataSetType.select(ArrayUtils.findIndexOf((Object)tempParams.getDataSetType(), (Object[])this.params.getPossibleTypes(), (int)0));
        this.wDataSet.setFocus();
    }

    public IWizardPage getNextPage() {
        if (this.params.getDataSetType().getAccessMethod() == DataSetType.AccessMethod.QSAM) {
            return this.getPage(AllocateDataSetWizardPageQSAM.class);
        }
        if (this.params.getDataSetType() == DataSetType.GDG) {
            return this.getPage(AllocateDataSetWizardPageGDG.class);
        }
        if (this.params.getDataSetType().getAccessMethod() == DataSetType.AccessMethod.VSAM) {
            return this.getPage(AllocateDataSetWizardPageVSAM1.class);
        }
        return null;
    }
}

