/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.views.systems.FMSystemsTreeUpdater;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;

public class AllocateDataSetRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final AllocateDataSetModel allocateParams;

    public AllocateDataSetRunnable(AllocateDataSetModel allocateParams) {
        this.allocateParams = allocateParams;
    }

    @Override
    protected String getName() {
        return Messages.AllocateDataSetRunnable_TASK_NAME;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        monitor.beginTask(this.getName(), 3);
        DataSet newDS = DataSet.create((IPDHost)this.allocateParams.getHost(), (String)this.allocateParams.getDataSetName());
        monitor.worked(1);
        try {
            result = this.allocateParams.allocateOnHost(monitor);
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.worked(1);
        if (result != null && result.getRC() <= 4) {
            FMSystemsTreeUpdater.refreshQueriesRelatedTo(newDS);
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().isSuccessfulWithoutWarnings();
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 0);
    }
}

