/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.core.socket.func.DSDV;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VER;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AllocateDataSetModel
implements IHostProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(AllocateDataSetModel.class);
    private static final DataSetType[] DEFAULT_POSSIBLE_TYPES = new DataSetType[]{DataSetType.PS, DataSetType.DA, DataSetType.PDS, DataSetType.LIBRARY, DataSetType.KSDS, DataSetType.RRDS, DataSetType.ESDS, DataSetType.LDS, DataSetType.GDG};
    private Pattern vrmPattern = Pattern.compile("FMNBA001.+?(\\d{1,2}).+?(\\d{1,2}).+?(\\d{1,2})");
    public static final int MIN_GDG_EXT_VERSION = 140113;
    private IPDHost host = null;
    private String dataSetName = "";
    private IPDHost allocateLikeSystem = null;
    private DataSet allocateLike = null;
    private DataSetType dataSetType = DataSetType.UNKNOWN;
    private DataSetType[] possibleTypes = AllocateDataSetModel.getDefaultPossibleTypes();
    private Calendar expirationDate = null;
    private String allocationPrimary = "";
    private String allocationSecondary = "";
    private DSAQ.SpaceUnit allocationUnits = null;
    private String dataClass = "";
    private String storeClass = "";
    private String managementClass = "";
    private DSAQ.QsamSpaceType QSAMdataSetType = DSAQ.QsamSpaceType.BASIC;
    private String QSAMvolumeSerial = "";
    private String QSAMdeviceType = "";
    private String QSAMrecordLength = "";
    private String QSAMblockSize = "";
    private String QSAMdirectoryBlocks = "";
    private DSAQ.QsamRecordFormat QSAMrecordFormat = DSAQ.QsamRecordFormat.U;
    private String VSAMkeyLength = "";
    private String VSAMkeyOffset = "";
    private String VSAMciSize = "";
    private String VSAMbufferSpace = "";
    private int VSAMshareCrossRegion = 1;
    private int VSAMshareCrossSystem = 3;
    private boolean VSAMreuse = false;
    private boolean VSAMrecovery = false;
    private boolean VSAMerase = false;
    private boolean VSAMspanned = false;
    private boolean VSAMwriteCheck = false;
    private String VSAMdataComponent = "";
    private String VSAMcatalog = "";
    private String VSAMrecsizeAverage = "";
    private String VSAMrecsizeMaximum = "";
    private String VSAMfreespaceCI = "";
    private String VSAMfreespaceCA = "";
    private String VSAMvolumeSerial = "";
    private String VSAMindexComponent = "";
    private String VSAMindexCISize = "";
    private String VSAMindexSpacePrimary = "";
    private String VSAMindexSpaceSecondary = "";
    private DSAQ.SpaceUnit VSAMindexAllocationUnit = null;
    private String VSAMindexVolumeSerial = "";
    private boolean VSAMscratch = false;
    private boolean VSAMempty = false;
    private boolean VSAMextended = false;
    private boolean VSAMfifo = false;
    private boolean VSAMpurge = false;
    private String VSAMlimit = "";
    private String VSAMowner = "";
    private boolean updatedFromAllocateLike;
    private int fm_vrm;
    private String dataSetVersion = "";
    private String maxgens = "";
    private String keyLabel = "";

    public static DataSetType[] getDefaultPossibleTypes() {
        return Arrays.copyOf(DEFAULT_POSSIBLE_TYPES, DEFAULT_POSSIBLE_TYPES.length);
    }

    public IPDHost getSystem() {
        Objects.requireNonNull(this.host);
        return this.host;
    }

    public void setAllocateLikeSystem(IPDHost allocateLikeSystem) {
        this.allocateLikeSystem = allocateLikeSystem;
    }

    public IPDHost getAllocateLikeSystem() {
        Objects.requireNonNull(this.allocateLikeSystem);
        return this.allocateLikeSystem;
    }

    public NewUtilityFunction toUtilityFunction() {
        if (this.getDataSetType().getAccessMethod() == DataSetType.AccessMethod.QSAM) {
            DSAQ dsaq = new DSAQ();
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNOUT, (Object)this.getDataSetName(), this.getSystem());
            if (this.getAllocateLike() != null && this.getSystem().equals(this.getAllocateLikeSystem())) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.LIKE, (Object)this.getAllocateLike().getName(), this.getSystem());
            }
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACEU, (Object)this.getAllocationUnits(), this.getSystem());
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACEP, (Object)this.getAllocationPrimary(), this.getSystem());
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACES, (Object)this.getAllocationSecondary(), this.getSystem());
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.VOLUME, (Object)this.getQSAMvolumeSerial(), this.getSystem());
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.UNIT, (Object)this.getQSAMdeviceType(), this.getSystem());
            if (!"PRIMARY".equals(this.getDataClass())) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DATACLAS, (Object)this.getDataClass(), this.getSystem());
            }
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.STORCLAS, (Object)this.getStoreClass(), this.getSystem());
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.MGMTCLAS, (Object)this.getManagementClass(), this.getSystem());
            if (this.getQSAMdataSetType() == DSAQ.QsamSpaceType.PDS) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DIR, (Object)this.getQSAMdirectoryBlocks(), this.getSystem());
            }
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.RECFMOUT, (Object)this.getQSAMrecordFormat(), this.getSystem());
            if (this.getQSAMrecordFormat().isFixedLength() || this.getQSAMrecordFormat().isVariableLength()) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.RECSIZE, (Object)this.getQSAMrecordLength(), this.getSystem());
            }
            if (this.getQSAMrecordFormat().isUndefinedLength() || this.getQSAMrecordFormat().isBlocked()) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.BLKSIZE, (Object)this.getQSAMblockSize(), this.getSystem());
            }
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNTYPE, (Object)this.getQSAMdataSetType(), this.getSystem());
            if (this.getExpirationDate() != null) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.EXPDT, (Object)(this.getExpirationDate().get(1) + "." + this.getExpirationDate().get(6)), this.getSystem());
            }
            if (this.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY) {
                dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNV, (Object)this.getDataSetVersion(), this.getSystem());
                if (Integer.parseInt(this.getDataSetVersion()) > 1) {
                    dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.NGEN, (Object)this.getMaxgens(), this.getSystem());
                }
            }
            dsaq.setValue((NewUtilityFunction.IUtilFuncParam)DSAQ.DSKEYLBL, (Object)this.getKeyLabel(), this.getSystem());
            return dsaq;
        }
        if (this.getDataSetType().getAccessMethod() == DataSetType.AccessMethod.VSAM) {
            DSDV dsdv = new DSDV();
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.DSNOUT, (Object)this.getDataSetName(), this.getSystem());
            if (this.dataSetType == DataSetType.GDG) {
                if (this.fm_vrm == 0) {
                    this.fm_vrm = this.requestFMVRM();
                }
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.TYPE, (Object)this.getDataSetType(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.LIMIT, (Object)this.getVSAMlimit(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.CATALOG, (Object)this.getVSAMcatalog(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.OWNER, (Object)this.getVSAMowner(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.EMPTY, (Object)this.isVSAMempty(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SCRATCH, (Object)this.isVSAMscratch(), this.getSystem());
                if (this.fm_vrm >= 140113) {
                    dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.EXTENDED, (Object)this.isVSAMextended(), this.getSystem());
                    dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.FIFO, (Object)this.isVSAMfifo(), this.getSystem());
                    dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.PURGE, (Object)this.isVSAMpurge(), this.getSystem());
                }
                return dsdv;
            }
            if (this.getAllocateLike() != null && this.getSystem().equals(this.getAllocateLikeSystem())) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.LIKE, (Object)this.getAllocateLike().getName(), this.getSystem());
            }
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SPACEU, (Object)this.getAllocationUnits(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SPACEP, (Object)this.getAllocationPrimary(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SPACES, (Object)this.getAllocationSecondary(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.TYPE, (Object)this.getDataSetType(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.CATALOG, (Object)this.getVSAMcatalog(), this.getSystem());
            if (this.getExpirationDate() != null) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.TO, (Object)(this.getExpirationDate().get(1) + "." + this.getExpirationDate().get(6)), this.getSystem());
            }
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.DATA, (Object)this.getVSAMdataComponent(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.INDEX, (Object)this.getVSAMindexComponent(), this.getSystem());
            if (this.getDataSetType() == DataSetType.KSDS || this.getDataSetType() == DataSetType.KSDSIAM) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.KEYLEN, (Object)this.getVSAMkeyLength(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.KEYOFF, (Object)this.getVSAMkeyOffset(), this.getSystem());
            }
            if (this.getDataSetType() != DataSetType.LDS) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.CISIZE, (Object)this.getVSAMciSize(), this.getSystem());
            }
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.BUFSP, (Object)this.getVSAMbufferSpace(), this.getSystem());
            if (1 <= this.getVSAMshareCrossRegion() && this.getVSAMshareCrossRegion() <= 4) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SHRREG, (Object)Integer.toString(this.getVSAMshareCrossRegion()), this.getSystem());
            } else {
                logger.warn(new Object[]{"Cross region share must be in range 1-4, ignoring: ", this.getVSAMshareCrossRegion()});
            }
            if (this.getVSAMshareCrossSystem() == 3 || this.getVSAMshareCrossSystem() == 4) {
                if (this.getVSAMshareCrossRegion() == 3 && this.getVSAMshareCrossSystem() == 4) {
                    logger.debug((Object)"Cross-system 4 cannot be combined with cross-region 3, ignoring cross-system param of 4");
                } else {
                    dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SHRSYS, (Object)Integer.toString(this.getVSAMshareCrossSystem()), this.getSystem());
                }
            } else {
                logger.warn(new Object[]{"Cross system share must be 3 or 4, ignoring: ", this.getVSAMshareCrossRegion()});
            }
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.REUSE, (Object)this.isVSAMreuse(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.RECOVERY, (Object)this.isVSAMrecovery(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SPANNED, (Object)this.isVSAMspanned(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.ERASE, (Object)this.isVSAMerase(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.WCHK, (Object)this.isVSAMwriteCheck(), this.getSystem());
            if (this.getDataSetType() != DataSetType.LDS) {
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.RECAVG, (Object)this.getVSAMrecsizeAverage(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.RECMAX, (Object)this.getVSAMrecsizeMaximum(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.FREECI, (Object)this.getVSAMfreespaceCI(), this.getSystem());
                dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.FREECA, (Object)this.getVSAMfreespaceCA(), this.getSystem());
            }
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.VOLUMES, (Object)this.getVSAMvolumeSerial(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.IVOLUMES, (Object)this.getVSAMindexVolumeSerial(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.ICISIZE, (Object)this.getVSAMindexCISize(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACEU, (Object)this.getVSAMindexAllocationUnit(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACEP, (Object)this.getVSAMindexSpacePrimary(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACES, (Object)this.getVSAMindexSpaceSecondary(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.DCLASS, (Object)this.getDataClass(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.SCLASS, (Object)this.getStoreClass(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.MCLASS, (Object)this.getManagementClass(), this.getSystem());
            dsdv.setValue((NewUtilityFunction.IUtilFuncParam)DSDV.DSKEYLBL, (Object)this.getKeyLabel(), this.getSystem());
            return dsdv;
        }
        throw new IllegalStateException(this.getDataSetType().getAccessMethod().name());
    }

    public void fromUtilityFunction(NewUtilityFunction function) {
        if (function instanceof DSAQ) {
            DSAQ dsaq = (DSAQ)function;
            this.setDataSetName((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNOUT, this.getSystem()));
            String like = (String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.LIKE, this.getSystem());
            if (like.isEmpty()) {
                this.setAllocateLike(null);
            } else {
                this.setAllocateLike(DataSet.create((IPDHost)this.getSystem(), (String)like));
            }
            this.setAllocationUnits((DSAQ.SpaceUnit)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACEU, this.getSystem()));
            this.setAllocationPrimary((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACEP, this.getSystem()));
            this.setAllocationSecondary((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.SPACES, this.getSystem()));
            this.setQSAMvolumeSerial((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.VOLUME, this.getSystem()));
            this.setQSAMdeviceType((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.UNIT, this.getSystem()));
            this.setDataClass((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DATACLAS, this.getSystem()));
            this.setStoreClass((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.STORCLAS, this.getSystem()));
            this.setManagementClass((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.MGMTCLAS, this.getSystem()));
            this.setQSAMdirectoryBlocks((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DIR, this.getSystem()));
            this.setQSAMrecordFormat((DSAQ.QsamRecordFormat)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.RECFMOUT, this.getSystem()));
            this.setQSAMrecordLength((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.RECSIZE, this.getSystem()));
            this.setQSAMblockSize((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.BLKSIZE, this.getSystem()));
            this.setQSAMdataSetType((DSAQ.QsamSpaceType)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNTYPE, this.getSystem()));
            this.setExpirationDate(AllocateDataSetModel.parseExpiryDate((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.EXPDT, this.getSystem())));
            if (this.getQSAMdataSetType() == DSAQ.QsamSpaceType.LIBRARY) {
                this.setDataSetVersion((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DSNV, this.getSystem()));
                if (Integer.parseInt(this.getDataSetVersion()) > 1) {
                    this.setMaxgens((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.NGEN, this.getSystem()));
                }
            }
            this.setKeyLabel((String)dsaq.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DSKEYLBL, this.getSystem()));
        } else if (function instanceof DSDV) {
            DSDV dsdv = (DSDV)function;
            this.setDataSetName((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.DSNOUT, this.getSystem()));
            String like = (String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.LIKE, this.getSystem());
            if (like.isEmpty()) {
                this.setAllocateLike(null);
            } else {
                this.setAllocateLike(DataSet.create((IPDHost)this.getSystem(), (String)like));
            }
            this.setAllocationUnits((DSAQ.SpaceUnit)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SPACEU, this.getSystem()));
            this.setAllocationPrimary((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SPACEP, this.getSystem()));
            this.setAllocationSecondary((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SPACES, this.getSystem()));
            this.setDataSetType((DataSetType)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.TYPE, this.getSystem()));
            this.setVSAMcatalog((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.CATALOG, this.getSystem()));
            this.setExpirationDate(AllocateDataSetModel.parseExpiryDate((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.TO, this.getSystem())));
            this.setVSAMdataComponent((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.DATA, this.getSystem()));
            this.setVSAMindexComponent((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.INDEX, this.getSystem()));
            this.setVSAMkeyLength((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.KEYLEN, this.getSystem()));
            this.setVSAMkeyOffset((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.KEYOFF, this.getSystem()));
            this.setVSAMciSize((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.CISIZE, this.getSystem()));
            this.setVSAMbufferSpace((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.BUFSP, this.getSystem()));
            String shrReg = (String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SHRREG, this.getSystem());
            if (ConversionUtil.isInt((String)shrReg) && ConversionUtil.toInt((String)shrReg) >= 1 && ConversionUtil.toInt((String)shrReg) <= 4) {
                this.setVSAMshareCrossRegion(ConversionUtil.toInt((String)shrReg));
            } else {
                this.setVSAMshareCrossRegion(1);
            }
            String shrSys = (String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SHRSYS, this.getSystem());
            if (ConversionUtil.isInt((String)shrSys) && ConversionUtil.toInt((String)shrSys) >= 3 && ConversionUtil.toInt((String)shrSys) <= 4) {
                this.setVSAMshareCrossSystem(ConversionUtil.toInt((String)shrSys));
            } else {
                this.setVSAMshareCrossSystem(3);
            }
            this.setVSAMowner((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.OWNER, this.getSystem()));
            this.setVSAMempty((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.EMPTY, this.getSystem()));
            if (this.fm_vrm >= 140113) {
                this.setVSAMempty((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.EXTENDED, this.getSystem()));
                this.setVSAMempty((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.FIFO, this.getSystem()));
                this.setVSAMempty((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.PURGE, this.getSystem()));
            }
            this.setVSAMlimit((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.LIMIT, this.getSystem()));
            this.setVSAMscratch((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SCRATCH, this.getSystem()));
            this.setVSAMreuse((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.REUSE, this.getSystem()));
            this.setVSAMrecovery((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.RECOVERY, this.getSystem()));
            this.setVSAMspanned((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SPANNED, this.getSystem()));
            this.setVSAMerase((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.ERASE, this.getSystem()));
            this.setVSAMwriteCheck((Boolean)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.WCHK, this.getSystem()));
            this.setVSAMrecsizeAverage((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.RECAVG, this.getSystem()));
            this.setVSAMrecsizeMaximum((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.RECMAX, this.getSystem()));
            this.setVSAMfreespaceCI((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.FREECI, this.getSystem()));
            this.setVSAMfreespaceCA((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.FREECA, this.getSystem()));
            this.setVSAMvolumeSerial((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.VOLUMES, this.getSystem()));
            this.setVSAMindexVolumeSerial((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.IVOLUMES, this.getSystem()));
            this.setVSAMindexCISize((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.ICISIZE, this.getSystem()));
            this.setVSAMindexAllocationUnit((DSAQ.SpaceUnit)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACEU, this.getSystem()));
            this.setVSAMindexSpacePrimary((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACEP, this.getSystem()));
            this.setVSAMindexSpaceSecondary((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.ISPACES, this.getSystem()));
            this.setDataClass((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.DCLASS, this.getSystem()));
            this.setStoreClass((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.SCLASS, this.getSystem()));
            this.setManagementClass((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSDV.MCLASS, this.getSystem()));
            this.setKeyLabel((String)dsdv.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DSAQ.DSKEYLBL, this.getSystem()));
        } else {
            logger.warn((Object)("Can't update allocate wizard model state from unrecognised utility function " + String.valueOf(function)));
        }
    }

    public static Calendar parseExpiryDate(String expiryDate) {
        if (expiryDate == null || expiryDate.isEmpty()) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy.D");
        try {
            Date date = format.parse(expiryDate);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Result<StringBuffer> allocateOnHost(IHowIsGoing monitor) throws InterruptedException {
        Result result;
        DataSet newDataSet = DataSet.create((IPDHost)this.getHost(), (String)this.getDataSetName());
        newDataSet.refreshSelf(monitor);
        if (newDataSet.getConfirmedExists()) {
            Result result2 = new Result((Object)new StringBuffer());
            result2.setRC(8);
            ((StringBuffer)result2.getOutput()).append(MessageFormat.format(Messages.CommDataSet_DATA_SET_X_ALREADY_EXISTS, newDataSet.getName()));
            return result2;
        }
        DataSet allocateLike = this.getAllocateLike();
        if (allocateLike != null) {
            allocateLike.refreshSelf(monitor);
            if (!allocateLike.getConfirmedExists()) {
                Result result3 = new Result(8);
                result3.setOutput((Object)new StringBuffer());
                ((StringBuffer)result3.getOutput()).append(MessageFormat.format(Messages.CommDataSet_ALLOCATE_LIKE_X_NOT_FOUND, allocateLike.getName()));
                return result3;
            }
        }
        NewUtilityFunction command = this.toUtilityFunction();
        try {
            result = UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)command, (IHowIsGoing)monitor);
        }
        catch (InterruptedException e) {
            result = new Result(4);
            result.add(Messages.CommDataSet_CANCELED_ALLOCATE_MAY_HAVE_COMPLETED);
        }
        String output = EncodingUtils.codepageConverter((String)((StringBuffer)result.getOutput()).toString(), (String)this.getSystem().getHostType().getCommunicationEncoding(), (String)this.getSystem().getCodePage());
        result.setOutput((Object)new StringBuffer(output));
        return result;
    }

    public DataSet getAllocateLike() {
        return this.allocateLike;
    }

    private void handleIndexAndDataAllocateLike() {
        List associatedDataSets;
        if (this.allocateLike == null) {
            return;
        }
        if ((this.allocateLike.getType() == DataSetType.DATA || this.allocateLike.getType() == DataSetType.INDEX) && (associatedDataSets = this.allocateLike.getAssociatedDataSets()) != null) {
            for (DataSet dataSet : associatedDataSets) {
                if (dataSet.getType() == DataSetType.DATA || dataSet.getType() == DataSetType.INDEX) continue;
                this.allocateLike = (DataSet)associatedDataSets.get(0);
            }
        }
    }

    public void setAllocateLike(DataSet allocateLike) {
        if (allocateLike != null && allocateLike.equals((Object)this.allocateLike)) {
            logger.trace((Object)("Identical allocate like not being set " + String.valueOf(allocateLike)));
            return;
        }
        this.allocateLike = allocateLike;
        this.handleIndexAndDataAllocateLike();
        if (allocateLike != null) {
            this.setDataSetType(allocateLike.getType());
        }
        this.updatedFromAllocateLike = false;
    }

    public void updateFromAllocateLikeProperties() {
        String expiryDate;
        List associatedDataSets;
        if (this.updatedFromAllocateLike) {
            logger.trace((Object)"Update from allocate like has already been done, ignoring");
            return;
        }
        if (this.allocateLike == null) {
            return;
        }
        DataSetProperties p = this.allocateLike.getProperties();
        if (p == null) {
            return;
        }
        this.setDataSetType(this.allocateLike.getType());
        DataSetProperties pVsamData = null;
        DataSetProperties pVsamIndex = null;
        if (this.allocateLike.getType().getAccessMethod() == DataSetType.AccessMethod.VSAM && (associatedDataSets = this.allocateLike.getAssociatedDataSets()) != null) {
            for (DataSet dataSet : associatedDataSets) {
                if (dataSet.getType() == DataSetType.DATA) {
                    pVsamData = dataSet.getProperties();
                    continue;
                }
                if (dataSet.getType() != DataSetType.INDEX) continue;
                pVsamIndex = dataSet.getProperties();
            }
        }
        if ((expiryDate = p.getPropertyValue("Expiration date")) == null || expiryDate.isEmpty() || "0000.000".equals(expiryDate)) {
            this.setExpirationDate(null);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.ddd");
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(sdf.parse(expiryDate));
                this.setExpirationDate(calendar);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.getSystem().equals(this.getAllocateLikeSystem())) {
            String dataCls = AllocateDataSetModel.emptyIfNull(p.getPropertyValue("SMS data class"));
            if (!"PRIMARY".equals(dataCls)) {
                this.setDataClass(dataCls);
            }
            this.setStoreClass(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("SMS storage class")));
            this.setManagementClass(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("SMS management class")));
        }
        this.setQSAMdataSetType(DSAQ.QsamSpaceType.fromDataSetType((DataSetType)this.allocateLike.getType()));
        this.setQSAMrecordLength(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Logical record length")));
        this.setQSAMblockSize(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Block length")));
        this.setQSAMrecordFormat(DSAQ.QsamRecordFormat.fromProperties((String)p.getPropertyValue("Record format")));
        this.setQSAMdirectoryBlocks(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Directory blocks")));
        this.setAllocationPrimary(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Primary space")));
        this.setAllocationSecondary(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Secondary space")));
        this.setAllocationUnits(DSAQ.SpaceUnit.fromProperties((String)p.getPropertyValue("Space type")));
        this.setDataSetVersion(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Data set type version")));
        this.setMaxgens(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Maximum member generations")));
        this.setKeyLabel(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Key Label")));
        this.setVSAMlimit(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("GDG limit")));
        this.setVSAMempty(AllocateDataSetModel.toBoolean(p.getPropertyValue("GDG delete after limit")));
        this.setVSAMscratch(AllocateDataSetModel.toBoolean(p.getPropertyValue("GDG scratch after limit")));
        if (pVsamData != null) {
            this.setVSAMkeyLength(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Key length")));
            this.setVSAMkeyOffset(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Relative key position")));
            this.setVSAMciSize(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("CI size")));
            this.setVSAMbufferSpace(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Buffer size")));
            this.setVSAMshareCrossRegion(AllocateDataSetModel.toInt(pVsamData.getPropertyValue("Shareoptions region"), 0));
            this.setVSAMshareCrossSystem(AllocateDataSetModel.toInt(pVsamData.getPropertyValue("Shareoptions system"), 0));
            this.setVSAMreuse(AllocateDataSetModel.toBoolean(pVsamData.getPropertyValue("Reuse")));
            this.setVSAMerase(AllocateDataSetModel.toBoolean(pVsamData.getPropertyValue("Erase")));
            this.setVSAMspanned(AllocateDataSetModel.toBoolean(pVsamData.getPropertyValue("Spanned")));
            this.setVSAMwriteCheck(AllocateDataSetModel.toBoolean(pVsamData.getPropertyValue("Write check")));
            this.setVSAMrecovery(AllocateDataSetModel.toBoolean(pVsamData.getPropertyValue("Recovery")));
            this.setVSAMrecsizeMaximum(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Maximum record size")));
            this.setVSAMvolumeSerial(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Volume sequence")));
            this.setVSAMcatalog(AllocateDataSetModel.emptyIfNull(p.getPropertyValue("Catalog name")));
            this.setVSAMrecsizeAverage(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Logical record length")));
            this.setVSAMfreespaceCI(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Percentage of bytes free in CI")));
            this.setVSAMfreespaceCA(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Percentage of free CIs in CA")));
            this.setAllocationPrimary(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Primary space")));
            this.setAllocationSecondary(AllocateDataSetModel.emptyIfNull(pVsamData.getPropertyValue("Secondary space")));
            this.setAllocationUnits(DSAQ.SpaceUnit.fromProperties((String)pVsamData.getPropertyValue("Space type")));
        }
        if (pVsamIndex != null) {
            this.setVSAMindexCISize(AllocateDataSetModel.emptyIfNull(pVsamIndex.getPropertyValue("CI size")));
            this.setVSAMindexVolumeSerial(AllocateDataSetModel.emptyIfNull(pVsamIndex.getPropertyValue("Volser")));
            this.setVSAMindexSpacePrimary(AllocateDataSetModel.emptyIfNull(pVsamIndex.getPropertyValue("Primary space")));
            this.setVSAMindexSpaceSecondary(AllocateDataSetModel.emptyIfNull(pVsamIndex.getPropertyValue("Secondary space")));
            this.setVSAMindexAllocationUnit(DSAQ.SpaceUnit.fromProperties((String)pVsamIndex.getPropertyValue("Space type")));
        }
        this.updatedFromAllocateLike = true;
    }

    private static boolean toBoolean(String string) {
        return string != null && (string.toUpperCase().equals("Y") || string.toUpperCase().equals("YES"));
    }

    private static int toInt(String string, int defaultValue) {
        if (string == null || string.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    public void setUpdatedFromAllocateLike(boolean updatedFromAllocateLike) {
        this.updatedFromAllocateLike = updatedFromAllocateLike;
    }

    public boolean isUpdatedFromAllocateLike() {
        return this.updatedFromAllocateLike;
    }

    public AllocateDataSetModel clone() {
        AllocateDataSetModel newParams = new AllocateDataSetModel();
        newParams.setHost(this.getHost());
        newParams.setDataSetName(this.getDataSetName());
        newParams.allocateLikeSystem = this.allocateLikeSystem;
        newParams.allocateLike = this.allocateLike;
        newParams.setDataSetType(this.getDataSetType());
        newParams.setExpirationDate(this.getCloneOf(this.getExpirationDate()));
        newParams.setAllocationPrimary(this.getAllocationPrimary());
        newParams.setAllocationSecondary(this.getAllocationSecondary());
        newParams.setAllocationUnits(this.getAllocationUnits());
        newParams.setDataClass(this.getDataClass());
        newParams.setStoreClass(this.getStoreClass());
        newParams.setManagementClass(this.getManagementClass());
        newParams.setDataSetVersion(this.dataSetVersion);
        newParams.setMaxgens(this.maxgens);
        newParams.setKeyLabel(this.keyLabel);
        newParams.setQSAMdataSetType(this.getQSAMdataSetType());
        newParams.setQSAMvolumeSerial(this.getQSAMvolumeSerial());
        newParams.setQSAMdeviceType(this.getQSAMdeviceType());
        newParams.setQSAMrecordLength(this.getQSAMrecordLength());
        newParams.setQSAMblockSize(this.getQSAMblockSize());
        newParams.setQSAMdirectoryBlocks(this.getQSAMdirectoryBlocks());
        newParams.setQSAMrecordFormat(this.getQSAMrecordFormat());
        newParams.setVSAMkeyLength(this.getVSAMkeyLength());
        newParams.setVSAMkeyOffset(this.getVSAMkeyOffset());
        newParams.setVSAMciSize(this.getVSAMciSize());
        newParams.setVSAMbufferSpace(this.getVSAMbufferSpace());
        newParams.setVSAMshareCrossRegion(this.getVSAMshareCrossRegion());
        newParams.setVSAMshareCrossSystem(this.getVSAMshareCrossSystem());
        newParams.setVSAMreuse(this.isVSAMreuse());
        newParams.setVSAMrecovery(this.isVSAMrecovery());
        newParams.setVSAMerase(this.isVSAMerase());
        newParams.setVSAMspanned(this.isVSAMspanned());
        newParams.setVSAMwriteCheck(this.isVSAMwriteCheck());
        newParams.setVSAMdataComponent(this.getVSAMdataComponent());
        newParams.setVSAMcatalog(this.getVSAMcatalog());
        newParams.setVSAMrecsizeAverage(this.getVSAMrecsizeAverage());
        newParams.setVSAMrecsizeMaximum(this.getVSAMrecsizeMaximum());
        newParams.setVSAMfreespaceCI(this.getVSAMfreespaceCI());
        newParams.setVSAMfreespaceCA(this.getVSAMfreespaceCA());
        newParams.setVSAMvolumeSerial(this.getVSAMvolumeSerial());
        newParams.setVSAMindexComponent(this.getVSAMindexComponent());
        newParams.setVSAMindexCISize(this.getVSAMindexCISize());
        newParams.setVSAMindexSpacePrimary(this.getVSAMindexSpacePrimary());
        newParams.setVSAMindexSpaceSecondary(this.getVSAMindexSpaceSecondary());
        newParams.setVSAMindexAllocationUnit(this.getVSAMindexAllocationUnit());
        newParams.setVSAMindexVolumeSerial(this.getVSAMindexVolumeSerial());
        newParams.setVSAMlimit(this.getVSAMlimit());
        newParams.setVSAMowner(this.getVSAMowner());
        newParams.setVSAMempty(this.isVSAMempty());
        newParams.setVSAMextended(this.isVSAMextended());
        newParams.setVSAMfifo(this.isVSAMfifo());
        newParams.setVSAMpurge(this.isVSAMpurge());
        newParams.setVSAMscratch(this.isVSAMscratch());
        return newParams;
    }

    protected <T> T getCloneOf(T o) {
        if (o == null) {
            return null;
        }
        try {
            Method method = o.getClass().getMethod("clone", new Class[0]);
            Object result = method.invoke(o, new Object[0]);
            return (T)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IPDHost getHost() {
        return this.getSystem();
    }

    public void setHost(IPDHost host) {
        this.host = host;
        if (this.allocateLikeSystem == null) {
            this.setAllocateLikeSystem(host);
        }
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public DataSetType getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(DataSetType dataSetType) {
        this.dataSetType = dataSetType;
    }

    public DataSetType[] getPossibleTypes() {
        return this.possibleTypes;
    }

    public void setPossibleTypes(DataSetType[] possibleTypes) {
        this.possibleTypes = possibleTypes;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getAllocationPrimary() {
        return this.allocationPrimary;
    }

    public void setAllocationPrimary(String allocationPrimary) {
        this.allocationPrimary = allocationPrimary;
    }

    public String getAllocationSecondary() {
        return this.allocationSecondary;
    }

    public void setAllocationSecondary(String allocationSecondary) {
        this.allocationSecondary = allocationSecondary;
    }

    public DSAQ.SpaceUnit getAllocationUnits() {
        return this.allocationUnits;
    }

    public void setAllocationUnits(DSAQ.SpaceUnit allocationUnits) {
        this.allocationUnits = allocationUnits;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(String dataClass) {
        this.dataClass = dataClass;
    }

    public String getStoreClass() {
        return this.storeClass;
    }

    public void setStoreClass(String storeClass) {
        this.storeClass = storeClass;
    }

    public String getManagementClass() {
        return this.managementClass;
    }

    public void setManagementClass(String managementClass) {
        this.managementClass = managementClass;
    }

    public DSAQ.QsamSpaceType getQSAMdataSetType() {
        return this.QSAMdataSetType;
    }

    public void setQSAMdataSetType(DSAQ.QsamSpaceType qSAMdataSetType) {
        this.QSAMdataSetType = qSAMdataSetType;
    }

    public String getQSAMvolumeSerial() {
        return this.QSAMvolumeSerial;
    }

    public void setQSAMvolumeSerial(String qSAMvolumeSerial) {
        this.QSAMvolumeSerial = qSAMvolumeSerial;
    }

    public String getQSAMdeviceType() {
        return this.QSAMdeviceType;
    }

    public void setQSAMdeviceType(String qSAMdeviceType) {
        this.QSAMdeviceType = qSAMdeviceType;
    }

    public String getQSAMrecordLength() {
        return this.QSAMrecordLength;
    }

    public void setQSAMrecordLength(String qSAMrecordLength) {
        this.QSAMrecordLength = qSAMrecordLength;
    }

    public String getQSAMblockSize() {
        return this.QSAMblockSize;
    }

    public void setQSAMblockSize(String qSAMblockSize) {
        this.QSAMblockSize = qSAMblockSize;
    }

    public String getQSAMdirectoryBlocks() {
        return this.QSAMdirectoryBlocks;
    }

    public void setQSAMdirectoryBlocks(String qSAMdirectoryBlocks) {
        this.QSAMdirectoryBlocks = qSAMdirectoryBlocks;
    }

    public DSAQ.QsamRecordFormat getQSAMrecordFormat() {
        return this.QSAMrecordFormat;
    }

    public void setQSAMrecordFormat(DSAQ.QsamRecordFormat qSAMrecordFormat) {
        this.QSAMrecordFormat = qSAMrecordFormat;
    }

    public String getVSAMkeyLength() {
        return this.VSAMkeyLength;
    }

    public void setVSAMkeyLength(String vSAMkeyLength) {
        this.VSAMkeyLength = vSAMkeyLength;
    }

    public String getVSAMkeyOffset() {
        return this.VSAMkeyOffset;
    }

    public void setVSAMkeyOffset(String vSAMkeyOffset) {
        this.VSAMkeyOffset = vSAMkeyOffset;
    }

    public String getVSAMciSize() {
        return this.VSAMciSize;
    }

    public void setVSAMciSize(String vSAMciSize) {
        this.VSAMciSize = vSAMciSize;
    }

    public String getVSAMbufferSpace() {
        return this.VSAMbufferSpace;
    }

    public void setVSAMbufferSpace(String vSAMbufferSpace) {
        this.VSAMbufferSpace = vSAMbufferSpace;
    }

    public int getVSAMshareCrossRegion() {
        return this.VSAMshareCrossRegion;
    }

    public void setVSAMshareCrossRegion(int vSAMshareCrossRegion) {
        this.VSAMshareCrossRegion = vSAMshareCrossRegion;
    }

    public int getVSAMshareCrossSystem() {
        return this.VSAMshareCrossSystem;
    }

    public void setVSAMshareCrossSystem(int vSAMshareCrossSystem) {
        this.VSAMshareCrossSystem = vSAMshareCrossSystem;
    }

    public boolean isVSAMreuse() {
        return this.VSAMreuse;
    }

    public void setVSAMreuse(boolean vSAMreuse) {
        this.VSAMreuse = vSAMreuse;
    }

    public boolean isVSAMrecovery() {
        return this.VSAMrecovery;
    }

    public void setVSAMrecovery(boolean vSAMrecovery) {
        this.VSAMrecovery = vSAMrecovery;
    }

    public boolean isVSAMerase() {
        return this.VSAMerase;
    }

    public void setVSAMerase(boolean vSAMerase) {
        this.VSAMerase = vSAMerase;
    }

    public boolean isVSAMspanned() {
        return this.VSAMspanned;
    }

    public void setVSAMspanned(boolean vSAMspanned) {
        this.VSAMspanned = vSAMspanned;
    }

    public boolean isVSAMwriteCheck() {
        return this.VSAMwriteCheck;
    }

    public void setVSAMwriteCheck(boolean vSAMwriteCheck) {
        this.VSAMwriteCheck = vSAMwriteCheck;
    }

    public String getVSAMdataComponent() {
        return this.VSAMdataComponent;
    }

    public void setVSAMdataComponent(String vSAMdataComponent) {
        this.VSAMdataComponent = vSAMdataComponent;
    }

    public String getVSAMcatalog() {
        return this.VSAMcatalog;
    }

    public void setVSAMcatalog(String vSAMcatalog) {
        this.VSAMcatalog = vSAMcatalog;
    }

    public String getVSAMowner() {
        return this.VSAMowner;
    }

    public void setVSAMowner(String vSAMowner) {
        this.VSAMowner = vSAMowner;
    }

    public String getVSAMrecsizeAverage() {
        return this.VSAMrecsizeAverage;
    }

    public void setVSAMrecsizeAverage(String vSAMrecsizeAverage) {
        this.VSAMrecsizeAverage = vSAMrecsizeAverage;
    }

    public String getVSAMrecsizeMaximum() {
        return this.VSAMrecsizeMaximum;
    }

    public void setVSAMrecsizeMaximum(String vSAMrecsizeMaximum) {
        this.VSAMrecsizeMaximum = vSAMrecsizeMaximum;
    }

    public String getVSAMfreespaceCI() {
        return this.VSAMfreespaceCI;
    }

    public void setVSAMfreespaceCI(String vSAMfreespaceCI) {
        this.VSAMfreespaceCI = vSAMfreespaceCI;
    }

    public String getVSAMfreespaceCA() {
        return this.VSAMfreespaceCA;
    }

    public void setVSAMfreespaceCA(String vSAMfreespaceCA) {
        this.VSAMfreespaceCA = vSAMfreespaceCA;
    }

    public String getVSAMvolumeSerial() {
        return this.VSAMvolumeSerial;
    }

    public void setVSAMvolumeSerial(String vSAMvolumeSerial) {
        this.VSAMvolumeSerial = vSAMvolumeSerial;
    }

    public String getVSAMindexComponent() {
        return this.VSAMindexComponent;
    }

    public void setVSAMindexComponent(String vSAMindexComponent) {
        this.VSAMindexComponent = vSAMindexComponent;
    }

    public String getVSAMindexCISize() {
        return this.VSAMindexCISize;
    }

    public void setVSAMindexCISize(String vSAMindexCISize) {
        this.VSAMindexCISize = vSAMindexCISize;
    }

    public String getVSAMindexSpacePrimary() {
        return this.VSAMindexSpacePrimary;
    }

    public void setVSAMindexSpacePrimary(String vSAMindexSpacePrimary) {
        this.VSAMindexSpacePrimary = vSAMindexSpacePrimary;
    }

    public String getVSAMindexSpaceSecondary() {
        return this.VSAMindexSpaceSecondary;
    }

    public void setVSAMindexSpaceSecondary(String vSAMindexSpaceSecondary) {
        this.VSAMindexSpaceSecondary = vSAMindexSpaceSecondary;
    }

    public DSAQ.SpaceUnit getVSAMindexAllocationUnit() {
        return this.VSAMindexAllocationUnit;
    }

    public void setVSAMindexAllocationUnit(DSAQ.SpaceUnit vSAMindexAllocationUnit) {
        this.VSAMindexAllocationUnit = vSAMindexAllocationUnit;
    }

    public String getVSAMindexVolumeSerial() {
        return this.VSAMindexVolumeSerial;
    }

    public void setVSAMindexVolumeSerial(String vSAMindexVolumeSerial) {
        this.VSAMindexVolumeSerial = vSAMindexVolumeSerial;
    }

    public boolean isVSAMscratch() {
        return this.VSAMscratch;
    }

    public void setVSAMscratch(boolean vSAMscratch) {
        this.VSAMscratch = vSAMscratch;
    }

    public boolean isVSAMempty() {
        return this.VSAMempty;
    }

    public void setVSAMempty(boolean vSAMempty) {
        this.VSAMempty = vSAMempty;
    }

    public boolean isVSAMextended() {
        return this.VSAMextended;
    }

    public void setVSAMextended(boolean vSAMextended) {
        this.VSAMextended = vSAMextended;
    }

    public boolean isVSAMfifo() {
        return this.VSAMfifo;
    }

    public void setVSAMfifo(boolean vSAMfifo) {
        this.VSAMfifo = vSAMfifo;
    }

    public boolean isVSAMpurge() {
        return this.VSAMpurge;
    }

    public void setVSAMpurge(boolean vSAMpurge) {
        this.VSAMpurge = vSAMpurge;
    }

    public String getVSAMlimit() {
        return this.VSAMlimit;
    }

    public void setVSAMlimit(String vSAMlimit) {
        this.VSAMlimit = vSAMlimit;
    }

    public int getFMVRM() {
        return this.fm_vrm;
    }

    public void setFMVRM(int vrm) {
        this.fm_vrm = vrm;
    }

    public int requestFMVRM() {
        int vrm = 0;
        try {
            String s;
            Matcher matcher;
            VER ver = new VER();
            IHowIsGoing monitor = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor());
            Result result = UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)ver, (IHowIsGoing)monitor);
            if (result == null || result.getOutput() == null) {
                result = UtilityFunctionRunner.execute((IPDHost)this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), (UtilityFunction)ver, (IHowIsGoing)monitor);
            }
            if (result != null && result.getOutput() != null && (matcher = this.vrmPattern.matcher(s = ((StringBuffer)result.getOutput()).toString())).find() && matcher.groupCount() > 2) {
                vrm = Integer.parseInt(matcher.group(1)) * 10000 + Integer.parseInt(matcher.group(2)) * 100 + Integer.parseInt(matcher.group(3));
            }
        }
        catch (IllegalArgumentException | InterruptedException e) {
            logger.trace((Object)("Attempt to determine FM version failed: " + e.getMessage()));
        }
        return vrm;
    }

    public String getDataSetVersion() {
        return this.dataSetVersion;
    }

    public void setDataSetVersion(String dataSetVersion) {
        this.dataSetVersion = dataSetVersion;
    }

    public String getMaxgens() {
        return this.maxgens;
    }

    public void setMaxgens(String maxgens) {
        this.maxgens = maxgens;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
    }
}

