/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.core.socket.func.DSDV;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetRunnable;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AllocateDataSetActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TYPE_DSAQ = "DSAQ";
    public static final String TYPE_DSDV = "DSDV";
    public static final String KEY_DATA_SET_TYPE = "datasetType";
    private static AddDataSetActionItemPropertySource propSource;
    private AllocateDataSetModel model = null;
    private IPDHost provider = null;

    public AllocateDataSetActionItem(AllocateDataSetModel model, IPDHost provider) {
        super(ActionType.ALLOCATE_DS, provider);
        this.model = Objects.requireNonNull(model);
        this.provider = Objects.requireNonNull(provider);
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.AddDataSetActionItem_LABEL, this.model.getDataSetName());
    }

    @Override
    public void saveTo(IMemento memento) {
        NewUtilityFunction cmd = this.model.toUtilityFunction();
        if (cmd instanceof DSAQ) {
            IMemento child = memento.createChild(TYPE_DSAQ);
            IActionItemSaver.saveParameterMapping(child, cmd.getParameterValues());
            child.putString(KEY_DATA_SET_TYPE, this.model.getDataSetType().name());
        } else if (cmd instanceof DSDV) {
            IMemento child = memento.createChild(TYPE_DSDV);
            IActionItemSaver.saveParameterMapping(child, cmd.getParameterValues());
        } else {
            logger.warn((Object)("Unable to save allocate function of " + String.valueOf(cmd)));
        }
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        IMemento dsaqMemento = memento.getChild(TYPE_DSAQ);
        if (dsaqMemento != null) {
            DSAQ function = new DSAQ();
            Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(dsaqMemento);
            function.setParameterValues(loadedParamValues);
            AllocateDataSetModel model = new AllocateDataSetModel();
            model.setHost(system);
            model.fromUtilityFunction((NewUtilityFunction)function);
            String dataSetType = dsaqMemento.getString(KEY_DATA_SET_TYPE);
            model.setDataSetType(DataSetType.valueOf((String)dataSetType));
            return new AllocateDataSetActionItem(model, system);
        }
        IMemento dsdvMemento = memento.getChild(TYPE_DSDV);
        if (dsdvMemento != null) {
            DSDV function = new DSDV();
            Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(dsdvMemento);
            function.setParameterValues(loadedParamValues);
            AllocateDataSetModel model = new AllocateDataSetModel();
            model.setHost(system);
            model.fromUtilityFunction((NewUtilityFunction)function);
            return new AllocateDataSetActionItem(model, system);
        }
        logger.trace((Object)"Aborting allocate load - no utility function info present");
        return null;
    }

    @Override
    public void execute() {
        this.beginExecution();
        this.model.setHost(this.provider);
        AllocateDataSetRunnable runnable = new AllocateDataSetRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void execute(List<SystemsTreeNode> draggedObjects) {
    }

    @Override
    public void modify() {
        this.beginExecution();
        this.model.setHost(this.provider);
        final AllocateDataSetModel clone = this.model.clone();
        clone.setUpdatedFromAllocateLike(true);
        AllocateDataSetWizard wizard = AllocateDataSetWizard.create(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                AllocateDataSetActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public boolean isValidInput(List<SystemsTreeNode> draggedObjects) {
        return false;
    }

    @Override
    public IPDHost getSystem() {
        return this.provider;
    }

    @Override
    public AllocateDataSetActionItem clone() {
        AllocateDataSetActionItem clone = new AllocateDataSetActionItem(this.model.clone(), this.provider);
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AllocateDataSetActionItem) {
            AllocateDataSetActionItem action = (AllocateDataSetActionItem)other;
            return this.getSystem().equals(action.getSystem()) && this.model.toUtilityFunction().equals((Object)action.model.toUtilityFunction());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 37;
        result = 37 * result + this.getSystem().hashCode();
        result = 37 * result + this.model.toUtilityFunction().hashCode();
        return result;
    }

    @Override
    public IPropertySource getPropertySource() {
        if (propSource == null) {
            propSource = new AddDataSetActionItemPropertySource(this.model);
        }
        propSource.setModel(this.model);
        return propSource;
    }

    private static class AddDataSetActionItemPropertySource
    implements IPropertySource {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final String SYSTEM = "system";
        private static final String ALLOCATE_LIKE_SYSTEM = "allocateLikeSystem";
        private AllocateDataSetModel model;
        private IPropertyDescriptor[] propertyDescriptors;
        private String dataSetName = "dataSetName";
        private String allocateLike = "allocateLike";
        private String dataSetType = "dataSetType";
        private String expirationDate = "expirationDate";
        private String allocationPrimary = "allocationPrimary";
        private String allocationSecondary = "allocationSecondary";
        private String allocationUnits = "allocationUnits";
        private String dataClass = "dataClass";
        private String storeClass = "storeClass";
        private String managementClass = "managementClass";
        private String QSAMdataSetType = "QSAMdataSetType";
        private String QSAMvolumeSerial = "QSAMvolumeSerial";
        private String QSAMdeviceType = "QSAMdeviceType";
        private String QSAMrecordLength = "QSAMrecordLength";
        private String QSAMblockSize = "QSAMblockSize";
        private String QSAMdirectoryBlocks = "QSAMdirectoryBlocks";
        private String QSAMrecordFormat = "QSAMrecordFormat";
        private String VSAMkeyLength = "VSAMkeyLength";
        private String VSAMkeyOffset = "VSAMkeyOffset";
        private String VSAMciSize = "VSAMciSize";
        private String VSAMbufferSpace = "VSAMbufferSpace";
        private String VSAMshareCrossRegion = "VSAMshareCrossRegion";
        private String VSAMshareCrossSystem = "VSAMshareCrossSystem";
        private String VSAMreuse = "VSAMreuse";
        private String VSAMrecovery = "VSAMrecovery";
        private String VSAMerase = "VSAMerase";
        private String VSAMspanned = "VSAMspanned";
        private String VSAMwriteCheck = "VSAMwriteCheck";
        private String VSAMdataComponent = "VSAMdataComponent";
        private String VSAMcatalog = "VSAMcatalog";
        private String VSAMrecsizeAverage = "VSAMrecsizeAverage";
        private String VSAMrecsizeMaximum = "VSAMrecsizeMaximum";
        private String VSAMfreespaceCI = "VSAMfreespaceCI";
        private String VSAMfreespaceCA = "VSAMfreespaceCA";
        private String VSAMvolumeSerial = "VSAMvolumeSerial";
        private String VSAMindexComponent = "VSAMindexComponent";
        private String VSAMindexCISize = "VSAMindexCISize";
        private String VSAMindexSpacePrimary = "VSAMindexSpacePrimary";
        private String VSAMindexSpaceSecondary = "VSAMindexSpaceSecondary";
        private String VSAMindexAllocationUnit = "VSAMindexAllocationUnit";
        private String VSAMindexVolumeSerial = "VSAMindexVolumeSerial";
        private String VSAMscratch = "VSAMscratch";
        private String VSAMempty = "VSAMempty";
        private String VSAMextended = "VSAMextended";
        private String VSAMfifo = "VSAMfifo";
        private String VSAMpurge = "VSAMpurge";
        private String VSAMlimit = "VSAMlimit";
        private String VSAMowner = "VSAMowner";

        public AddDataSetActionItemPropertySource(AllocateDataSetModel model) {
            this.model = model;
            this.init();
        }

        public void setModel(AllocateDataSetModel model) {
            this.model = model;
        }

        private void init() {
            ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
            temp.add(new PropertyDescriptor((Object)SYSTEM, Messages.AllocateDataSetActionItem_System));
            temp.add(new PropertyDescriptor((Object)ALLOCATE_LIKE_SYSTEM, Messages.AllocateDataSetActionItem_AllocateLikeSystem));
            temp.add(new PropertyDescriptor((Object)this.dataSetName, Messages.Label__DATA_SET));
            temp.add(new PropertyDescriptor((Object)this.allocateLike, Messages.Label__ALLOCATE_LIKE));
            temp.add(new PropertyDescriptor((Object)this.dataSetType, Messages.Label__DATA_SET_TYPE));
            temp.add(new PropertyDescriptor((Object)this.expirationDate, Messages.Label__EXPIRATION_DATE));
            temp.add(new PropertyDescriptor((Object)this.allocationPrimary, Messages.AddDataSetActionItem_SPACE_ALLOCATION_PRIMARY));
            temp.add(new PropertyDescriptor((Object)this.allocationSecondary, Messages.AddDataSetActionItem_SPACE_ALLOCATION_SECONDARY));
            temp.add(new PropertyDescriptor((Object)this.allocationUnits, Messages.AddDataSetActionItem_SPACE_ALLOCATION_UNITS));
            temp.add(new PropertyDescriptor((Object)this.dataClass, Messages.Label__DATA_CLASS));
            temp.add(new PropertyDescriptor((Object)this.storeClass, Messages.Label__STORE_CLASS));
            temp.add(new PropertyDescriptor((Object)this.managementClass, Messages.Label__MANAGEMENT_CLASS));
            temp.add(new PropertyDescriptor((Object)this.QSAMdataSetType, Messages.Label__SPACE_TYPE));
            temp.add(new PropertyDescriptor((Object)this.QSAMvolumeSerial, Messages.Label__VOLUME));
            temp.add(new PropertyDescriptor((Object)this.QSAMdeviceType, Messages.Label__DEVICE_TYPE));
            temp.add(new PropertyDescriptor((Object)this.QSAMrecordLength, Messages.Label__RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.QSAMblockSize, Messages.Label__BLOCK_SIZE));
            temp.add(new PropertyDescriptor((Object)this.QSAMdirectoryBlocks, Messages.Label__DIRECTORY_BLOCKS_LIBRARY_ONLY));
            temp.add(new PropertyDescriptor((Object)this.QSAMrecordFormat, Messages.AddDataSetActionItem_RECORD_FORMAT));
            temp.add(new PropertyDescriptor((Object)this.VSAMkeyLength, Messages.Label__KEY_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.VSAMkeyOffset, Messages.Label__KEY_OFFSET));
            temp.add(new PropertyDescriptor((Object)this.VSAMciSize, Messages.Label__CONTROL_INTERVAL_SIZE));
            temp.add(new PropertyDescriptor((Object)this.VSAMbufferSpace, Messages.Label__BUFFER_SPACE));
            temp.add(new PropertyDescriptor((Object)this.VSAMshareCrossRegion, Messages.Label__CROSS_REGION));
            temp.add(new PropertyDescriptor((Object)this.VSAMshareCrossSystem, Messages.Label__CROSS_SYSTEM));
            temp.add(new PropertyDescriptor((Object)this.VSAMreuse, Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_REUSE));
            temp.add(new PropertyDescriptor((Object)this.VSAMrecovery, Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_RECOVERY));
            temp.add(new PropertyDescriptor((Object)this.VSAMerase, Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_ERASE));
            temp.add(new PropertyDescriptor((Object)this.VSAMspanned, Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_SPANNED));
            temp.add(new PropertyDescriptor((Object)this.VSAMwriteCheck, Messages._ALLOCATE_WIZARD_ALLOCATE_VSAM_WRITE_CHECK));
            temp.add(new PropertyDescriptor((Object)this.VSAMdataComponent, Messages.Label__DATA_COMPONENT));
            temp.add(new PropertyDescriptor((Object)this.VSAMcatalog, Messages.Label__CATALOG));
            temp.add(new PropertyDescriptor((Object)this.VSAMrecsizeAverage, Messages.AddDataSetActionItem_AVERAGE_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.VSAMrecsizeMaximum, Messages.AddDataSetActionItem_MAXIMUM_RECORD_LENGTH));
            temp.add(new PropertyDescriptor((Object)this.VSAMfreespaceCI, Messages.Label__CONTROL_INTERVAL));
            temp.add(new PropertyDescriptor((Object)this.VSAMfreespaceCA, Messages.Label__CONTROL_AREA));
            temp.add(new PropertyDescriptor((Object)this.VSAMvolumeSerial, Messages.Title_ALLOCATE_WIZARD_VOLUMES));
            temp.add(new PropertyDescriptor((Object)this.VSAMindexComponent, Messages.Label__INDEX_COMPONENT));
            temp.add(new PropertyDescriptor((Object)this.VSAMindexSpacePrimary, Messages.AddDataSetActionItem_PRIMARY_SPACE_ALLOCATION));
            temp.add(new PropertyDescriptor((Object)this.VSAMindexSpaceSecondary, Messages.AddDataSetActionItem_SECONDARY_SPACE_ALLOCATION));
            temp.add(new PropertyDescriptor((Object)this.VSAMindexAllocationUnit, Messages.AddDataSetActionItem_UNIT_SPACE_ALLOCATION));
            temp.add(new PropertyDescriptor((Object)this.VSAMindexVolumeSerial, Messages.AddDataSetActionItem_VSAM_INDEX_VOLUME_SERIAL));
            temp.add(new PropertyDescriptor((Object)this.VSAMscratch, Messages.AddDataSetActionItem_VSAM_SCRATCH));
            temp.add(new PropertyDescriptor((Object)this.VSAMempty, Messages.AddDataSetActionItem_VSAM_EMPTY));
            temp.add(new PropertyDescriptor((Object)this.VSAMextended, Messages.AddDataSetActionItem_VSAM_EXTENDED));
            temp.add(new PropertyDescriptor((Object)this.VSAMfifo, Messages.AddDataSetActionItem_VSAM_FIFO));
            temp.add(new PropertyDescriptor((Object)this.VSAMpurge, Messages.AddDataSetActionItem_VSAM_PURGE));
            temp.add(new PropertyDescriptor((Object)this.VSAMlimit, Messages.AddDataSetActionItem_VSAM_LIMIT));
            temp.add(new PropertyDescriptor((Object)this.VSAMowner, Messages.AddDataSetActionItem_VSAM_OWNER));
            this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object arg) {
            if (arg instanceof String) {
                String id = (String)arg;
                if (id.equals(this.dataSetName)) {
                    return this.model.getDataSetName();
                }
                if (id.equals(this.allocateLike)) {
                    if (this.model.getAllocateLike() == null) {
                        return null;
                    }
                    return this.model.getAllocateLike().getFormattedName();
                }
                if (id.equals(this.dataSetType)) {
                    return this.model.getDataSetType();
                }
                if (id.equals(this.expirationDate)) {
                    if (this.model.getExpirationDate() == null) {
                        return "";
                    }
                    return this.model.getExpirationDate().toString();
                }
                if (id.equals(this.allocationPrimary)) {
                    return this.model.getAllocationPrimary();
                }
                if (id.equals(this.allocationSecondary)) {
                    return this.model.getAllocationSecondary();
                }
                if (id.equals(this.allocationUnits)) {
                    return this.model.getAllocationUnits();
                }
                if (id.equals(this.dataClass)) {
                    return this.model.getDataClass();
                }
                if (id.equals(this.storeClass)) {
                    return this.model.getStoreClass();
                }
                if (id.equals(this.managementClass)) {
                    return this.model.getManagementClass();
                }
                if (id.equals(this.QSAMdataSetType)) {
                    return this.model.getQSAMdataSetType();
                }
                if (id.equals(this.QSAMvolumeSerial)) {
                    return this.model.getQSAMvolumeSerial();
                }
                if (id.equals(this.QSAMdeviceType)) {
                    return this.model.getQSAMdeviceType();
                }
                if (id.equals(this.QSAMrecordLength)) {
                    return this.model.getQSAMrecordLength();
                }
                if (id.equals(this.QSAMblockSize)) {
                    return this.model.getQSAMblockSize();
                }
                if (id.equals(this.QSAMdirectoryBlocks)) {
                    return this.model.getQSAMdirectoryBlocks();
                }
                if (id.equals(this.QSAMrecordFormat)) {
                    return this.model.getQSAMrecordFormat();
                }
                if (id.equals(this.VSAMkeyLength)) {
                    return this.model.getVSAMkeyLength();
                }
                if (id.equals(this.VSAMkeyOffset)) {
                    return this.model.getVSAMkeyOffset();
                }
                if (id.equals(this.VSAMciSize)) {
                    return this.model.getVSAMciSize();
                }
                if (id.equals(this.VSAMbufferSpace)) {
                    return this.model.getVSAMbufferSpace();
                }
                if (id.equals(this.VSAMshareCrossRegion)) {
                    return this.model.getVSAMshareCrossRegion();
                }
                if (id.equals(this.VSAMshareCrossSystem)) {
                    return this.model.getVSAMshareCrossSystem();
                }
                if (id.equals(this.VSAMreuse)) {
                    return this.model.isVSAMreuse();
                }
                if (id.equals(this.VSAMrecovery)) {
                    return this.model.isVSAMrecovery();
                }
                if (id.equals(this.VSAMerase)) {
                    return this.model.isVSAMerase();
                }
                if (id.equals(this.VSAMspanned)) {
                    return this.model.isVSAMspanned();
                }
                if (id.equals(this.VSAMwriteCheck)) {
                    return this.model.isVSAMwriteCheck();
                }
                if (id.equals(this.VSAMdataComponent)) {
                    return this.model.getVSAMdataComponent();
                }
                if (id.equals(this.VSAMcatalog)) {
                    return this.model.getVSAMcatalog();
                }
                if (id.equals(this.VSAMrecsizeAverage)) {
                    return this.model.getVSAMrecsizeAverage();
                }
                if (id.equals(this.VSAMrecsizeMaximum)) {
                    return this.model.getVSAMrecsizeMaximum();
                }
                if (id.equals(this.VSAMfreespaceCI)) {
                    return this.model.getVSAMfreespaceCI();
                }
                if (id.equals(this.VSAMfreespaceCA)) {
                    return this.model.getVSAMfreespaceCA();
                }
                if (id.equals(this.VSAMvolumeSerial)) {
                    return this.model.getVSAMvolumeSerial();
                }
                if (id.equals(this.VSAMindexComponent)) {
                    return this.model.getVSAMindexComponent();
                }
                if (id.equals(this.VSAMindexCISize)) {
                    return this.model.getVSAMindexCISize();
                }
                if (id.equals(this.VSAMindexSpacePrimary)) {
                    return this.model.getVSAMindexSpacePrimary();
                }
                if (id.equals(this.VSAMindexSpaceSecondary)) {
                    return this.model.getVSAMindexSpaceSecondary();
                }
                if (id.equals(this.VSAMindexAllocationUnit)) {
                    return this.model.getVSAMindexAllocationUnit();
                }
                if (id.equals(this.VSAMindexVolumeSerial)) {
                    return this.model.getVSAMindexVolumeSerial();
                }
                if (id.equals(this.VSAMscratch)) {
                    return this.model.isVSAMscratch();
                }
                if (id.equals(this.VSAMempty)) {
                    return this.model.isVSAMempty();
                }
                if (id.equals(this.VSAMextended)) {
                    return this.model.isVSAMextended();
                }
                if (id.equals(this.VSAMfifo)) {
                    return this.model.isVSAMfifo();
                }
                if (id.equals(this.VSAMpurge)) {
                    return this.model.isVSAMpurge();
                }
                if (id.equals(this.VSAMlimit)) {
                    return this.model.getVSAMlimit();
                }
                if (id.equals(this.VSAMowner)) {
                    return this.model.getVSAMowner();
                }
                if (id.equals(SYSTEM)) {
                    return this.model.getSystem();
                }
                if (id.equals(ALLOCATE_LIKE_SYSTEM)) {
                    return this.model.getAllocateLikeSystem();
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object arg0) {
            return false;
        }

        public void resetPropertyValue(Object arg0) {
        }

        public void setPropertyValue(Object arg0, Object arg1) {
        }
    }
}

