/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.widget.TriStateButtonWrapper;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class TypeComposite<E>
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(TypeComposite.class);
    private Button[] wTypes;
    private Button wSelectAll;
    private TriStateButtonWrapper wSelectAllWrapper;
    private List<E> types;

    public TypeComposite(Composite parent, int columns, Object layoutData, List<E> items) {
        super(parent, 0);
        this.types = new ArrayList<E>(items);
        this.setLayout((Layout)GUI.grid.l.noMargins((int)columns, (boolean)true));
        Composite selectAllComp = GUI.composite((Composite)this, (Layout)GUI.grid.l.noMargins((int)columns, (boolean)false), (Object)GUI.grid.d.fillH((int)columns));
        this.wSelectAll = GUI.button.checkbox((Composite)selectAllComp, (String)Messages.All, (Object)GUI.grid.d.left1());
        this.wSelectAllWrapper = new TriStateButtonWrapper(this.wSelectAll, false);
        this.wSelectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!TypeComposite.this.wSelectAll.getGrayed()) {
                    if (TypeComposite.this.wSelectAll.getSelection()) {
                        Button[] buttonArray = TypeComposite.this.wTypes;
                        int n = TypeComposite.this.wTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Button typeCheckbox = buttonArray[n2];
                            if (!typeCheckbox.isDisposed() && !typeCheckbox.getSelection() && typeCheckbox.isEnabled()) {
                                typeCheckbox.setSelection(true);
                            }
                            ++n2;
                        }
                    } else {
                        Button[] buttonArray = TypeComposite.this.wTypes;
                        int n = TypeComposite.this.wTypes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Button typeCheckbox = buttonArray[n3];
                            if (!typeCheckbox.isDisposed() && typeCheckbox.getSelection() && typeCheckbox.isEnabled()) {
                                typeCheckbox.setSelection(false);
                            }
                            ++n3;
                        }
                    }
                    TypeComposite.this.fireSelectionEvent(null);
                }
            }
        });
        Collections.sort(this.types, this.getComparator());
        this.wTypes = new Button[this.types.size()];
        Listener typeSelectionListener = new Listener(){

            public void handleEvent(Event event) {
                TypeComposite.this.fireSelectionEvent(event.widget);
                TypeComposite.this.updateSelectAllButton();
            }
        };
        int i = 0;
        while (i < this.types.size()) {
            this.wTypes[i] = GUI.button.checkbox((Composite)this, (String)this.getLabelFor(this.types.get(i)), (Object)GUI.grid.d.fillH((int)1));
            this.wTypes[i].addListener(13, typeSelectionListener);
            ++i;
        }
        this.setLayoutData(layoutData);
    }

    public void addSelectionListener(Listener e) {
        this.addListener(13, e);
    }

    public List<E> getSelected() {
        ArrayList<E> selectedTypes = new ArrayList<E>();
        int i = 0;
        while (i < this.wTypes.length) {
            if (this.wTypes[i].getSelection() && this.wTypes[i].getEnabled()) {
                selectedTypes.add(this.types.get(i));
            }
            ++i;
        }
        return selectedTypes;
    }

    public void setSelectedTypes(List<E> selectedTypes) {
        int i = 0;
        while (i < this.types.size()) {
            boolean isSelected = false;
            for (E selectedType : selectedTypes) {
                if (!selectedType.equals(this.types.get(i))) continue;
                isSelected = true;
            }
            if (this.wTypes[i].getSelection() != isSelected) {
                this.wTypes[i].setSelection(isSelected);
            }
            ++i;
        }
        this.updateSelectAllButton();
        this.fireSelectionEvent(null);
    }

    public void setAllCheckboxLabel(String label2) {
        this.wSelectAll.setText(label2);
    }

    public void setEnabledTypes(List<E> enabledTypes) {
        this.wSelectAll.setEnabled(false);
        int i = 0;
        while (i < this.types.size()) {
            boolean isEnabled = false;
            for (E enabledType : enabledTypes) {
                if (enabledType != this.types.get(i)) continue;
                isEnabled = true;
                if (this.wSelectAll.isEnabled()) continue;
                this.wSelectAll.setEnabled(true);
            }
            this.wTypes[i].setEnabled(isEnabled);
            if (!isEnabled) {
                this.wTypes[i].setSelection(false);
            }
            ++i;
        }
        if (this.wSelectAll.isEnabled()) {
            this.updateSelectAllButton();
        } else {
            this.wSelectAll.setGrayed(false);
            this.wSelectAll.setSelection(false);
        }
    }

    protected Comparator<E> getComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return TypeComposite.this.getLabelFor(o1).compareTo(TypeComposite.this.getLabelFor(o2));
            }
        };
    }

    protected String getLabelFor(E item) {
        return item.toString();
    }

    private void updateSelectAllButton() {
        Boolean allSelected = true;
        Boolean noneSelected = true;
        Button[] buttonArray = this.wTypes;
        int n = this.wTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Button wType = buttonArray[n2];
            if (wType.isEnabled()) {
                allSelected = allSelected != false && wType.getSelection();
                noneSelected = noneSelected != false && !wType.getSelection();
            }
            ++n2;
        }
        if (allSelected.booleanValue()) {
            this.wSelectAllWrapper.setSelection(true);
        } else if (noneSelected.booleanValue()) {
            this.wSelectAllWrapper.setSelection(false);
        } else {
            this.wSelectAllWrapper.setSelection(null);
        }
    }

    private void fireSelectionEvent(Widget source) {
        Listener[] listeners;
        Event event = new Event();
        event.item = this;
        event.widget = source;
        Listener[] listenerArray = listeners = this.getListeners(13);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }
}

