/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.Objects;

public class TemplateWithOffsetModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String OFFSET_SEPARATOR = ",";
    private String template = "";
    private String offset = "";

    public TemplateWithOffsetModel(IPDHost host) {
        super(host);
    }

    public TemplateWithOffsetModel clone() {
        TemplateWithOffsetModel copy = new TemplateWithOffsetModel(this.getHostProvider());
        copy.template = this.template;
        copy.offset = this.offset;
        return copy;
    }

    public String getTemplateSet() {
        return this.template;
    }

    public Member getTemplate() {
        if (this.getSystem() != null && Member.isParseable((String)this.template, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.template).asMember();
        }
        return null;
    }

    public void setTemplate(String template) {
        this.template = Objects.requireNonNull(template, "Must provide a non-null template");
    }

    public void addOffset(String value, String field) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!this.offset.isEmpty()) {
            this.offset = String.valueOf(this.offset) + OFFSET_SEPARATOR;
        }
        this.offset = String.valueOf(this.offset) + value;
        if (field != null && field.length() > 0) {
            this.offset = String.valueOf(this.offset) + OFFSET_SEPARATOR + field;
        }
    }

    public void setOffset(String offset) {
        this.offset = Objects.requireNonNull(offset, "Must provide a non-null offset");
    }

    public String getOffsets() {
        if (this.getTemplate() == null) {
            return "";
        }
        return this.offset;
    }

    public String getOffsetsForHost() {
        if (this.getTemplate() == null || this.offset == null || this.offset.isEmpty()) {
            return "";
        }
        return this.offset;
    }
}

