/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.etools.fm.ui.widget.TemplateWithOffsetModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TemplateWithOffsetComposite
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(TemplateWithOffsetComposite.class);
    private final TemplateWithOffsetModel model;
    private final TemplateWithOffsetCompositeConnector connector = new TemplateWithOffsetCompositeConnector();
    private ComboViewer wSystemViewer;
    private Combo wTemplate;
    private Button wTemplateEdit;
    private Combo wOffsets;
    private Button wOffsetsAdd;

    public static boolean isOffsetValid(String offset) {
        Objects.requireNonNull(offset, "Must specify a non-null offset.");
        if (offset.isEmpty()) {
            return true;
        }
        if (offset.indexOf("(") != -1 || offset.indexOf(")") != -1) {
            return false;
        }
        String[] items = offset.split(",");
        if (offset.charAt(offset.length() - 1) == ",".charAt(0)) {
            return false;
        }
        if (items.length != 1 && items.length % 2 == 1) {
            return false;
        }
        int i = 0;
        while (i < items.length) {
            if (i % 2 == 0 ? !ConversionUtil.isInt((String)items[i]) : items[i].equals("ALL") && i != 1) {
                return false;
            }
            if (items[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TemplateWithOffsetComposite(Composite parent, int style, final TemplateWithOffsetModel model, String valueSaverPrefix, final boolean remoteSystemEnabled) {
        super(parent, style);
        Objects.requireNonNull(valueSaverPrefix);
        this.model = Objects.requireNonNull(model);
        this.setLayout((Layout)GUI.grid.l.noMargins((int)4, (boolean)false));
        if (remoteSystemEnabled) {
            this.wSystemViewer = SystemSelectionCombo.createSystemLabelAndComboViewer(this, new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all()), model.getHostProvider());
            GUI.label.left((Composite)this, (String)"", (Object)GUI.grid.d.left1());
            GUI.label.left((Composite)this, (String)"", (Object)GUI.grid.d.left1());
        }
        GUI.label.left((Composite)this, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplate = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateEdit = GUI.button.push((Composite)this, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities.openTemplateEditSession((IZRL)model.getTemplate());
            }
        });
        LookupDialogFactory l2 = LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1(this), this.wTemplate, (IHostProvider)model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (remoteSystemEnabled) {
                    model.setHostProvider(selectedHost);
                }
                model.fireModelChangeEvent();
            }
        }).addResourceContentProposals(valueSaverPrefix + "Template");
        if (remoteSystemEnabled) {
            l2.allowMultiple();
        }
        l2.create();
        GUI.label.left((Composite)this, (String)Messages.Label__FIELD_OFFSETS, (Object)GUI.grid.d.left1());
        this.wOffsets = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wOffsets, valueSaverPrefix + "TemplateOffsets"){

            protected boolean shouldSave(String value) {
                return TemplateWithOffsetComposite.isOffsetValid(TemplateWithOffsetComposite.this.wOffsets.getText()) && super.shouldSave(value);
            }
        };
        this.wOffsetsAdd = GUI.button.push((Composite)this, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.__ADD, (Object)GUI.grid.d.left1());
        this.wOffsetsAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FieldOffsetDialog dialog = new FieldOffsetDialog(TemplateWithOffsetComposite.this.wOffsets.getText().isEmpty());
                if (dialog.open() == 0) {
                    model.addOffset(dialog.getValue(), dialog.getField());
                    model.fireModelChangeEvent();
                    TemplateWithOffsetComposite.this.wOffsets.setFocus();
                }
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TemplateWithOffsetComposite.this.dispose();
            }
        });
        this.connector.listenTo(model);
        if (remoteSystemEnabled) {
            this.connector.listenTo((Control)this.wSystemViewer.getCombo());
        }
        this.connector.listenTo((Control)this.wTemplate);
        this.connector.listenTo((Control)this.wOffsets);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSystem() == null) {
            return Messages.TemplateWithOffsetComposite_SPECIFY_VALID_SYSTEM;
        }
        if (!"".equals(this.model.getTemplateSet()) && this.model.getTemplate() == null) {
            return Messages.TemplateWithOffsetComposite_TEMPLATE_INVALID;
        }
        if (!TemplateWithOffsetComposite.isOffsetValid(this.model.getOffsets())) {
            return Messages.TemplateWithOffsetComposite_OFFSET_INVALID;
        }
        return null;
    }

    public ModelViewConnector getConnector() {
        return this.connector;
    }

    protected void onViewUpdated() {
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    public Combo getTemplateCombo() {
        return this.wTemplate;
    }

    private static class FieldOffsetDialog
    extends BaseTitleAreaDialog {
        private final boolean isFirstOffset;
        private String value = "";
        private String field = "";
        private Combo wValue;
        private Text wField;

        public FieldOffsetDialog(boolean isFirstOffset) {
            this.isFirstOffset = isFirstOffset;
            this.setComplete(false);
        }

        protected void setComplete(boolean complete) {
            if (complete) {
                this.setErrorMessage(null);
                if (this.wValue != null) {
                    this.value = this.wValue.getText();
                }
                if (this.wField != null) {
                    this.field = this.wField.getText();
                }
            }
            super.setComplete(complete);
        }

        private void checkValid() {
            boolean valid = true;
            if (!this.isFirstOffset && this.wField.getText().equals("ALL")) {
                valid = false;
                this.setErrorMessage(Messages.TemplateWithOffsetComposite_ALL_ONLY_VALID_FIRST_TIME);
            }
            if (!this.isFirstOffset && this.wField != null && this.wField.getText().isEmpty()) {
                valid = false;
                this.setErrorMessage(Messages.Msg_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET_FIELD);
            }
            if (this.wField.getText().indexOf("(") != -1 || this.wField.getText().indexOf(")") != -1) {
                valid = false;
                this.setErrorMessage(Messages.TemplateWithOffsetComposite_NO_BRACKETS_ALLOWED);
            }
            if (this.wValue != null && this.wValue.getText().isEmpty()) {
                valid = false;
                this.setErrorMessage(Messages.Msg_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET_VALUE);
            }
            this.setComplete(valid);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.Title_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET);
            this.setTitle(Messages.Title_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET);
            Object msg = Messages.Msg_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET_ENTER_VALUES;
            if (this.isFirstOffset) {
                msg = (String)msg + "\n" + Messages.Msg_COPY_WIZARD_PAGE_TEMPLATE_FIELD_OFFSET_CAN_LEAVE_BLANK;
            }
            this.setMessage((String)msg);
            Composite comp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
            GUI.label.left((Composite)comp, (String)Messages.Label__VALUE, (Object)GUI.grid.d.left1());
            this.wValue = GUI.combo.editable((Composite)comp, (Object)GUI.grid.d.fillH((int)1));
            NumberForcer fV = NumberForcer.addTo(this.wValue, ((Object)((Object)this)).getClass().getCanonicalName() + "Value");
            fV.setLowerBound(-32760, true);
            fV.setUpperBound(32760, true);
            this.wValue.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    this.checkValid();
                }
            });
            GUI.label.left((Composite)comp, (String)Messages.Label__FIELD, (Object)GUI.grid.d.left1());
            this.wField = GUI.text.field((Composite)comp, (Object)GUI.grid.d.fillH((int)1));
            this.wField.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    this.checkValid();
                }
            });
            return comp;
        }

        public String getValue() {
            return this.value;
        }

        public String getField() {
            return this.field;
        }
    }

    private class TemplateWithOffsetCompositeConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private TemplateWithOffsetCompositeConnector() {
        }

        protected void updateModelFromViewImpl() {
            IStructuredSelection selectedSourceSystem;
            if (TemplateWithOffsetComposite.this.wSystemViewer != null && (selectedSourceSystem = (IStructuredSelection)TemplateWithOffsetComposite.this.wSystemViewer.getSelection()).getFirstElement() != null) {
                logger.trace((Object)("Changing the selected system to " + String.valueOf(selectedSourceSystem.getFirstElement())));
                TemplateWithOffsetComposite.this.model.setHostProvider((IPDHost)selectedSourceSystem.getFirstElement());
            }
            if (TemplateWithOffsetComposite.this.wTemplate != null) {
                TemplateWithOffsetComposite.this.model.setTemplate(TemplateWithOffsetComposite.this.wTemplate.getText());
            }
            if (TemplateWithOffsetComposite.this.wOffsets != null && TemplateWithOffsetComposite.this.model.getTemplate() != null) {
                TemplateWithOffsetComposite.this.model.setOffset(TemplateWithOffsetComposite.this.wOffsets.getText());
            }
            TemplateWithOffsetComposite.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            if (TemplateWithOffsetComposite.this.model.getHostProvider() != null && TemplateWithOffsetComposite.this.wSystemViewer != null) {
                TemplateWithOffsetComposite.this.wSystemViewer.setSelection((ISelection)new StructuredSelection((Object)TemplateWithOffsetComposite.this.model.getSystem()));
            }
            if (TemplateWithOffsetComposite.this.model.getTemplate() != null) {
                this.updateComboFromModelIfNeeded(TemplateWithOffsetComposite.this.wTemplate, TemplateWithOffsetComposite.this.model.getTemplate().getFormattedName());
            }
            this.updateComboFromModelIfNeeded(TemplateWithOffsetComposite.this.wOffsets, TemplateWithOffsetComposite.this.model.getOffsets());
            if (TemplateWithOffsetCompositeConnector.unfocussed((Control)TemplateWithOffsetComposite.this.wOffsets)) {
                TemplateWithOffsetCompositeConnector.setEnabledIf((Control)TemplateWithOffsetComposite.this.wOffsets, (TemplateWithOffsetComposite.this.model.getTemplate() != null ? 1 : 0) != 0);
            }
            TemplateWithOffsetComposite.this.onViewUpdated();
            TemplateWithOffsetCompositeConnector.setEnabledIf((Control)TemplateWithOffsetComposite.this.wTemplateEdit, (TemplateWithOffsetComposite.this.model.getTemplate() != null ? 1 : 0) != 0);
            TemplateWithOffsetCompositeConnector.setEnabledIf((Control)TemplateWithOffsetComposite.this.wOffsets, (TemplateWithOffsetComposite.this.model.getTemplate() != null ? 1 : 0) != 0);
            int numOffsets = StringUtils.count((String)TemplateWithOffsetComposite.this.wOffsets.getText(), (String)",");
            TemplateWithOffsetCompositeConnector.setEnabledIf((Control)TemplateWithOffsetComposite.this.wOffsetsAdd, (TemplateWithOffsetComposite.this.model.getTemplate() != null && (TemplateWithOffsetCompositeConnector.isEmpty((Combo)TemplateWithOffsetComposite.this.wOffsets) || numOffsets % 2 >= 1) ? 1 : 0) != 0);
        }
    }
}

