/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueManagerQuery;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsApplIDQuery;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.core.util.FMAssert;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.etools.fm.ui.widget.LazyContentProposalAdapter;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ResourceContentProposals
implements IContentProposalProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Class<?>[] DEFAULT_TYPES = new Class[0];
    private static final Class<?>[] VALID_TYPES = new Class[]{DataSet.class, Member.class, MessageQueue.class, MessageQueueManager.class, UssFile.class, CicsAppl.class, CicsFile.class, CicsTransientData.class, CicsTemporaryStorage.class};
    protected static final PDLogger logger = PDLogger.get(ResourceContentProposals.class);
    protected static final long WAIT_BEFORE_LOADING = 1000L;
    protected static final String RCP_ID = ResourceContentProposals.class.getCanonicalName();
    private IHostProvider hostProvider;
    private Class<?>[] allowedTypes = DEFAULT_TYPES;
    private ControlDecoration hint;
    private ResourceContentProposalAdapter adapter;
    private Control control;
    private IControlContentAdapter contentAdapter;
    private boolean forcedLoad = false;
    private String loadProposalsFor = null;
    private IContentProposal[] proposals = new IContentProposal[0];
    private AssistType lastLoaded = null;
    private static final int cicsSepPosInPrefix = 2;
    private Job proposalLoader = new Job(Messages.ResourceContentProposals_LOADING_PROPOSALS){

        protected IStatus run(IProgressMonitor monitor) {
            ResourceContentProposals.this.lastLoaded = null;
            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
            try {
                if (AssistType.CICSAPPID.appliesTo(ResourceContentProposals.this.loadProposalsFor) && (ResourceContentProposals.this.isAllowedResourceType(CicsAppl.class) || ResourceContentProposals.this.isAllowedResourceType(CicsFile.class) || ResourceContentProposals.this.isAllowedResourceType(CicsTransientData.class) || ResourceContentProposals.this.isAllowedResourceType(CicsTemporaryStorage.class))) {
                    CicsApplIDQuery query = CicsApplIDQuery.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)"*");
                    Result result = query.loadCICSApps(howIsGoing);
                    List applIds = (List)result.getOutput();
                    if (applIds != null) {
                        String namePrefix = "FI:";
                        if (ResourceContentProposals.this.loadProposalsFor.toUpperCase().startsWith("TS:")) {
                            namePrefix = "TS:";
                        } else if (ResourceContentProposals.this.loadProposalsFor.toUpperCase().startsWith("TD:")) {
                            namePrefix = "TD:";
                        }
                        int i = 0;
                        ResourceContentProposals.this.proposals = new IContentProposal[applIds.size()];
                        for (CicsAppl applId : applIds) {
                            String content;
                            String label2 = content = namePrefix + applId.getName();
                            if (applId.getDescription() != null) {
                                label2 = label2 + " - " + applId.getDescription();
                            }
                            if (!applId.canConnect()) {
                                label2 = label2 + " " + Messages.ResourceContentProposals_CANT_CONNECT;
                            }
                            String description = MessageFormat.format(Messages.ResourceContentProposals_CICS_APPLID_PROPERTIES, applId.getSystem(), applId.getName(), applId.canConnect() ? Messages.ResourceContentProposals_YES : Messages.ResourceContentProposals_NO, applId.getDescription());
                            ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label2, description);
                        }
                        ResourceContentProposals.this.lastLoaded = AssistType.CICSAPPID;
                    }
                } else if (AssistType.CICSFILE.appliesTo(ResourceContentProposals.this.loadProposalsFor) && ResourceContentProposals.this.isAllowedResourceType(CicsFile.class)) {
                    int fileSepPos = ResourceContentProposals.this.loadProposalsFor.lastIndexOf(":");
                    String applIdStr = ResourceContentProposals.this.loadProposalsFor.substring(3, fileSepPos).toUpperCase();
                    if (!CicsAppl.isValidName((String)applIdStr, (String)ResourceContentProposals.this.hostProvider.getSystem().getCodePage())) {
                        throw new InterruptedException();
                    }
                    CicsAppl appl = CicsAppl.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)applIdStr);
                    CicsFileQuery query = CicsFileQuery.create((CicsAppl)appl, (String)"*");
                    Result result = query.loadCICSResources(howIsGoing);
                    List cicsFiles = (List)result.getOutput();
                    if (cicsFiles != null) {
                        int i = 0;
                        ResourceContentProposals.this.proposals = new IContentProposal[cicsFiles.size()];
                        for (CicsFile cicsFile : cicsFiles) {
                            String content;
                            String label3 = content = cicsFile.getFormattedName();
                            String description = MessageFormat.format(Messages.ResourceContentProposals_CICS_FILE_PROPERTIES, cicsFile.getSystem(), cicsFile.getCICSAppl().getName(), cicsFile.getName());
                            ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label3, description);
                        }
                        ResourceContentProposals.this.lastLoaded = AssistType.CICSFILE;
                    }
                } else if (AssistType.CICSTD.appliesTo(ResourceContentProposals.this.loadProposalsFor) && ResourceContentProposals.this.isAllowedResourceType(CicsTransientData.class)) {
                    int tdSepPos = ResourceContentProposals.this.loadProposalsFor.lastIndexOf(":");
                    String applIdStr = ResourceContentProposals.this.loadProposalsFor.substring(3, tdSepPos).toUpperCase();
                    if (!CicsAppl.isValidName((String)applIdStr, (String)ResourceContentProposals.this.hostProvider.getSystem().getCodePage())) {
                        throw new InterruptedException();
                    }
                    CicsAppl appl = CicsAppl.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)applIdStr);
                    CicsTransientDataQuery query = CicsTransientDataQuery.create((CicsAppl)appl, (String)"*");
                    Result result = query.loadCICSResources(howIsGoing);
                    List cicsTDs = (List)result.getOutput();
                    if (cicsTDs != null) {
                        int i = 0;
                        ResourceContentProposals.this.proposals = new IContentProposal[cicsTDs.size()];
                        for (CicsTransientData cicsTD : cicsTDs) {
                            String content;
                            String label4 = content = cicsTD.getFormattedName();
                            String description = MessageFormat.format(Messages.ResourceContentProposals_CICS_TD_PROPERTIES, cicsTD.getSystem(), cicsTD.getCICSAppl().getName(), cicsTD.getName());
                            ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label4, description);
                        }
                        ResourceContentProposals.this.lastLoaded = AssistType.CICSTD;
                    }
                } else if (AssistType.CICSTS.appliesTo(ResourceContentProposals.this.loadProposalsFor) && ResourceContentProposals.this.isAllowedResourceType(CicsTemporaryStorage.class)) {
                    int fileSepPos = ResourceContentProposals.this.loadProposalsFor.lastIndexOf(":");
                    String applIdStr = ResourceContentProposals.this.loadProposalsFor.substring(3, fileSepPos).toUpperCase();
                    if (!CicsAppl.isValidName((String)applIdStr, (String)ResourceContentProposals.this.hostProvider.getSystem().getCodePage())) {
                        throw new InterruptedException();
                    }
                    CicsAppl appl = CicsAppl.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)applIdStr);
                    CicsTemporaryStorageQuery query = CicsTemporaryStorageQuery.create((CicsAppl)appl, (String)"*");
                    Result result = query.loadCICSResources(howIsGoing);
                    List cicsTSs = (List)result.getOutput();
                    if (cicsTSs != null) {
                        int i = 0;
                        ResourceContentProposals.this.proposals = new IContentProposal[cicsTSs.size()];
                        for (CicsTemporaryStorage cicsTS : cicsTSs) {
                            String content;
                            String label5 = content = cicsTS.getFormattedName();
                            String description = MessageFormat.format(Messages.ResourceContentProposals_CICS_TS_PROPERTIES, cicsTS.getSystem(), cicsTS.getCICSAppl().getName(), cicsTS.getName());
                            ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label5, description);
                        }
                        ResourceContentProposals.this.lastLoaded = AssistType.CICSTS;
                    }
                } else if (ResourceContentProposals.this.loadProposalsFor.toLowerCase().startsWith("MQ:".toLowerCase())) {
                    int sepPosInPrefix = "MQ:".indexOf(":");
                    int sep = ResourceContentProposals.this.loadProposalsFor.indexOf(":", sepPosInPrefix + 1);
                    if (AssistType.MQM.appliesTo(ResourceContentProposals.this.loadProposalsFor) && (ResourceContentProposals.this.isAllowedResourceType(MessageQueueManager.class) || ResourceContentProposals.this.isAllowedResourceType(MessageQueue.class))) {
                        MessageQueueManagerQuery mqmQuery = new MessageQueueManagerQuery(ResourceContentProposals.this.hostProvider.getSystem());
                        Result result = mqmQuery.loadMessageQueueManagers(howIsGoing, false);
                        List mqms = (List)result.getOutput();
                        if (mqms != null) {
                            int i = 0;
                            ResourceContentProposals.this.proposals = new IContentProposal[mqms.size()];
                            for (MessageQueueManager mqm : mqms) {
                                String content;
                                String label6 = content = "MQ:" + mqm.getName();
                                if (mqm.getConnectionCode() != 0) {
                                    label6 = label6 + " " + Messages.ResourceContentProposals_CANT_CONNECT;
                                }
                                String description = MessageFormat.format(Messages.ResourceContentProposals_MQM_PROPERTIES, mqm.getSystem(), mqm.getName(), mqm.getConnectionCode(), mqm.getConnectionReason());
                                ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label6, description);
                            }
                            ResourceContentProposals.this.lastLoaded = AssistType.MQM;
                        }
                    } else if (AssistType.MQ.appliesTo(ResourceContentProposals.this.loadProposalsFor) && ResourceContentProposals.this.isAllowedResourceType(MessageQueue.class)) {
                        String mqmName = ResourceContentProposals.this.loadProposalsFor.substring("MQ:".length(), sep);
                        if (!MessageQueueManager.isValidName((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)mqmName)) {
                            throw new InterruptedException();
                        }
                        MessageQueueManager mqm = MessageQueueManager.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)mqmName);
                        MessageQueueQuery mqQuery = MessageQueueQuery.create((MessageQueueManager)mqm, (String)"*");
                        Result result = mqQuery.loadMessageQueues(howIsGoing, false);
                        List mqs = (List)result.getOutput();
                        if (mqs != null) {
                            int i = 0;
                            ResourceContentProposals.this.proposals = new IContentProposal[mqs.size()];
                            for (MessageQueue mq : mqs) {
                                String content = mq.getFormattedName();
                                Object label7 = content;
                                if (mqm.getConnectionCode() != 0) {
                                    label7 = (String)label7 + " " + Messages.ResourceContentProposals_CANT_CONNECT;
                                }
                                String description = MessageFormat.format(Messages.ResourceContentProposals_MQ_PROPERTIES, mqm.getSystem(), mqm.getName(), mqm.getConnectionCode());
                                ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, (String)label7, description);
                            }
                            ResourceContentProposals.this.lastLoaded = AssistType.MQ;
                        }
                    }
                } else if (AssistType.USS.appliesTo(ResourceContentProposals.this.loadProposalsFor)) {
                    if (ResourceContentProposals.this.isAllowedResourceType(UssFile.class) && UssFile.isParseableAbsolutePath((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)ResourceContentProposals.this.loadProposalsFor)) {
                        String parsed = ResourceContentProposals.this.loadProposalsFor.substring(0, ResourceContentProposals.this.loadProposalsFor.lastIndexOf("/") + 1);
                        UssFile uss = UssFile.parse((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)parsed);
                        Result result = uss.loadFiles(howIsGoing, false);
                        List files = (List)result.getOutput();
                        if (files != null) {
                            int i = 0;
                            ResourceContentProposals.this.proposals = new IContentProposal[files.size()];
                            for (UssFile file : files) {
                                String content;
                                String label8 = content = file.getFormattedName();
                                String description = MessageFormat.format(Messages.ResourceContentProposals_USS_PROPERTIES, file.getSystem(), file.getName(), file.getFormattedName(), file.getType().getName());
                                ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label8, description);
                            }
                            ResourceContentProposals.this.lastLoaded = AssistType.USS;
                        }
                    }
                } else if (AssistType.MEM.appliesTo(ResourceContentProposals.this.loadProposalsFor)) {
                    if (ResourceContentProposals.this.isAllowedResourceType(Member.class)) {
                        int memSep = ResourceContentProposals.this.loadProposalsFor.indexOf("(");
                        String dsname = ResourceContentProposals.this.loadProposalsFor.substring(0, memSep);
                        if (!DataSet.isValidName((String)dsname, (String)ResourceContentProposals.this.hostProvider.getSystem().getCodePage())) {
                            throw new InterruptedException();
                        }
                        DataSet dataSet = DataSet.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)dsname);
                        dataSet.refreshSelf(howIsGoing);
                        List members = dataSet.getMembers();
                        if (members != null) {
                            int i = 0;
                            ResourceContentProposals.this.proposals = new IContentProposal[members.size()];
                            for (Member member : members) {
                                String content;
                                String label9 = content = member.getFormattedName();
                                String description = MessageFormat.format(Messages.ResourceContentProposals_MEMBER_PROPERTIES, member.getSystem(), member.asDataSet().getFormattedName(), member.getName());
                                ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label9, description);
                            }
                            ResourceContentProposals.this.lastLoaded = AssistType.MEM;
                        }
                    }
                } else if (AssistType.DS.appliesTo(ResourceContentProposals.this.loadProposalsFor) && (ResourceContentProposals.this.isAllowedResourceType(DataSet.class) || ResourceContentProposals.this.isAllowedResourceType(Member.class))) {
                    DataSetQuery query;
                    int lastSep = ResourceContentProposals.this.loadProposalsFor.lastIndexOf(".");
                    if (lastSep <= 0) {
                        query = DataSetQuery.createBrowseUser((IPDHost)ResourceContentProposals.this.hostProvider.getSystem());
                    } else if (DataSetQuery.isValidQuery((String)(ResourceContentProposals.this.loadProposalsFor.substring(0, lastSep + 1) + "**"), (String)ResourceContentProposals.this.hostProvider.getSystem().getCodePage())) {
                        query = DataSetQuery.create((IPDHost)ResourceContentProposals.this.hostProvider.getSystem(), (String)(ResourceContentProposals.this.loadProposalsFor.substring(0, lastSep + 1) + "**"));
                    } else {
                        throw new InterruptedException();
                    }
                    query.setFetchingProperties(false);
                    Result result = query.loadDataSets(howIsGoing);
                    List dataSets = (List)result.getOutput();
                    if (dataSets != null) {
                        int i = 0;
                        ResourceContentProposals.this.proposals = new IContentProposal[dataSets.size()];
                        for (DataSet dataSet : dataSets) {
                            String content;
                            String label10 = content = dataSet.getFormattedName();
                            String description = MessageFormat.format(Messages.ResourceContentProposals_DATA_SET_PROPERTIES, dataSet.getSystem(), dataSet.getFormattedName(), dataSet.getType().toString());
                            ResourceContentProposals.this.proposals[i++] = new SimpleContentProposal(content, label10, description);
                        }
                        ResourceContentProposals.this.lastLoaded = AssistType.DS;
                    }
                }
            }
            catch (InterruptedException e) {
                ResourceContentProposals.this.lastLoaded = null;
                return Status.CANCEL_STATUS;
            }
            Arrays.sort(ResourceContentProposals.this.proposals, new Comparator<IContentProposal>(){

                @Override
                public int compare(IContentProposal o1, IContentProposal o2) {
                    return new ByteStringComparator((this).ResourceContentProposals.this.hostProvider.getSystem().getHostType()).compare(o1.getContent(), o2.getContent());
                }
            });
            if (ResourceContentProposals.this.forcedLoad || ResourceContentProposals.this.proposals.length > 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ResourceContentProposals.this.adapter.getControl() != null && !(this).ResourceContentProposals.this.adapter.getControl().isDisposed() && (this).ResourceContentProposals.this.adapter.getControl().isFocusControl()) {
                            (this).ResourceContentProposals.this.adapter.openProposalPopup();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };

    public static ResourceContentProposals getInstance(Control control) {
        Objects.requireNonNull(control, "Must provide a non-null control.");
        Object data = control.getData(RCP_ID);
        if (data instanceof ResourceContentProposals) {
            return (ResourceContentProposals)data;
        }
        return null;
    }

    public static ResourceContentProposals addTo(Combo combo2, IHostProvider system, String id, Class<?> ... allowedResourceTypes) {
        FMAssert.assertNotNull((Object)combo2);
        FMAssert.assertNotNull((Object)system);
        FMAssert.assertNotNull((Object)id);
        String comboText = combo2.getText();
        ResourceContentProposals rcp = new ResourceContentProposals((Control)combo2, (IControlContentAdapter)new ComboContentAdapter(), system);
        rcp.setAllowedResourceTypes(allowedResourceTypes);
        final IPDHost host = system.getSystem();
        new ComboValueSaver(combo2, id, host){

            protected boolean shouldSave(String value) {
                return ZRLs.isParseable((IPDHost)host, (String)value);
            }
        };
        if (!comboText.isEmpty() && !comboText.equals(combo2.getText())) {
            logger.trace((Object)MessageFormat.format("copying old back to combo old: {0} new {1}", comboText, combo2.getText()));
            combo2.setText(comboText);
        }
        return rcp;
    }

    public ResourceContentProposals(Control control, IControlContentAdapter contentAdaptor, IHostProvider hostProvider) {
        this.setHostProviderInternal(hostProvider);
        this.control = Objects.requireNonNull(control);
        this.contentAdapter = Objects.requireNonNull(contentAdaptor);
        this.hint = new ControlDecoration(control, 16512);
        this.hint.setShowOnlyOnFocus(true);
        this.updateHint();
        this.adapter = new ResourceContentProposalAdapter();
        this.adapter.setProposalAcceptanceStyle(2);
        control.setData(RCP_ID, (Object)this);
    }

    public void setAllowedResourceTypes(Class<?>[] allowedResourceTypes) {
        FMAssert.assertItemsInArray((Object[])allowedResourceTypes, (Object[])ResourceContentProposals.getValidTypes());
        this.allowedTypes = Arrays.asList(allowedResourceTypes).toArray(new Class[0]);
        this.updateHint();
    }

    private void updateHint() {
        if (this.allowedTypes.length == 0) {
            this.hint.setImage(null);
            this.hint.setDescriptionText(null);
        } else {
            String description;
            FieldDecoration cp = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            this.hint.setImage(cp.getImage());
            if (this.allowedTypes.length == 1) {
                String item = ResourceLookupDialog.getNameOfType(this.allowedTypes[0]);
                description = MessageFormat.format(Messages.ResourceContentProposals_HINT_ITEM_SINGLE, item);
            } else {
                StringBuilder itemListSb = new StringBuilder();
                int i = 0;
                while (i < this.allowedTypes.length - 1) {
                    Class<?> type = this.allowedTypes[i];
                    if (i > 0 && i != this.allowedTypes.length - 1) {
                        itemListSb.append(", ");
                    }
                    itemListSb.append(ResourceLookupDialog.getNameOfType(type));
                    ++i;
                }
                String lastItem = ResourceLookupDialog.getNameOfType(this.allowedTypes[this.allowedTypes.length - 1]);
                description = MessageFormat.format(Messages.ResourceContentProposals_HINT_ITEM_LIST, itemListSb.toString(), lastItem);
            }
            this.hint.setDescriptionText(description);
        }
    }

    public IContentProposal[] getProposals(String contents, int position) {
        int lastSepIncSel;
        int lastSep;
        if (this.lastLoaded == null) {
            return new IContentProposal[0];
        }
        final String filter = contents.substring(0, position);
        if (this.lastLoaded == AssistType.CICSAPPID) {
            if (filter.indexOf(":", 3) > 0) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.CICSFILE || this.lastLoaded == AssistType.CICSTD || this.lastLoaded == AssistType.CICSTS) {
            if (filter.indexOf(":", 3) < 0) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.MQM) {
            sepPosInPrefix = "MQ:".indexOf(":");
            if (filter.indexOf(":", sepPosInPrefix + 1) > 0) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.MQ) {
            sepPosInPrefix = "MQ:".indexOf(":");
            if (filter.indexOf(":", sepPosInPrefix + 1) < 0) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.USS) {
            int lastSepIncSel2;
            lastSep = this.loadProposalsFor.lastIndexOf("/", position);
            if (lastSep != (lastSepIncSel2 = filter.lastIndexOf("/", position))) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.DS) {
            int lastSepIncSel3;
            lastSep = this.loadProposalsFor.lastIndexOf(".", position);
            if (lastSep > (lastSepIncSel3 = filter.lastIndexOf(".", position))) {
                this.adapter.actuallyCloseProposalPopup();
                return new IContentProposal[0];
            }
        } else if (this.lastLoaded == AssistType.MEM && (lastSep = this.loadProposalsFor.lastIndexOf("(", position)) != (lastSepIncSel = filter.lastIndexOf("(", position))) {
            this.adapter.actuallyCloseProposalPopup();
            return new IContentProposal[0];
        }
        IContentProposal[] array = ArrayUtils.filter((Object[])this.proposals, (ArrayUtils.ArrayTester)new ArrayUtils.ArrayTester<IContentProposal>(){

            protected boolean test(IContentProposal obj) {
                if (obj == null) {
                    return false;
                }
                if (ResourceContentProposals.this.lastLoaded == AssistType.DS) {
                    return obj.getContent().toLowerCase().contains(filter.toLowerCase());
                }
                return obj.getContent().toLowerCase().startsWith(filter.toLowerCase());
            }
        }).toArray(new IContentProposal[0]);
        return array;
    }

    private <E extends IZRL> boolean isAllowedResourceType(Class<E> resourceType) {
        Class<?>[] classArray = this.allowedTypes;
        int n = this.allowedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> allowedType = classArray[n2];
            if (resourceType.isAssignableFrom(allowedType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Control getControl() {
        return this.control;
    }

    public LazyContentProposalAdapter getAdapter() {
        return this.adapter;
    }

    public void setHostProvider(IPDHost hostProvider) {
        this.proposalLoader.cancel();
        this.lastLoaded = null;
        this.setHostProviderInternal((IHostProvider)hostProvider);
    }

    private void setHostProviderInternal(final IHostProvider hostProvider) {
        Objects.requireNonNull(hostProvider);
        this.hostProvider = new IHostProvider(){

            public IPDHost getSystem() {
                return (IPDHost)PDSafeUIRunner.syncExec((Callable)new Callable<IPDHost>(){

                    @Override
                    public IPDHost call() throws Exception {
                        return hostProvider.getSystem();
                    }
                });
            }
        };
    }

    public static Class<?>[] getValidTypes() {
        return VALID_TYPES;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum AssistType {
        CICSAPPID(":"){

            @Override
            public boolean appliesTo(String contents) {
                return contents.lastIndexOf(":") == 2 && (contents.toUpperCase().startsWith("FI:") || contents.toUpperCase().startsWith("TS:") || contents.toUpperCase().startsWith("TD:"));
            }
        }
        ,
        CICSFILE(":"){

            @Override
            public boolean appliesTo(String contents) {
                return contents.toUpperCase().startsWith("FI:") && contents.indexOf(":", 2) > 0;
            }
        }
        ,
        CICSTD(":"){

            @Override
            public boolean appliesTo(String contents) {
                return contents.toUpperCase().startsWith("TD:") && contents.indexOf(":", 2) > 0;
            }
        }
        ,
        CICSTS(":"){

            @Override
            public boolean appliesTo(String contents) {
                return contents.toUpperCase().startsWith("TS:") && contents.indexOf(":", 2) > 0;
            }
        }
        ,
        MQM(":"){

            @Override
            public boolean appliesTo(String contents) {
                int sepPosInPrefix = "MQ:".indexOf(":");
                int sep = contents.indexOf(":", sepPosInPrefix + 1);
                return sep < 0;
            }
        }
        ,
        MQ(":"){

            @Override
            public boolean appliesTo(String contents) {
                int sepPosInPrefix = "MQ:".indexOf(":");
                int sep = contents.indexOf(":", sepPosInPrefix + 1);
                return sep >= 0;
            }
        }
        ,
        USS("/"){

            @Override
            public boolean appliesTo(String contents) {
                return contents.startsWith("/");
            }
        }
        ,
        DS("."){

            @Override
            public boolean appliesTo(String contents) {
                return contents.indexOf("(") < 0;
            }
        }
        ,
        MEM("("){

            @Override
            public boolean appliesTo(String contents) {
                return contents.indexOf("(") >= 0;
            }
        };

        private final char trigger;

        private AssistType(String trigger) {
            this.trigger = trigger.charAt(0);
            if (trigger.length() != 1) {
                logger.debug(new Object[]{"Trigger length != 0, ignoring other characters of trigger ", trigger});
            }
        }

        public boolean isTriggeredBy(String contents, char c) {
            return this.trigger == c && this.appliesTo(contents + c);
        }

        public abstract boolean appliesTo(String var1);
    }

    private class ResourceContentProposalAdapter
    extends LazyContentProposalAdapter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public ResourceContentProposalAdapter() {
            super(ResourceContentProposals.this.control, ResourceContentProposals.this.contentAdapter, ResourceContentProposals.this);
            ResourceContentProposals.this.control.addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    String controlContents = ((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.contentAdapter.getControlContents(((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.control);
                    if (e.keyCode == 32 && (e.stateMask & 0x40000) == 262144) {
                        ResourceContentProposalAdapter.this.triggerLoad(true, controlContents, 0);
                        e.doit = false;
                        return;
                    }
                    AssistType[] assistTypeArray = AssistType.values();
                    int n = assistTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AssistType at = assistTypeArray[n2];
                        if (at.isTriggeredBy(controlContents, e.character)) {
                            ResourceContentProposalAdapter.this.triggerLoad(false, controlContents + e.character, 1);
                            return;
                        }
                        ++n2;
                    }
                    if (!((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.forcedLoad) {
                        ((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.proposalLoader.cancel();
                    }
                }
            });
            ResourceContentProposals.this.control.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.proposalLoader != null && ((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.proposalLoader.getState() != 0) {
                        logger.trace((Object)"Focus from assisted field lost, aborting resource proposal loading");
                        ((ResourceContentProposalAdapter)ResourceContentProposalAdapter.this).ResourceContentProposals.this.proposalLoader.cancel();
                    }
                }
            });
        }

        private void triggerLoad(boolean forced, String loadFor, int selOffset) {
            int selectionIndex = loadFor.length();
            if (ResourceContentProposals.this.contentAdapter instanceof IControlContentAdapter2) {
                IControlContentAdapter2 selAdapter = (IControlContentAdapter2)ResourceContentProposals.this.contentAdapter;
                Point selection = selAdapter.getSelection(ResourceContentProposals.this.control);
                selectionIndex = Math.min(selection.x, selection.y);
            }
            String newLoadProposalsFor = loadFor.substring(0, selectionIndex + selOffset);
            logger.trace((Object)("Load requested; forced? " + forced + "  newLoadProposalsFor: " + newLoadProposalsFor + "  existing loadProposalsFor: " + ResourceContentProposals.this.loadProposalsFor));
            if (ResourceContentProposals.this.loadProposalsFor == null || !newLoadProposalsFor.startsWith(ResourceContentProposals.this.loadProposalsFor) || forced) {
                ResourceContentProposals.this.forcedLoad = forced;
                ResourceContentProposals.this.loadProposalsFor = newLoadProposalsFor;
                ResourceContentProposals.this.proposalLoader.cancel();
                if (!ResourceContentProposals.this.loadProposalsFor.isEmpty() || forced) {
                    ResourceContentProposals.this.proposalLoader.schedule(forced ? 0L : 1000L);
                }
            }
        }
    }

    private static class SimpleContentProposal
    implements IContentProposal,
    Comparable<SimpleContentProposal> {
        private final String content;
        private final String description;
        private final String label;

        public SimpleContentProposal(String content, String label2, String description) {
            this.content = content;
            this.label = label2;
            this.description = description;
        }

        public String getContent() {
            return this.content;
        }

        public int getCursorPosition() {
            return this.content.length();
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.content;
        }

        @Override
        public int compareTo(SimpleContentProposal o) {
            return this.content.compareTo(o.content);
        }
    }
}

