/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NumberForcer {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int DEFAULT_UPPER_BOUND = Integer.MAX_VALUE;
    public static final int DEFAULT_LOWER_BOUND = 0;
    public static final boolean DEFAULT_UPPER_BOUND_INCLUSIVE = false;
    public static final boolean DEFAULT_LOWER_BOUND_INCLUSIVE = true;
    protected static final PDLogger logger = PDLogger.get(NumberForcer.class);
    private int upperBound = Integer.MAX_VALUE;
    private int lowerBound = 0;
    private boolean upperBoundInclusive = false;
    private boolean lowerBoundInclusive = true;
    private boolean usingAutoTooltip = true;
    private final Control control;
    private Listener verifyListener = new Listener(){

        public void handleEvent(Event event) {
            String existingText;
            Object newText = event.text;
            if (newText != null && ((String)newText).length() > 0 && NumberForcer.this.failsBounds((String)(newText = (existingText = NumberForcer.this.getText()).substring(0, event.start) + (String)newText + existingText.substring(event.end)), false)) {
                event.doit = false;
            }
        }
    };

    public static NumberForcer addTo(Combo combo2, String valueSaverName) {
        Objects.requireNonNull(combo2, "Must specify a non-null combo.");
        return new NumberForcer(combo2, valueSaverName);
    }

    public static NumberForcer addTo(Text text2) {
        Objects.requireNonNull(text2, "Must specify a non-null text.");
        return new NumberForcer((Control)text2);
    }

    protected NumberForcer(Combo combo2, String valueSaverName) {
        this((Control)Objects.requireNonNull(combo2, "Must specify a non-null combo."));
        if (valueSaverName != null) {
            new ComboValueSaver(combo2, valueSaverName){

                protected boolean shouldSave(String value) {
                    return !NumberForcer.this.failsBounds(value, true) && super.shouldSave(value);
                }
            };
        }
    }

    protected NumberForcer(Control control) {
        Objects.requireNonNull(control, "Must specify a non-null control.");
        this.control = control;
        this.getText();
        control.addListener(25, this.verifyListener);
        this.updateTooltipText();
    }

    private boolean failsBounds(String textNum, boolean failOnPartial) {
        try {
            boolean failsUpperBound;
            boolean failsLowerBound;
            int num = Integer.parseInt(textNum);
            boolean bl = this.lowerBoundInclusive ? this.lowerBound > num : (failsLowerBound = this.lowerBound >= num);
            boolean bl2 = this.upperBoundInclusive ? num > this.upperBound : (failsUpperBound = num >= this.upperBound);
            return failsLowerBound || failsUpperBound;
        }
        catch (Exception e) {
            return failOnPartial || !textNum.equals("-") || this.lowerBound >= 0;
        }
    }

    private String getText() {
        if (this.control instanceof Combo) {
            return ((Combo)this.control).getText();
        }
        if (this.control instanceof Text) {
            return ((Text)this.control).getText();
        }
        throw new IllegalArgumentException();
    }

    private void updateTooltipText() {
        if (this.usingAutoTooltip) {
            this.control.setToolTipText(this.getToolTip());
        }
    }

    public String getToolTip() {
        boolean lowerBounded = this.lowerBound != Integer.MIN_VALUE;
        boolean upperBounded = this.upperBound != Integer.MAX_VALUE;
        String tooltip = "";
        tooltip = lowerBounded && this.lowerBoundInclusive && upperBounded && this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_AT_LEAST_UPPER_AT_MOST, this.lowerBound, this.upperBound) : (lowerBounded && this.lowerBoundInclusive && upperBounded && !this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_AT_LEAST_UPPER_LESS_THAN, this.lowerBound, this.upperBound) : (lowerBounded && !this.lowerBoundInclusive && upperBounded && this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_MORE_THAN_UPPER_AT_MOST, this.lowerBound, this.upperBound) : (lowerBounded && !this.lowerBoundInclusive && upperBounded && !this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_MORE_THAN_UPPER_LESS_THAN, this.lowerBound, this.upperBound) : (upperBounded && this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_UPPER_AT_MOST, this.upperBound) : (upperBounded && !this.upperBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_UPPER_LESS_THAN, this.upperBound) : (lowerBounded && this.lowerBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_AT_LEAST, this.lowerBound) : (lowerBounded && !this.lowerBoundInclusive ? MessageFormat.format(Messages.NumberForcer_NUMBER_LOWER_MORE_THAN, this.lowerBound) : Messages.NumberForcer_NUMBER_ANY)))))));
        return tooltip;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUpperBound(int upper, boolean inclusive) {
        this.upperBound = upper;
        this.upperBoundInclusive = inclusive;
        this.updateTooltipText();
    }

    public void setLowerBound(int lower, boolean inclusive) {
        if (lower > 9) {
            logger.warn((Object)"Lower bound > 9 will cause problems - users will not be able to type in their first character properly");
        }
        this.lowerBound = lower;
        this.lowerBoundInclusive = inclusive;
        this.updateTooltipText();
    }

    public static void addNumberForcerPositiveInteger(Combo combo2, String id) {
        Objects.requireNonNull(combo2, "Must provide a non-null parent combo.");
        NumberForcer.addNumberForcer(combo2, id, 1, true, Integer.MAX_VALUE, true);
    }

    public static void addNumberForcer(Combo combo2, String id, int lower, boolean lowerInclusive, int upper, boolean upperInclusive) {
        Objects.requireNonNull(combo2, "Must provide a non-null parent combo.");
        NumberForcer nf = NumberForcer.addTo(combo2, id);
        nf.setLowerBound(lower, lowerInclusive);
        nf.setUpperBound(upper, upperInclusive);
    }
}

