/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MemberSelectionCriteriaModel
extends BasicModelObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MemberSelectionCriteriaModel.class);
    private static final String MEMBER_MULTI_WILDCARD = "*";
    private static final String MEMBER_SINGLE_WILDCARD = "%";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private boolean usingRange = false;
    private String membersRangeStart = "*";
    private String membersRangeEnd = "";
    private boolean usingCreated = false;
    private Calendar membersCreatedStart = null;
    private Calendar membersCreatedEnd = null;
    private boolean usingChanged = false;
    private Calendar membersChangedStart = null;
    private Calendar membersChangedEnd = null;
    private boolean usingUserID = false;
    private String membersUserIDStart = "*";
    private String membersUserIDEnd = "";
    private String excludeValue = "";

    public MemberSelectionCriteriaModel(IPDHost host) {
        super(host);
    }

    public Object clone() {
        MemberSelectionCriteriaModel copy = new MemberSelectionCriteriaModel(this.getHostProvider());
        copy.usingRange = this.usingRange;
        copy.membersRangeStart = this.membersRangeStart;
        copy.membersRangeEnd = this.membersRangeEnd;
        copy.usingCreated = this.usingCreated;
        copy.membersCreatedStart = this.membersCreatedStart;
        copy.membersCreatedEnd = this.membersCreatedEnd;
        copy.usingChanged = this.usingChanged;
        copy.membersChangedStart = this.membersChangedStart;
        copy.membersChangedEnd = this.membersChangedEnd;
        copy.usingUserID = this.usingUserID;
        copy.membersUserIDStart = this.membersUserIDStart;
        copy.membersUserIDEnd = this.membersUserIDEnd;
        copy.excludeValue = this.excludeValue;
        return copy;
    }

    public void clear() {
        this.usingRange = false;
        this.membersRangeStart = MEMBER_MULTI_WILDCARD;
        this.membersRangeEnd = "";
        this.usingCreated = false;
        this.membersCreatedStart = null;
        this.membersCreatedEnd = null;
        this.usingChanged = false;
        this.membersChangedStart = null;
        this.membersChangedEnd = null;
        this.usingUserID = false;
        this.membersUserIDStart = MEMBER_MULTI_WILDCARD;
        this.membersUserIDEnd = "";
        this.excludeValue = "";
    }

    public boolean isNoMemberSelected() {
        boolean none = true;
        none = none && !this.isUsingRange();
        none = none && !this.isUsingCreated();
        none = none && !this.isUsingChanged();
        none = none && !this.isUsingUserID();
        return none;
    }

    public boolean isSingleMemberSelected() {
        boolean single = true;
        single = single && this.isUsingRange() && this.getMembersRangeStart().equals(this.getMembersRangeEnd()) && !MemberSelectionCriteriaModel.hasWildcard(this.getMembersRangeStart());
        single = single && !this.isUsingCreated();
        single = single && !this.isUsingChanged();
        single = single && !this.isUsingUserID();
        return single;
    }

    public boolean isMultipleMembersSelected(boolean ignorePossibles) {
        boolean multi = false;
        multi = multi || !this.getMembersRangeStart().equals(this.getMembersRangeEnd());
        multi = multi || MemberSelectionCriteriaModel.hasWildcard(this.getMembersRangeStart());
        boolean bl = multi = multi || MemberSelectionCriteriaModel.hasWildcard(this.getMembersRangeEnd());
        if (!ignorePossibles) {
            multi = multi || this.isUsingCreated();
            multi = multi || this.isUsingChanged();
            multi = multi || this.isUsingUserID();
        }
        return multi;
    }

    private static boolean hasWildcard(String range) {
        return range.indexOf(MEMBER_MULTI_WILDCARD) >= 0 || range.indexOf(MEMBER_SINGLE_WILDCARD) >= 0;
    }

    public boolean isRangesInUse() {
        return this.isUsingRange() || this.isUsingCreated() || this.isUsingChanged() || this.isUsingUserID();
    }

    public String getMembersRangeStartSet() {
        return this.membersRangeStart;
    }

    public String getMembersRangeStart() {
        if (this.usingRange && !MEMBER_MULTI_WILDCARD.equals(this.membersRangeStart)) {
            return this.membersRangeStart;
        }
        return "";
    }

    public void setMembersRangeStart(String membersRangeStart) {
        this.membersRangeStart = membersRangeStart;
    }

    public String getMembersRangeEndSet() {
        return this.membersRangeEnd;
    }

    public String getMembersRangeEnd() {
        if (this.usingRange && !MEMBER_MULTI_WILDCARD.equals(this.membersRangeEnd)) {
            return this.membersRangeEnd;
        }
        return "";
    }

    public void setMembersRangeEnd(String membersRangeEnd) {
        this.membersRangeEnd = membersRangeEnd;
    }

    public Calendar getMembersCreatedStart() {
        if (this.usingCreated) {
            return this.membersCreatedStart;
        }
        return null;
    }

    public String getMembersCreatedStartFormatted() {
        Calendar createStart = this.getMembersCreatedStart();
        return createStart == null ? null : dateFormat.format(createStart.getTime());
    }

    public void setMembersCreatedStart(String membersCreatedStart, DateFormat parser) {
        if (membersCreatedStart.isEmpty()) {
            return;
        }
        try {
            Date date = parser.parse(membersCreatedStart);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setMembersCreatedStart(cal);
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse date [" + membersCreatedStart + "] with " + String.valueOf(parser)), (Throwable)e);
        }
    }

    public void setMembersCreatedStart(Calendar membersCreatedStart) {
        this.membersCreatedStart = membersCreatedStart;
    }

    public Calendar getMembersCreatedEnd() {
        if (this.usingCreated) {
            return this.membersCreatedEnd;
        }
        return null;
    }

    public String getMembersCreatedEndFormatted() {
        Calendar createStart = this.getMembersCreatedEnd();
        return createStart == null ? null : dateFormat.format(createStart.getTime());
    }

    public void setMembersCreatedEnd(String membersCreatedEnd, DateFormat parser) {
        if (membersCreatedEnd.isEmpty()) {
            return;
        }
        try {
            Date date = parser.parse(membersCreatedEnd);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setMembersCreatedEnd(cal);
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse date [" + membersCreatedEnd + "] with " + String.valueOf(parser)), (Throwable)e);
        }
    }

    public void setMembersCreatedEnd(Calendar membersCreatedEnd) {
        this.membersCreatedEnd = membersCreatedEnd;
    }

    public Calendar getMembersChangedStart() {
        if (this.usingChanged) {
            return this.membersChangedStart;
        }
        return null;
    }

    public String getMembersChangedStartFormatted() {
        Calendar createStart = this.getMembersChangedStart();
        return createStart == null ? null : dateFormat.format(createStart.getTime());
    }

    public void setMembersChangedStart(String membersChangedStart, DateFormat parser) {
        if (membersChangedStart.isEmpty()) {
            return;
        }
        try {
            Date date = parser.parse(membersChangedStart);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setMembersChangedStart(cal);
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse date [" + membersChangedStart + "] with " + String.valueOf(parser)), (Throwable)e);
        }
    }

    public void setMembersChangedStart(Calendar membersChangedStart) {
        this.membersChangedStart = membersChangedStart;
    }

    public Calendar getMembersChangedEnd() {
        if (this.usingChanged) {
            return this.membersChangedEnd;
        }
        return null;
    }

    public String getMembersChangedEndFormatted() {
        Calendar createStart = this.getMembersChangedEnd();
        return createStart == null ? null : dateFormat.format(createStart.getTime());
    }

    public void setMembersChangedEnd(String membersChangedEnd, DateFormat parser) {
        if (membersChangedEnd.isEmpty()) {
            return;
        }
        try {
            Date date = parser.parse(membersChangedEnd);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setMembersChangedEnd(cal);
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse date [" + membersChangedEnd + "] with " + String.valueOf(parser)), (Throwable)e);
        }
    }

    public void setMembersChangedEnd(Calendar membersChangedEnd) {
        this.membersChangedEnd = membersChangedEnd;
    }

    public String getMembersUserIDStartSet() {
        return this.membersUserIDStart;
    }

    public String getMembersUserIDStart() {
        if (this.usingUserID && !MEMBER_MULTI_WILDCARD.equals(this.membersUserIDStart)) {
            return this.membersUserIDStart.toUpperCase();
        }
        return "";
    }

    public void setMembersUserIDStart(String membersUserIDStart) {
        this.membersUserIDStart = membersUserIDStart;
    }

    public String getMembersUserIDEndSet() {
        return this.membersUserIDEnd;
    }

    public String getMembersUserIDEnd() {
        if (this.usingUserID && !MEMBER_MULTI_WILDCARD.equals(this.membersUserIDEnd)) {
            return this.membersUserIDEnd.toUpperCase();
        }
        return "";
    }

    public void setMembersUserIDEnd(String membersUserIDEnd) {
        this.membersUserIDEnd = membersUserIDEnd;
    }

    public boolean isUsingRange() {
        return this.usingRange;
    }

    public void setUsingRange(boolean usingRange) {
        this.usingRange = usingRange;
    }

    public boolean isUsingCreated() {
        return this.usingCreated;
    }

    public void setUsingCreated(boolean usingCreated) {
        this.usingCreated = usingCreated;
    }

    public boolean isUsingChanged() {
        return this.usingChanged;
    }

    public void setUsingChanged(boolean usingChanged) {
        this.usingChanged = usingChanged;
    }

    public boolean isUsingUserID() {
        return this.usingUserID;
    }

    public void setUsingUserID(boolean usingUserID) {
        this.usingUserID = usingUserID;
    }

    public String getExcludeValue() {
        return this.excludeValue;
    }

    public void setExcludeValue(String excludeValue) {
        this.excludeValue = excludeValue;
    }
}

