/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.widget.MemberSelectionCriteriaModel;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Calendar;
import java.util.Objects;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MemberSelectionCriteriaComposite
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final MemberSelectionCriteriaModel model;
    private final MemberSelectionCriteriaCompositeConnector connector = new MemberSelectionCriteriaCompositeConnector();
    private Button wMembersRangeSpecified;
    private Combo wMembersRangeStart;
    private Combo wMembersRangeEnd;
    private Combo wExcludeMembers;
    private Button wMembersCreatedSpecified;
    private DateTime wMembersCreatedStart;
    private DateTime wMembersCreatedEnd;
    private Button wMembersChangedSpecified;
    private DateTime wMembersChangedStart;
    private DateTime wMembersChangedEnd;
    private Button wMembersUserIDSpecified;
    private Combo wMembersUserIDStart;
    private Combo wMembersUserIDEnd;
    private boolean isUndefinedLengthDataSet;
    private boolean enabled = false;
    private boolean createdEnabled = true;
    private boolean changedEnabled = true;
    private boolean useridEnabled = true;

    public MemberSelectionCriteriaComposite(Composite parent, int style, MemberSelectionCriteriaModel model) {
        super(parent, style);
        this.model = Objects.requireNonNull(model, "Must provide a non-null model");
        this.setLayout((Layout)GUI.grid.l.noMargins((int)5, (boolean)false));
        this.wMembersRangeSpecified = GUI.button.checkbox((Composite)this, (String)Messages.Label__NAME, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)this, (String)Messages.__FROM, (Object)GUI.grid.d.left1());
        this.wMembersRangeStart = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRangeStart, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersRangeStart");
        GUI.label.left((Composite)this, (String)Messages.__TO, (Object)GUI.grid.d.left1());
        this.wMembersRangeEnd = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersRangeEnd, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersRangeEnd");
        GUI.label.left((Composite)this, (String)"Exclude members:", (Object)GUI.grid.d.left1());
        this.wExcludeMembers = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)4));
        new ComboValueSaver(this.wExcludeMembers, ((Object)((Object)this)).getClass().getCanonicalName() + "ExcludeMembers");
        GUI.grid.padding((Composite)this, (int)1);
        GUI.label.left((Composite)this, (String)"ISPF Statistics Criteria", (Object)GUI.grid.d.fillH((int)5));
        this.wMembersCreatedSpecified = GUI.button.checkbox((Composite)this, (String)Messages.Label__CREATED, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)this, (String)Messages.__FROM, (Object)GUI.grid.d.left1());
        this.wMembersCreatedStart = GUI.datetime.date((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this, (String)Messages.__TO, (Object)GUI.grid.d.left1());
        this.wMembersCreatedEnd = GUI.datetime.date((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        this.wMembersChangedSpecified = GUI.button.checkbox((Composite)this, (String)Messages.Label__CHANGED, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)this, (String)Messages.__FROM, (Object)GUI.grid.d.left1());
        this.wMembersChangedStart = GUI.datetime.date((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this, (String)Messages.__TO, (Object)GUI.grid.d.left1());
        this.wMembersChangedEnd = GUI.datetime.date((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        this.wMembersUserIDSpecified = GUI.button.checkbox((Composite)this, (String)Messages.Label__USER_ID, (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)this, (String)Messages.__FROM, (Object)GUI.grid.d.left1());
        this.wMembersUserIDStart = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersUserIDStart, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersUserIDStart");
        GUI.label.left((Composite)this, (String)Messages.__TO, (Object)GUI.grid.d.left1());
        this.wMembersUserIDEnd = GUI.combo.editable((Composite)this, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wMembersUserIDEnd, ((Object)((Object)this)).getClass().getCanonicalName() + "MembersUserIDEnd");
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                MemberSelectionCriteriaComposite.this.dispose();
            }
        });
        this.connector.listenTo(model);
        this.connector.listenTo((Control)this.wMembersRangeSpecified);
        this.connector.listenTo((Control)this.wMembersRangeStart);
        this.connector.listenTo((Control)this.wMembersRangeEnd);
        this.connector.listenTo((Control)this.wMembersCreatedSpecified);
        this.connector.listenTo((Control)this.wMembersCreatedStart);
        this.connector.listenTo((Control)this.wMembersCreatedEnd);
        this.connector.listenTo((Control)this.wMembersChangedSpecified);
        this.connector.listenTo((Control)this.wMembersChangedStart);
        this.connector.listenTo((Control)this.wMembersChangedEnd);
        this.connector.listenTo((Control)this.wMembersUserIDSpecified);
        this.connector.listenTo((Control)this.wMembersUserIDStart);
        this.connector.listenTo((Control)this.wMembersUserIDEnd);
    }

    protected void onViewUpdated() {
    }

    public String getValidationErrorMessage() {
        if (this.model.isUsingCreated() && this.model.getMembersCreatedStart().after(this.model.getMembersCreatedEnd())) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_CREATED_RANGE;
        }
        if (this.model.isUsingChanged() && this.model.getMembersChangedStart().after(this.model.getMembersChangedEnd())) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_CHANGED_RANGE;
        }
        if (this.model.isUsingRange() && !UIValidator.isValidWildcardableMember(this.model.getMembersRangeStartSet(), this.model.getSystem().getCodePage())) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_START_MEMBER_NAME;
        }
        if (this.model.isUsingRange() && !UIValidator.isValidWildcardableMember(this.model.getMembersRangeEndSet(), this.model.getSystem().getCodePage())) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_END_MEMBER_NAME;
        }
        if (this.model.isUsingUserID() && this.model.getMembersUserIDStartSet().isEmpty()) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_START_UID;
        }
        if (this.model.isUsingUserID() && this.model.getMembersUserIDEndSet().isEmpty()) {
            return Messages.MemberSelectionCriteriaComposite_INVALID_END_UID;
        }
        return null;
    }

    public void setResource(IZRL resource) {
        this.isUndefinedLengthDataSet = false;
        this.enabled = false;
        if (resource instanceof DataSet) {
            DataSet dataSet = (DataSet)resource;
            this.enabled = dataSet.getHasMembers() || dataSet.getType() == DataSetType.UNKNOWN;
            DataSetProperties properties = dataSet.getProperties();
            if (properties != null) {
                String recfm = properties.getPropertyValue("Record format");
                this.isUndefinedLengthDataSet = "U".equals(recfm);
            }
        }
    }

    public boolean isMembersSelected() {
        if (this.getValidationErrorMessage() != null) {
            return false;
        }
        return this.model.isUsingRange() || this.model.isUsingCreated() || this.model.isUsingChanged() || this.model.isUsingUserID();
    }

    public ModelViewConnector getConnector() {
        return this.connector;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    public void setCreatedEnabled(boolean enable) {
        this.createdEnabled = enable;
    }

    public void setChangedEnabled(boolean enable) {
        this.changedEnabled = enable;
    }

    public void setUseridEnabled(boolean enable) {
        this.useridEnabled = enable;
    }

    public Combo getwExcludeMembers() {
        return this.wExcludeMembers;
    }

    private class MemberSelectionCriteriaCompositeConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private MemberSelectionCriteriaCompositeConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (MemberSelectionCriteriaComposite.this.wMembersRangeSpecified != null) {
                MemberSelectionCriteriaComposite.this.model.setUsingRange(MemberSelectionCriteriaComposite.this.wMembersRangeSpecified.getSelection());
            }
            if (MemberSelectionCriteriaComposite.this.wMembersRangeStart != null && MemberSelectionCriteriaComposite.this.wMembersRangeEnd != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersRangeStart(MemberSelectionCriteriaComposite.this.wMembersRangeStart.getText());
                if (MemberSelectionCriteriaComposite.this.wMembersRangeEnd.getText().isEmpty()) {
                    MemberSelectionCriteriaComposite.this.model.setMembersRangeEnd(MemberSelectionCriteriaComposite.this.wMembersRangeStart.getText());
                } else {
                    MemberSelectionCriteriaComposite.this.model.setMembersRangeEnd(MemberSelectionCriteriaComposite.this.wMembersRangeEnd.getText());
                }
            }
            if (MemberSelectionCriteriaComposite.this.wMembersCreatedSpecified != null) {
                MemberSelectionCriteriaComposite.this.model.setUsingCreated(MemberSelectionCriteriaComposite.this.wMembersCreatedSpecified.getSelection());
            }
            if (MemberSelectionCriteriaComposite.this.wMembersCreatedStart != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersCreatedStart(GUI.datetime.get((DateTime)MemberSelectionCriteriaComposite.this.wMembersCreatedStart));
            }
            if (MemberSelectionCriteriaComposite.this.wMembersCreatedEnd != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersCreatedEnd(GUI.datetime.get((DateTime)MemberSelectionCriteriaComposite.this.wMembersCreatedEnd));
            }
            if (MemberSelectionCriteriaComposite.this.wMembersChangedSpecified != null) {
                MemberSelectionCriteriaComposite.this.model.setUsingChanged(MemberSelectionCriteriaComposite.this.wMembersChangedSpecified.getSelection());
            }
            if (MemberSelectionCriteriaComposite.this.wMembersChangedStart != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersChangedStart(GUI.datetime.get((DateTime)MemberSelectionCriteriaComposite.this.wMembersChangedStart));
            }
            if (MemberSelectionCriteriaComposite.this.wMembersChangedEnd != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersChangedEnd(GUI.datetime.get((DateTime)MemberSelectionCriteriaComposite.this.wMembersChangedEnd));
            }
            if (MemberSelectionCriteriaComposite.this.wMembersUserIDSpecified != null) {
                MemberSelectionCriteriaComposite.this.model.setUsingUserID(MemberSelectionCriteriaComposite.this.wMembersUserIDSpecified.getSelection());
            }
            if (MemberSelectionCriteriaComposite.this.wMembersUserIDStart != null && MemberSelectionCriteriaComposite.this.wMembersUserIDEnd != null) {
                MemberSelectionCriteriaComposite.this.model.setMembersUserIDStart(MemberSelectionCriteriaComposite.this.wMembersUserIDStart.getText());
                if (MemberSelectionCriteriaComposite.this.wMembersUserIDEnd.getText().isEmpty()) {
                    MemberSelectionCriteriaComposite.this.model.setMembersUserIDEnd(MemberSelectionCriteriaComposite.this.wMembersUserIDStart.getText());
                } else {
                    MemberSelectionCriteriaComposite.this.model.setMembersUserIDEnd(MemberSelectionCriteriaComposite.this.wMembersUserIDEnd.getText());
                }
            }
            MemberSelectionCriteriaComposite.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateButtonSelectionFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersRangeSpecified, MemberSelectionCriteriaComposite.this.model.isUsingRange());
            this.updateComboFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersRangeStart, MemberSelectionCriteriaComposite.this.model.getMembersRangeStartSet());
            if (!MemberSelectionCriteriaComposite.this.model.getMembersRangeStartSet().equals(MemberSelectionCriteriaComposite.this.model.getMembersRangeEndSet())) {
                this.updateComboFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersRangeEnd, MemberSelectionCriteriaComposite.this.model.getMembersRangeEndSet());
            }
            this.updateButtonSelectionFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersCreatedSpecified, MemberSelectionCriteriaComposite.this.model.isUsingCreated());
            if (MemberSelectionCriteriaCompositeConnector.unfocussed((Control)MemberSelectionCriteriaComposite.this.wMembersCreatedStart)) {
                GUI.datetime.set((DateTime)MemberSelectionCriteriaComposite.this.wMembersCreatedStart, (Calendar)MemberSelectionCriteriaComposite.this.model.getMembersCreatedStart());
            }
            if (MemberSelectionCriteriaCompositeConnector.unfocussed((Control)MemberSelectionCriteriaComposite.this.wMembersCreatedEnd)) {
                GUI.datetime.set((DateTime)MemberSelectionCriteriaComposite.this.wMembersCreatedEnd, (Calendar)MemberSelectionCriteriaComposite.this.model.getMembersCreatedEnd());
            }
            this.updateButtonSelectionFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersChangedSpecified, MemberSelectionCriteriaComposite.this.model.isUsingChanged());
            if (MemberSelectionCriteriaCompositeConnector.unfocussed((Control)MemberSelectionCriteriaComposite.this.wMembersChangedStart)) {
                GUI.datetime.set((DateTime)MemberSelectionCriteriaComposite.this.wMembersChangedStart, (Calendar)MemberSelectionCriteriaComposite.this.model.getMembersChangedStart());
            }
            if (MemberSelectionCriteriaCompositeConnector.unfocussed((Control)MemberSelectionCriteriaComposite.this.wMembersChangedEnd)) {
                GUI.datetime.set((DateTime)MemberSelectionCriteriaComposite.this.wMembersChangedEnd, (Calendar)MemberSelectionCriteriaComposite.this.model.getMembersChangedEnd());
            }
            this.updateButtonSelectionFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersUserIDSpecified, MemberSelectionCriteriaComposite.this.model.isUsingUserID());
            this.updateComboFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersUserIDStart, MemberSelectionCriteriaComposite.this.model.getMembersUserIDStartSet());
            if (!MemberSelectionCriteriaComposite.this.model.getMembersUserIDStartSet().equals(MemberSelectionCriteriaComposite.this.model.getMembersUserIDEndSet())) {
                this.updateComboFromModelIfNeeded(MemberSelectionCriteriaComposite.this.wMembersUserIDEnd, MemberSelectionCriteriaComposite.this.model.getMembersUserIDEndSet());
            }
            MemberSelectionCriteriaComposite.this.onViewUpdated();
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersRangeSpecified, (boolean)MemberSelectionCriteriaComposite.this.enabled);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersRangeStart, (boolean)MemberSelectionCriteriaComposite.this.model.isUsingRange());
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersRangeEnd, (boolean)MemberSelectionCriteriaComposite.this.model.isUsingRange());
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersCreatedSpecified, (MemberSelectionCriteriaComposite.this.enabled && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet && MemberSelectionCriteriaComposite.this.createdEnabled ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersCreatedStart, (boolean)MemberSelectionCriteriaComposite.this.model.isUsingCreated());
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersCreatedEnd, (boolean)MemberSelectionCriteriaComposite.this.model.isUsingCreated());
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersChangedSpecified, (MemberSelectionCriteriaComposite.this.enabled && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet && MemberSelectionCriteriaComposite.this.changedEnabled ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersChangedStart, (MemberSelectionCriteriaComposite.this.model.isUsingChanged() && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersChangedEnd, (MemberSelectionCriteriaComposite.this.model.isUsingChanged() && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersUserIDSpecified, (MemberSelectionCriteriaComposite.this.enabled && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet && MemberSelectionCriteriaComposite.this.useridEnabled ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersUserIDStart, (MemberSelectionCriteriaComposite.this.model.isUsingUserID() && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet ? 1 : 0) != 0);
            MemberSelectionCriteriaCompositeConnector.setEnabledIf((Control)MemberSelectionCriteriaComposite.this.wMembersUserIDEnd, (MemberSelectionCriteriaComposite.this.model.isUsingUserID() && !MemberSelectionCriteriaComposite.this.isUndefinedLengthDataSet ? 1 : 0) != 0);
        }
    }
}

