/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.widget;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.widget.LazyContentProposalAdapter;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Db2TableContentProposals
implements IContentProposalProvider {
    protected static final PDLogger logger = PDLogger.get(Db2TableContentProposals.class);
    protected static final long WAIT_BEFORE_LOADING = 1000L;
    protected static final String RCP_ID = Db2TableContentProposals.class.getCanonicalName();
    private Db2SubsystemProvider subSystemProvider;
    private ControlDecoration hint;
    private Db2TableContentProposalAdapter adapter;
    private Control control;
    private Combo secondaryFilterControl;
    private IControlContentAdapter contentAdapter;
    private boolean forcedLoad = false;
    private String loadProposalsFor = null;
    private IContentProposal[] proposals = new IContentProposal[0];
    private LOADTYPE toLoad = null;
    private Job proposalLoader = new Job(Messages.ResourceContentProposals_LOADING_PROPOSALS){

        protected IStatus run(IProgressMonitor monitor) {
            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
            Db2Subsystem subsystem = Db2TableContentProposals.this.subSystemProvider.getSubsystem();
            if (subsystem == null) {
                return new Status(8, "com.ibm.etools.fm.ui", Messages.Db2ResourceContentProposals_CANCELLED_LOADING_PROPOSALS);
            }
            String primaryFilter = Db2TableContentProposals.this.loadProposalsFor;
            String secondaryFilter = null;
            if (Db2TableContentProposals.this.secondaryFilterControl != null) {
                final AtomicReference<Object> secondFilterRef = new AtomicReference<Object>(null);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        secondFilterRef.set((this).Db2TableContentProposals.this.secondaryFilterControl.getText());
                    }
                });
                secondaryFilter = secondFilterRef.get();
            }
            Db2TableContentProposals.this.proposals = new IContentProposal[0];
            try {
                if (Db2TableContentProposals.this.toLoad == LOADTYPE.OWNER) {
                    statement = new Db2SqlQueryBuilder();
                    statement.select(new String[]{"TB.CREATOR", "TB.NAME"}).from(new String[]{"SYSIBM.SYSTABLES TB"});
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("RTRIM(TB.CREATOR) LIKE RTRIM(''{0}'')", Db2SqlQueryBuilder.makeLikePattern((String)primaryFilter, (boolean)true)));
                    if (secondaryFilter != null) {
                        statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("TB.NAME LIKE ''{0}''", Db2SqlQueryBuilder.makeLikePattern((String)secondaryFilter, (boolean)true)));
                    }
                    String cpDescription = MessageFormat.format(Messages.Db2ResourceContentProposals_PROPOSAL_DESC, subsystem.getSystem().getConnectionName(), subsystem.getName(), primaryFilter, secondaryFilter);
                    Db2SqlQuery sqlQuery = new Db2SqlQuery(subsystem, statement.getSql());
                    Result result = sqlQuery.execute(howIsGoing);
                    if (result.getOutput() == null) {
                        logger.error((Object)("null output from db2 content assist: " + String.valueOf(result.getMessagesCombined())));
                        String errorDesc = cpDescription + "\n\n" + String.valueOf(result.getMessagesCombined());
                        String errorLabel = Messages.Db2TableLookupDialog_ERROR_LOADING_OBJECTS;
                        Db2TableContentProposals.this.proposals = new IContentProposal[]{new SimpleContentProposal(primaryFilter, errorLabel, errorDesc)};
                    } else {
                        String owner;
                        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
                        HashSet<String> owners = new HashSet<String>();
                        int i = 1;
                        while (i < sqlResult.getNumRows()) {
                            owner = sqlResult.getString(i, 0);
                            owners.add(owner);
                            ++i;
                        }
                        Db2TableContentProposals.this.proposals = new IContentProposal[owners.size()];
                        i = 0;
                        Iterator iterator = owners.iterator();
                        while (iterator.hasNext()) {
                            String cpContent;
                            String cpLabel = cpContent = (owner = (String)iterator.next());
                            Db2TableContentProposals.this.proposals[i++] = new SimpleContentProposal(cpContent, cpLabel, cpDescription);
                        }
                    }
                } else if (Db2TableContentProposals.this.toLoad == LOADTYPE.NAME) {
                    statement = new Db2SqlQueryBuilder();
                    statement.select(new String[]{"TB.NAME", "TB.CREATOR"}).from(new String[]{"SYSIBM.SYSTABLES TB"});
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("TB.NAME LIKE ''{0}''", Db2SqlQueryBuilder.makeLikePattern((String)primaryFilter, (boolean)true)));
                    if (secondaryFilter != null) {
                        statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("RTRIM(TB.CREATOR) LIKE RTRIM(''{0}'')", Db2SqlQueryBuilder.makeLikePattern((String)secondaryFilter, (boolean)true)));
                    }
                    String cpDescription = MessageFormat.format(Messages.Db2ResourceContentProposals_PROPOSAL_DESC, subsystem.getSystem().getConnectionName(), subsystem.getName(), secondaryFilter, primaryFilter);
                    Db2SqlQuery sqlQuery = new Db2SqlQuery(subsystem, statement.getSql());
                    Result result = sqlQuery.execute(howIsGoing);
                    if (result.getOutput() == null) {
                        logger.error((Object)("null output from db2 content assist: " + String.valueOf(result.getMessagesCombined())));
                        String errorDesc = cpDescription + "\n\n" + String.valueOf(result.getMessagesCombined());
                        String errorLabel = Messages.Db2TableLookupDialog_ERROR_LOADING_OBJECTS;
                        Db2TableContentProposals.this.proposals = new IContentProposal[]{new SimpleContentProposal(primaryFilter, errorLabel, errorDesc)};
                    } else {
                        String name;
                        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
                        HashSet<String> names = new HashSet<String>();
                        int i = 1;
                        while (i < sqlResult.getNumRows()) {
                            name = sqlResult.getString(i, 0);
                            names.add(name);
                            ++i;
                        }
                        Db2TableContentProposals.this.proposals = new IContentProposal[names.size()];
                        i = 0;
                        Iterator iterator = names.iterator();
                        while (iterator.hasNext()) {
                            String cpContent;
                            String cpLabel = cpContent = (name = (String)iterator.next());
                            Db2TableContentProposals.this.proposals[i++] = new SimpleContentProposal(cpContent, cpLabel, cpDescription);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
            Arrays.sort(Db2TableContentProposals.this.proposals, new Comparator<IContentProposal>(){

                @Override
                public int compare(IContentProposal o1, IContentProposal o2) {
                    return o1.getContent().compareTo(o2.getContent());
                }
            });
            if (Db2TableContentProposals.this.forcedLoad || Db2TableContentProposals.this.proposals.length > 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).Db2TableContentProposals.this.adapter.getControl() != null && !(this).Db2TableContentProposals.this.adapter.getControl().isDisposed() && (this).Db2TableContentProposals.this.adapter.getControl().isFocusControl()) {
                            (this).Db2TableContentProposals.this.adapter.openProposalPopup();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };

    public static Db2TableContentProposals getInstance(Control control) {
        Objects.requireNonNull(control, "Must provide a non-null control");
        Object data = control.getData(RCP_ID);
        if (data instanceof Db2TableContentProposals) {
            return (Db2TableContentProposals)data;
        }
        return null;
    }

    public static void addTo(Combo ownerCombo, Combo nameCombo, Db2SubsystemProvider subSysProvider, String id) {
        Objects.requireNonNull(ownerCombo, "Must provide a non-null ownerCombo");
        Db2TableContentProposals ownerRcp = Db2TableContentProposals.addTo(ownerCombo, subSysProvider, id + "Owner", LOADTYPE.OWNER);
        Db2TableContentProposals nameRcp = Db2TableContentProposals.addTo(nameCombo, subSysProvider, id + "Name", LOADTYPE.NAME);
        ownerRcp.setSecondaryFilterControl(nameCombo);
        nameRcp.setSecondaryFilterControl(ownerCombo);
    }

    public static Db2TableContentProposals addTo(Combo combo2, final Db2SubsystemProvider subSysProvider, String id, final LOADTYPE type) {
        Objects.requireNonNull(combo2, "Must provide a non-null combo");
        Objects.requireNonNull(subSysProvider, "Must provide a non-null subSysProvider");
        Objects.requireNonNull(id, "Must provide a non-null id");
        Objects.requireNonNull(type, "Must provide a non-null type");
        Db2TableContentProposals rcp = new Db2TableContentProposals((Control)combo2, (IControlContentAdapter)new ComboContentAdapter(), subSysProvider);
        rcp.setTypeToLoad(type);
        new ComboValueSaver(combo2, id){

            protected boolean shouldSave(String value) {
                if (type == LOADTYPE.NAME) {
                    return Db2Table.isValidName((IPDHost)subSysProvider.getSystem(), (String)value);
                }
                if (type == LOADTYPE.OWNER) {
                    return Db2Table.isValidOwner((IPDHost)subSysProvider.getSystem(), (String)value);
                }
                logger.warn((Object)("Not saving combo value because criteria not known for db2 content assist load type of " + String.valueOf((Object)type)));
                return false;
            }
        };
        return rcp;
    }

    public Db2TableContentProposals(Control control, IControlContentAdapter contentAdaptor, Db2SubsystemProvider subsystemProvider) {
        this.subSystemProvider = Objects.requireNonNull(subsystemProvider);
        this.control = Objects.requireNonNull(control);
        this.contentAdapter = Objects.requireNonNull(contentAdaptor);
        this.hint = new ControlDecoration(control, 16512);
        this.hint.setShowOnlyOnFocus(true);
        this.updateHint();
        this.adapter = new Db2TableContentProposalAdapter();
        this.adapter.setProposalAcceptanceStyle(2);
        control.setData(RCP_ID, (Object)this);
    }

    public void setTypeToLoad(LOADTYPE type) {
        this.toLoad = Objects.requireNonNull(type, "Must provide a non-null type");
        this.updateHint();
    }

    public void setSecondaryFilterControl(Combo secondaryFilterControl) {
        this.secondaryFilterControl = Objects.requireNonNull(secondaryFilterControl, "Must provide a non-null secondaryFilterControl");
    }

    public void setEnabled(boolean isEnabled) {
        this.adapter.setEnabled(isEnabled);
        this.setHintVisible(isEnabled);
    }

    private void setHintVisible(boolean isVisible) {
        if (isVisible) {
            this.hint.show();
        } else {
            this.hint.hide();
        }
    }

    private void updateHint() {
        FieldDecoration cp = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        this.hint.setImage(cp.getImage());
        String typeName = null;
        if (this.toLoad == LOADTYPE.OWNER) {
            typeName = Messages.Db2ResourceContentProposals_TYPE_OWNER;
        } else if (this.toLoad == LOADTYPE.NAME) {
            typeName = Messages.Db2ResourceContentProposals_TYPE_NAME;
        }
        String description = MessageFormat.format(Messages.ResourceContentProposals_HINT_ITEM_SINGLE, typeName);
        this.hint.setDescriptionText(description);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        final String filter = contents.substring(0, position);
        IContentProposal[] array = ArrayUtils.filter((Object[])this.proposals, (ArrayUtils.ArrayTester)new ArrayUtils.ArrayTester<IContentProposal>(){

            protected boolean test(IContentProposal obj) {
                if (obj == null) {
                    return false;
                }
                String lowerCase = filter.toLowerCase();
                return obj.getContent().toLowerCase().startsWith(lowerCase);
            }
        }).toArray(new IContentProposal[0]);
        return array;
    }

    public Control getCombo() {
        return this.control;
    }

    private class Db2TableContentProposalAdapter
    extends LazyContentProposalAdapter {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public Db2TableContentProposalAdapter() {
            super(Db2TableContentProposals.this.control, Db2TableContentProposals.this.contentAdapter, Db2TableContentProposals.this);
            Db2TableContentProposals.this.control.addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    if (!Db2TableContentProposalAdapter.this.isEnabled()) {
                        return;
                    }
                    if (e.keyCode == 32 && (e.stateMask & 0x40000) == 262144) {
                        String controlContents = ((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.contentAdapter.getControlContents(((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.control);
                        Db2TableContentProposalAdapter.this.triggerLoad(true, controlContents, 0);
                        e.doit = false;
                        return;
                    }
                    if (!((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.forcedLoad) {
                        ((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.proposalLoader.cancel();
                    }
                }
            });
            Db2TableContentProposals.this.control.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.proposalLoader != null && ((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.proposalLoader.getState() != 0) {
                        logger.trace((Object)"Focus from assisted field lost, aborting resource proposal loading");
                        ((Db2TableContentProposalAdapter)Db2TableContentProposalAdapter.this).Db2TableContentProposals.this.proposalLoader.cancel();
                    }
                }
            });
        }

        private void triggerLoad(boolean forced, String loadFor, int selOffset) {
            Db2TableContentProposals.this.forcedLoad = forced;
            this.actuallyCloseProposalPopup();
            int selectionIndex = loadFor.length();
            if (Db2TableContentProposals.this.contentAdapter instanceof IControlContentAdapter2) {
                IControlContentAdapter2 selAdapter = (IControlContentAdapter2)Db2TableContentProposals.this.contentAdapter;
                Point selection = selAdapter.getSelection(Db2TableContentProposals.this.control);
                selectionIndex = Math.min(selection.x, selection.y);
            }
            Db2TableContentProposals.this.loadProposalsFor = loadFor.substring(0, selectionIndex + selOffset);
            Db2TableContentProposals.this.proposalLoader.cancel();
            if (!Db2TableContentProposals.this.loadProposalsFor.isEmpty() || forced) {
                Db2TableContentProposals.this.proposalLoader.schedule(forced ? 0L : 1000L);
            }
        }
    }

    public static enum LOADTYPE {
        OWNER,
        NAME;

    }

    private static class SimpleContentProposal
    implements IContentProposal,
    Comparable<SimpleContentProposal> {
        private final String content;
        private final String description;
        private final String label;

        public SimpleContentProposal(String content, String label2, String description) {
            this.content = content;
            this.label = label2;
            this.description = description;
        }

        public String getContent() {
            return this.content;
        }

        public int getCursorPosition() {
            return this.content.length();
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.content;
        }

        @Override
        public int compareTo(SimpleContentProposal o) {
            return this.content.compareTo(o.content);
        }
    }
}

