/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.tree.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.CompareActionItem;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.XMLMementoUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.File;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SaveHostQueriesToFile
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TREE_FILTER_FILE_EXTENSION = "xml";
    public static final String DEFAULT_TREE_FILTER_DIR_NAME = "tree";
    public static final String XML_ROOT_ELEMENT = "PDSystemsView";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        SystemsTreeNode firstSelectedTreeNode = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
        if (firstSelectedTreeNode instanceof HostNode) {
            SaveHostQueriesToFile.exportAllQueries((IPDHost)((HostNode)firstSelectedTreeNode).getDataObject());
        }
    }

    public static void exportAllQueries(IPDHost host) {
        String chosenFile;
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_ROOT_ELEMENT);
        FMTreeContentHolder.getInstance().saveHostDetailsToMemento(host, (IMemento)memento);
        if (IResourceUtils.createFolderIfNotExist((IFolder)SaveHostQueriesToFile.getDefaultSaveDir(DEFAULT_TREE_FILTER_DIR_NAME)) && (chosenFile = PDDialogs.openFileDialogForSave((String)SaveHostQueriesToFile.getDefaultSaveDir(DEFAULT_TREE_FILTER_DIR_NAME).getRawLocation().toString(), (String[])new String[]{"*.xml"}, (String)MessageFormat.format("{0}.{1}.{2}.{3}", host.getHostName(), host.getPort(), host.getCodePage(), TREE_FILTER_FILE_EXTENSION))) != null) {
            File file = new File(chosenFile);
            if (!file.exists()) {
                XMLMementoUtils.sameMementoToFileShowErrors((XMLMemento)memento, (File)file);
            } else if (PDDialogs.openConfirm((String)Messages.SaveHostQueriesToFile_0, (String)MessageFormat.format(Messages.SaveHostQueriesToFile_1, file))) {
                XMLMementoUtils.sameMementoToFileShowErrors((XMLMemento)memento, (File)file);
            }
        }
    }

    public static IFolder getDefaultSaveDir(String dir) {
        return IResourceUtils.getFolder((IProject)PDTCCcore.getConfigProject(), (String)dir);
    }

    public static void exportAllQueries(IPDHost host, Object model) throws InterruptedException {
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_ROOT_ELEMENT);
        if (model != null) {
            if (model instanceof CompareModel) {
                CompareActionItem action = new CompareActionItem((CompareModel)((Object)model));
                FMTreeContentHolder.getInstance().saveIActionItemToMemento(host, (IMemento)memento, action);
            }
        } else {
            FMTreeContentHolder.getInstance().saveHostDetailsToMemento(host, (IMemento)memento);
        }
        IProject configProject = PDFileSystemUtil.getConfigProject((String)"FM", (boolean)true);
        String folderName = Objects.requireNonNull(host.getConnectionName(), "Must provide a non-null system connection name.").toUpperCase();
        IFolder folder = IResourceUtils.mkdirs((IProject)configProject, (String)folderName, (IProgressMonitor)new NullProgressMonitor());
        String fileName = MessageFormat.format("{0}@{1}.{2}.{3}", host.getLogin(false).getUsername().toLowerCase(), folderName, host.getCodePage(), TREE_FILTER_FILE_EXTENSION);
        if (folder != null && fileName != null) {
            File file = folder.getFile(fileName).getRawLocation().makeAbsolute().toFile();
            XMLMementoUtils.sameMementoToFileShowErrors((XMLMemento)memento, (File)file);
        }
    }
}

