/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.tree.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.tree.action.SaveHostQueriesToFile;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.XMLMementoUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.File;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class LoadHostQueriesFromFile
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static File fromCacheFile = null;

    protected void handle(ExecutionEvent event) throws ExecutionException {
        SystemsTreeNode firstSelectedTreeNode = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
        if (firstSelectedTreeNode instanceof HostNode) {
            LoadHostQueriesFromFile.importAllQueries((IPDHost)((HostNode)firstSelectedTreeNode).getDataObject());
        }
    }

    public static void importAllQueries(IPDHost host) {
        String chosenFile;
        IFolder folder = SaveHostQueriesToFile.getDefaultSaveDir("tree");
        if (IResourceUtils.createFolderIfNotExist((IFolder)folder) && (chosenFile = PDDialogs.openFileDialogForOpen((String)SaveHostQueriesToFile.getDefaultSaveDir("tree").getRawLocation().toString(), (String[])new String[]{"*.xml"}, (String)MessageFormat.format("{0}.{1}.{2}.{3}", host.getHostName(), host.getPort(), host.getCodePage(), "xml"))) != null) {
            File file = new File(chosenFile);
            if (file.exists()) {
                XMLMemento memento = XMLMementoUtils.loadMementoFromFileShowErrors((File)file);
                if (memento != null) {
                    FMTreeContentHolder.getInstance().loadHostQueries(host, (IMemento)memento);
                }
            } else {
                PDDialogs.openErrorThreadSafe((String)Messages.LoadHostQueriesFromFile_0);
            }
        }
    }

    public static File getCacheFile(IPDHost host) throws InterruptedException {
        String folderName = Objects.requireNonNull(host.getConnectionName(), "Must provide a non-null system connection name.").toUpperCase();
        IFolder folder = IResourceUtils.getFolder((IProject)PDFileSystemUtil.getConfigProject((String)"FM", (boolean)true), (String)folderName);
        if (IResourceUtils.createFolderIfNotExist((IFolder)folder) && host.getLogin(false) != null) {
            File file;
            String fileName = MessageFormat.format("{0}@{1}.{2}.{3}", host.getLogin(false).getUsername().toLowerCase(), folderName, host.getCodePage(), "xml");
            if (folder != null && fileName != null && (file = folder.getFile(fileName).getRawLocation().makeAbsolute().toFile()).exists()) {
                return file;
            }
        }
        return null;
    }

    public static IActionItem getActionItem(IPDHost host, File file) {
        XMLMemento memento = XMLMementoUtils.loadMementoFromFileShowErrors((File)file);
        if (memento != null) {
            return FMTreeContentHolder.getInstance().loadCompareFromSetting(host, (IMemento)memento);
        }
        return null;
    }
}

