/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UssFileQueryPropertySource
implements IPropertySource2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(UssFileQueryPropertySource.class);
    private static final Object KEY_QUERY = new Object();
    private static final Object KEY_NUMBER_OF_FILES = new Object();
    private static final Object KEY_TYPE_FILTER = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NUMBER_OF_FILES, Messages.UssFileQueryNode_NUMBER_FILES), new TextPropertyDescriptor(KEY_TYPE_FILTER, Messages.UssFileQueryNode_FILTERED_FILE_TYPES), new TextPropertyDescriptor(KEY_QUERY, Messages.UssFileQueryNode_QUERY)};
    private UssFileQuery query;

    public UssFileQueryPropertySource(UssFileQuery query) {
        if (query == null) {
            String error = "Must pass in non-null UssFileQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.query = query;
    }

    public Object getEditableValue() {
        return this.query;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(KEY_QUERY)) {
            return this.query.getQuery();
        }
        if (id.equals(KEY_NUMBER_OF_FILES)) {
            List files = this.query.getFiles();
            if (files == null) {
                return Messages.UssFileQueryNode_UNKNOWN;
            }
            return files.size();
        }
        if (id.equals(KEY_TYPE_FILTER)) {
            List typesFiltered = this.query.getTypesFiltered();
            if (typesFiltered.size() == UssFileType.STANDARD_VALUES.size()) {
                return "";
            }
            return ArrayUtils.join((Object[])typesFiltered.toArray(), (String)", ").toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (id.equals(KEY_QUERY)) {
            return true;
        }
        return id.equals(KEY_TYPE_FILTER) && this.query.getTypesFiltered().size() > 0;
    }

    public void resetPropertyValue(Object id) {
        if (id.equals(KEY_TYPE_FILTER)) {
            this.query.setTypesFiltered(new ArrayList());
        }
    }

    public void setPropertyValue(Object id, Object value) {
        UssFileQuery newQuery = this.query.clone();
        if (value instanceof String) {
            String stringValue = (String)value;
            if (id.equals(KEY_QUERY)) {
                if (UssFileQuery.isValidQuery((IPDHost)newQuery.getSystem(), (String)stringValue)) {
                    newQuery.setQuery(stringValue);
                }
            } else if (id.equals(KEY_TYPE_FILTER)) {
                ArrayList<UssFileType> filters = new ArrayList<UssFileType>();
                if (stringValue.isEmpty()) {
                    filters.addAll(UssFileType.STANDARD_VALUES);
                } else {
                    String[] strings = stringValue.split(",");
                    if (strings.length > 0) {
                        String[] stringArray = strings;
                        int n = strings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            try {
                                filters.add(UssFileType.parse((String)str.trim()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n2;
                        }
                    }
                }
                newQuery.setTypesFiltered(filters);
            }
        }
        if (!newQuery.equals((Object)this.query)) {
            EntityRegistry<UssFileQuery> registry = FMTreeContentHolder.getInstance().getUssContent().getQueryRegistry();
            registry.remove((Object)this.query);
            registry.findOrAdd((Object)newQuery);
        }
    }

    public boolean isPropertyResettable(Object id) {
        if (id.equals(KEY_QUERY)) {
            return false;
        }
        return this.isPropertySet(id);
    }
}

