/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.data.UssFileProperties;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class UssFilePropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(UssFilePropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_PATH = new Object();
    private static final Object KEY_TYPE = new Object();
    private static final PropertyDescriptor PROPERTY_NAME = new PropertyDescriptor(KEY_NAME, Messages.USSNode_NAME);
    private static final PropertyDescriptor PROPERTY_PATH = new PropertyDescriptor(KEY_PATH, Messages.USSNode_PATH);
    private static final PropertyDescriptor PROPERTY_TYPE = new PropertyDescriptor(KEY_TYPE, Messages.USSNode_TYPE);
    private static final int EXTRA_PROPERTIES = 3;
    private UssFile file;

    public UssFilePropertySource(UssFile file) {
        if (file == null) {
            String error = "Must pass in non-null UssFile";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.file = file;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        UssFileProperties properties = this.file.getProperties();
        if (properties == null) {
            return new IPropertyDescriptor[0];
        }
        Set keys = properties.getPropertyKeys();
        IPropertyDescriptor[] propDescs = new IPropertyDescriptor[keys.size() + 3];
        propDescs[0] = PROPERTY_NAME;
        propDescs[1] = PROPERTY_PATH;
        propDescs[2] = PROPERTY_TYPE;
        int i = 3;
        for (String key : keys) {
            String displayName = properties.getPropertyName(key);
            if (displayName == null) {
                logger.debug((Object)("Property does not have a localised name, key=" + key));
                displayName = key;
            }
            propDescs[i++] = new PropertyDescriptor((Object)key, displayName);
        }
        return propDescs;
    }

    public Object getPropertyValue(Object id) {
        if (KEY_NAME.equals(id)) {
            return this.file.getName();
        }
        if (KEY_PATH.equals(id)) {
            return this.file.getFormattedName();
        }
        if (KEY_TYPE.equals(id)) {
            return this.file.getType().getName();
        }
        return this.file.getProperties().getPropertyValue((String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

