/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TemplatesPropertySection
extends AbstractPropertySection {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplatesPropertySection.class);
    private TableViewer viewer;
    private TemplatePropertySectionTableLabelProvider labelProvider = new TemplatePropertySectionTableLabelProvider((ILabelProvider)new SystemsLabelProvider(), (ILabelDecorator)new SystemsLabelDecorator());
    private TabbedPropertySheetPage propertySheetPage;
    private ControlAdapter pageResizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Table table = TemplatesPropertySection.this.viewer.getTable();
            ScrolledComposite scroller = TemplatesPropertySection.getScrolledCompositeParent((Control)table);
            if (scroller != null) {
                TemplatesPropertySection.this.updateTableSize(table, scroller);
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.propertySheetPage = tabbedPropertySheetPage;
        parent.setLayout((Layout)GUI.grid.l.noMargins((int)1, (boolean)true));
        final Table table = new Table(parent, 66304);
        table.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        table.setHeaderVisible(true);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_2);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_3);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_4);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_5);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_6);
        new TableColumn(table, 0).setText(Messages.TemplatesPropertySection_7);
        this.viewer = new TableViewer(table);
        final TemplatePropertySectionTableContentProvider contentProvider = new TemplatePropertySectionTableContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TableColumn sortColumn = table.getSortColumn();
                int index = Arrays.asList(table.getColumns()).indexOf(sortColumn);
                int result = 0;
                if (index != -1) {
                    String e2Text;
                    String e1Text = TemplatesPropertySection.this.labelProvider.getColumnText(e1, index);
                    if (e1Text == null) {
                        e1Text = "";
                    }
                    if ((e2Text = TemplatesPropertySection.this.labelProvider.getColumnText(e2, index)) == null) {
                        e2Text = "";
                    }
                    result = index == 0 ? new ByteStringComparator(contentProvider.getCurrentDataSet().getSystem().getHostType()).compare(e1Text, e2Text) : String.CASE_INSENSITIVE_ORDER.compare(e1Text, e2Text);
                }
                return table.getSortDirection() == 128 ? result : -result;
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleclickevent) {
                IStructuredSelection sel = (IStructuredSelection)doubleclickevent.getSelection();
                OpenTemplate.openTemplate((Member)sel.getFirstElement());
            }
        });
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableColumn tc = tableColumnArray[n2];
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tc.equals(table.getSortColumn())) {
                        table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
                    } else {
                        table.setSortColumn(tc);
                        table.setSortDirection(128);
                    }
                    TemplatesPropertySection.this.viewer.refresh();
                }
            });
            ++n2;
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (part instanceof PDSystemsView) {
            if (selection instanceof ITreeSelection) {
                Object firstSelected = ((ITreeSelection)selection).getFirstElement();
                if (firstSelected instanceof DataSetNode) {
                    DataSetNode dsNode = (DataSetNode)((Object)firstSelected);
                    this.viewer.setInput(dsNode.getDataObject());
                    if (((DataSet)dsNode.getDataObject()).getMembers() == null) {
                        dsNode.refreshSelf();
                    }
                } else {
                    logger.warn((Object)("Unexpected type of first element in selection, first element=" + String.valueOf(firstSelected)));
                    this.viewer.setInput(null);
                }
            } else {
                logger.warn((Object)("Unexpected type of selection; selection=" + String.valueOf(selection)));
                this.viewer.setInput(null);
            }
        }
        super.setInput(part, selection);
    }

    public void refresh() {
        this.viewer.refresh();
        Table table = this.viewer.getTable();
        ScrolledComposite scroller = TemplatesPropertySection.getScrolledCompositeParent((Control)table);
        if (scroller != null) {
            scroller.addControlListener((ControlListener)this.pageResizeListener);
            this.updateTableSize(table, scroller);
            TemplatesPropertySection.updateColumnSize(table);
        }
        super.refresh();
    }

    private void updateTableSize(Table table, ScrolledComposite scroller) {
        scroller.setRedraw(false);
        scroller.setAlwaysShowScrollBars(true);
        this.propertySheetPage.resizeScrolledComposite();
        Rectangle scrollableArea = scroller.getClientArea();
        GridData data = (GridData)table.getLayoutData();
        data.widthHint = scrollableArea.width;
        ScrollBar vertScrollBar = scroller.getVerticalBar();
        if (vertScrollBar != null) {
            data.widthHint -= vertScrollBar.getSize().x;
        }
        data.heightHint = scrollableArea.height;
        ScrollBar horizScrollBar = scroller.getHorizontalBar();
        if (horizScrollBar != null) {
            data.heightHint -= horizScrollBar.getSize().y;
        }
        scroller.setAlwaysShowScrollBars(false);
        this.propertySheetPage.resizeScrolledComposite();
        scroller.setRedraw(true);
    }

    private static void updateColumnSize(Table table) {
        table.setRedraw(false);
        TableColumn[] columns = table.getColumns();
        int usedWidth = 0;
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = columns[i];
            tc.pack();
            int width = Math.max((int)(1.3f * (float)tc.getWidth()), 100);
            tc.setWidth(width);
            usedWidth += width;
            ++i;
        }
        int availableWidth = table.getSize().x;
        if (columns.length > 0 && columns[columns.length - 1].getWidth() < availableWidth - usedWidth) {
            columns[columns.length - 1].setWidth(availableWidth - usedWidth);
        }
        table.setRedraw(true);
    }

    private static ScrolledComposite getScrolledCompositeParent(Control control) {
        while (!control.isDisposed() && control.getParent() != null) {
            if (control instanceof ScrolledComposite) {
                return (ScrolledComposite)control;
            }
            control = control.getParent();
        }
        return null;
    }

    public void aboutToBeHidden() {
        ScrolledComposite scroller = TemplatesPropertySection.getScrolledCompositeParent((Control)this.viewer.getTable());
        if (scroller != null) {
            scroller.removeControlListener((ControlListener)this.pageResizeListener);
        }
        super.aboutToBeHidden();
    }

    public void dispose() {
        this.labelProvider.dispose();
        super.dispose();
    }

    private static class TemplatePropertySectionTableContentProvider
    implements IStructuredContentProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private DataSet dataSet;

        private TemplatePropertySectionTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (!(newInput instanceof DataSet) && newInput != null) {
                throw new IllegalArgumentException(newInput.toString());
            }
            this.dataSet = (DataSet)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.dataSet == null || this.dataSet.getMembers() == null) {
                return new Object[0];
            }
            ArrayList<Member> templates = new ArrayList<Member>();
            for (Member member : this.dataSet.getMembers()) {
                if (member.getTemplateInfo() == null || member.getTemplateInfo().getType() == null) continue;
                templates.add(member);
            }
            return templates.toArray();
        }

        public DataSet getCurrentDataSet() {
            return this.dataSet;
        }

        public void dispose() {
        }
    }

    private static class TemplatePropertySectionTableLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public TemplatePropertySectionTableLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof Member)) {
                throw new IllegalArgumentException(element == null ? "null" : element.toString());
            }
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof Member)) {
                throw new IllegalArgumentException(element == null ? "null" : element.toString());
            }
            Member member = (Member)element;
            if (columnIndex == 0) {
                return member.getName();
            }
            if (member.getTemplateInfo() != null && member.getTemplateInfo().getType() != null) {
                if (columnIndex == 1) {
                    return member.getTemplateInfo().getType().getLocalizedName();
                }
                if (columnIndex == 2) {
                    return member.getTemplateInfo().getDb2Ssid();
                }
                if (columnIndex == 3) {
                    return member.getTemplateInfo().getDb2Owner();
                }
                if (columnIndex == 4) {
                    return member.getTemplateInfo().getDb2Object();
                }
                if (columnIndex == 5) {
                    return member.getTemplateInfo().getDescription();
                }
            }
            return null;
        }
    }
}

