/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class MessageQueueQueryPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MessageQueueQueryPropertySource.class);
    private static final Object KEY_MANAGER = new Object();
    private static final Object KEY_QUERY = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new TextPropertyDescriptor(KEY_MANAGER, Messages.MessageQueueQueryNode_MANAGER), new TextPropertyDescriptor(KEY_QUERY, Messages.MessageQueueQueryNode_QUERY)};
    private MessageQueueQuery mqQuery;

    public MessageQueueQueryPropertySource(MessageQueueQuery mqQuery) {
        if (mqQuery == null) {
            String error = "Must pass in non-null MessageQueueQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.mqQuery = mqQuery;
    }

    public Object getEditableValue() {
        return this.mqQuery;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (KEY_MANAGER.equals(id)) {
            return this.mqQuery.getMQManager().getName();
        }
        if (KEY_QUERY.equals(id)) {
            return this.mqQuery.getQuery();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
        if (KEY_QUERY.equals(id)) {
            this.mqQuery.setQuery("");
        }
    }

    public String toString() {
        return this.mqQuery.getMQManager().getName();
    }

    public void setPropertyValue(Object id, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            MessageQueueQuery newQuery = this.mqQuery.clone();
            boolean doChange = false;
            if (KEY_QUERY.equals(id) && !this.mqQuery.getQuery().equals(strValue)) {
                if (strValue.isEmpty() || MessageQueueQuery.isValidQuery((IPDHost)this.mqQuery.getSystem(), (String)strValue)) {
                    newQuery.setQuery(strValue);
                    doChange = true;
                }
            } else if (KEY_MANAGER.equals(id) && !this.mqQuery.getMQManager().getName().equals(strValue) && MessageQueueManager.isValidName((IPDHost)this.mqQuery.getSystem(), (String)strValue)) {
                MessageQueueManager newManager = MessageQueueManager.create((IPDHost)this.mqQuery.getSystem(), (String)strValue);
                newQuery = MessageQueueQuery.create((MessageQueueManager)newManager, (String)this.mqQuery.getQuery());
                doChange = true;
            }
            if (doChange) {
                EntityRegistry<MessageQueueQuery> registry = FMTreeContentHolder.getInstance().getMqContent().getQueryRegistry();
                registry.remove((Object)this.mqQuery);
                registry.findOrAdd((Object)newQuery);
            }
        }
    }
}

