/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.data.MessageQueueProperties;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MessageQueuePropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MessageQueuePropertySource.class);
    private MessageQueue mq;

    public MessageQueuePropertySource(MessageQueue mq) {
        if (mq == null) {
            String error = "Must pass in non-null MessageQueue";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.mq = mq;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        MessageQueueProperties props = this.mq.getProperties();
        if (props == null) {
            return null;
        }
        Set propertyKeys = props.getPropertyKeys();
        IPropertyDescriptor[] descs = new IPropertyDescriptor[propertyKeys.size()];
        int i = 0;
        for (String key : propertyKeys) {
            descs[i++] = new PropertyDescriptor((Object)key, key);
        }
        return descs;
    }

    public Object getPropertyValue(Object id) {
        String translated;
        MessageQueueProperties props = this.mq.getProperties();
        if (props == null) {
            return null;
        }
        String propertyValue = props.getPropertyValue(id.toString());
        if (id.toString().equalsIgnoreCase("DESCR") && (translated = this.mq.getSystem().translate(propertyValue)) != null) {
            return translated;
        }
        return propertyValue;
    }

    public String toString() {
        return this.mq.getName();
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

