/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MemberPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MemberPropertySource.class);
    private static final Object KEY_DATA_SET_NAME = new Object();
    private static final Object KEY_MEMBER_NAME = new Object();
    private static final Object KEY_MEMBER_NAME_HEX = new Object();
    private static final Object KEY_ALIAS_HEX = new Object();
    private static final Object KEY_TEMPLATE_TYPE = new Object();
    private static final Object KEY_TEMPLATE_DB2_OWNER = new Object();
    private static final Object KEY_TEMPLATE_DB2_NAME = new Object();
    private static final Object KEY_TEMPLATE_DB2_SSID = new Object();
    private static final Object LOCK_FLAG = new Object();
    private static final Object LEADING_ZERO = new Object();
    private static final IPropertyDescriptor[] EXTRA_PROPERTIES = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_DATA_SET_NAME, Messages.MemberNode_DATA_SET_NAME), new PropertyDescriptor(KEY_MEMBER_NAME, Messages.MemberNode_MEMBER_NAME), new PropertyDescriptor(KEY_MEMBER_NAME_HEX, Messages.MemberNode_MEMBER_NAME_HEX)};
    private static final IPropertyDescriptor PROPERTY_ALIAS_HEX = new PropertyDescriptor(KEY_ALIAS_HEX, Messages.MemberNode_ALIAS_HEX);
    private static final IPropertyDescriptor PROPERTY_TEMPLATE_TYPE = new PropertyDescriptor(KEY_TEMPLATE_TYPE, Messages.MemberNode_TEMPL_TYPE);
    private static final IPropertyDescriptor PROPERTY_TEMPLATE_DB2_OWNER = new PropertyDescriptor(KEY_TEMPLATE_DB2_OWNER, Messages.MemberNode_TEMPL_DB2_OWNER);
    private static final IPropertyDescriptor PROPERTY_TEMPLATE_DB2_NAME = new PropertyDescriptor(KEY_TEMPLATE_DB2_NAME, Messages.MemberNode_TEMPL_DB2_NAME);
    private static final IPropertyDescriptor PROPERTY_TEMPLATE_DB2_SSID = new PropertyDescriptor(KEY_TEMPLATE_DB2_SSID, Messages.MemberNode_TEMPL_DB2_SSID);
    private static final IPropertyDescriptor PROPERTY_LOCK_FLAG = new PropertyDescriptor(LOCK_FLAG, Messages.MSG_Template_LOCKED_PROP);
    private static final IPropertyDescriptor PROPERTY_LEADING_ZERO_FLAG = new PropertyDescriptor(LEADING_ZERO, Messages.MSG_Template_LEADINGZERO_PROP);
    private Member member;

    public MemberPropertySource(Member member) {
        if (member == null) {
            String error = "Must pass in non-null Member";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.member = member;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ImmutableProperties properties = this.member.getProperties();
        if (properties == null) {
            return new IPropertyDescriptor[0];
        }
        Set keys = properties.getPropertyKeys();
        ArrayList<Object> propDescs = new ArrayList<Object>(keys.size() + EXTRA_PROPERTIES.length);
        propDescs.addAll(Arrays.asList(EXTRA_PROPERTIES));
        for (String key : keys) {
            String displayName = properties.getPropertyName(key);
            if (displayName == null) {
                logger.debug((Object)("Property does not have a localised name, key=" + key));
                displayName = key;
            }
            propDescs.add(new PropertyDescriptor((Object)key, displayName));
            if (!"AliasX".equals(key)) continue;
            propDescs.add(PROPERTY_ALIAS_HEX);
        }
        if (this.member.getTemplateInfo() != null) {
            boolean showProps;
            if (this.member.getTemplateInfo().getType() != null) {
                propDescs.add(PROPERTY_TEMPLATE_TYPE);
            }
            if (this.member.getTemplateInfo().getType() == Member.TemplateInfo.DsfmTemplateType.DB2) {
                propDescs.add(PROPERTY_TEMPLATE_DB2_OWNER);
                propDescs.add(PROPERTY_TEMPLATE_DB2_NAME);
                propDescs.add(PROPERTY_TEMPLATE_DB2_SSID);
            }
            if (showProps = this.checkHostVerAndShowProps()) {
                propDescs.add(PROPERTY_LOCK_FLAG);
                propDescs.add(PROPERTY_LEADING_ZERO_FLAG);
            }
        }
        return propDescs.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (KEY_DATA_SET_NAME.equals(id)) {
            return this.member.asDataSet().getName();
        }
        if (KEY_MEMBER_NAME.equals(id)) {
            return this.member.getName();
        }
        if (KEY_MEMBER_NAME_HEX.equals(id)) {
            if (this.member.getSystem().getHostType().getCommunicationEncoding() != this.member.getSystem().getCodePage()) {
                return StringUtils.convertToHex((String)this.member.getName(), (String)this.member.getSystem().getCodePage());
            }
            return StringUtils.convertToHex((String)this.member.getName(), (String)this.member.getSystem().getHostType().getCommunicationEncoding());
        }
        if (KEY_ALIAS_HEX.equals(id)) {
            String alias = this.member.getProperties().getPropertyValue("AliasX");
            return StringUtils.convertToHex((String)alias, (String)this.member.getSystem().getHostType().getCommunicationEncoding());
        }
        if (KEY_TEMPLATE_TYPE.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return null;
            }
            if (templateInfo.getType() == null) {
                return Messages.MemberNode_UNKNOWN;
            }
            return templateInfo.getType().getLocalizedName();
        }
        if (KEY_TEMPLATE_DB2_OWNER.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return null;
            }
            return templateInfo.getDb2Owner();
        }
        if (KEY_TEMPLATE_DB2_NAME.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return null;
            }
            return templateInfo.getDb2Object();
        }
        if (KEY_TEMPLATE_DB2_SSID.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return null;
            }
            return templateInfo.getDb2Ssid();
        }
        if (LOCK_FLAG.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return "NO";
            }
            String lockStatus = templateInfo.isLocked() ? "YES" : "NO";
            return lockStatus;
        }
        if (LEADING_ZERO.equals(id)) {
            Member.TemplateInfo templateInfo = this.member.getTemplateInfo();
            if (templateInfo == null) {
                return "NO";
            }
            String lockStatus = templateInfo.isLeadingZero() ? "YES" : "NO";
            return lockStatus;
        }
        return this.member.getProperties().getPropertyValue((String)id);
    }

    public boolean checkHostVerAndShowProps() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object selected = structuredSelection.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            boolean isConnected = MemberPropertySource.isConnectedToHost(host);
            if (!isConnected) {
                return false;
            }
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (hostVersion >= 140114) {
                return true;
            }
        }
        return false;
    }

    private static boolean isConnectedToHost(IPDHost host) {
        FMHostVersion hostVer = FMHost.getSystem((IPDHost)host).getServerVersion();
        return hostVer != null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

