/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ImsSubsystemConfigPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ImsSubsystemConfigPropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_DESCRIPTION = new Object();
    private static final Object KEY_CUSTOM = new Object();
    private static final Object KEY_CONNECTABLE = new Object();
    private static final Object KEY_BMP_SUPPORTED = new Object();
    private static final Object KEY_DLI_SUPPORTED = new Object();
    private static final Object KEY_STATIC_PCB_BMP_SUPPORTED = new Object();
    private static final Object KEY_STATIC_PCB_DLI_SUPPORTED = new Object();
    private static final Object KEY_DYNAMIC_PCB_BMP_SUPPORTED = new Object();
    private static final Object KEY_DYNAMIC_PCB_DLI_SUPPORTED = new Object();
    private static final Object KEY_DYNALLOC = new Object();
    private static final IPropertyDescriptor[] PROPERTIES = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NAME, Messages.ImsSubsystemConfigPropertySource_PROPERTY_NAME), new PropertyDescriptor(KEY_DESCRIPTION, Messages.ImsSubsystemConfigPropertySource_PROPERTY_DESCRIPTION), new PropertyDescriptor(KEY_CUSTOM, Messages.ImsSubsystemConfigPropertySource_PROPERTY_CUSTOMIZED), new PropertyDescriptor(KEY_CONNECTABLE, Messages.ImsSubsystemConfigPropertySource_PROPERTY_CONNECTABLE), new PropertyDescriptor(KEY_BMP_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_BMPACCESS_ALLOWED), new PropertyDescriptor(KEY_DLI_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_DLI_ACCESS_ALLOWED), new PropertyDescriptor(KEY_STATIC_PCB_BMP_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_STATIC_PCB_ALLOWED_BMP), new PropertyDescriptor(KEY_STATIC_PCB_DLI_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_STATIC_PCB_ALLOWED_DLI), new PropertyDescriptor(KEY_DYNAMIC_PCB_BMP_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_DYNAMIC_PCB_ALLOWED_BMP), new PropertyDescriptor(KEY_DYNAMIC_PCB_DLI_SUPPORTED, Messages.ImsSubsystemConfigPropertySource_PROPERTY_DYNAMIC_PCB_ALLOWED_DLI), new PropertyDescriptor(KEY_DYNALLOC, Messages.ImsSubsystemConfigPropertySource_PROPERTY_DYNALLOC)};
    private final ImsSubsystemConfig config;

    public ImsSubsystemConfigPropertySource(ImsSubsystemConfig config) {
        if (config == null) {
            String error = "Must pass in non-null ImsSubsystemConfig";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.config = config;
    }

    public Object getEditableValue() {
        return null;
    }

    public synchronized IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(PROPERTIES, PROPERTIES.length);
    }

    public synchronized Object getPropertyValue(Object id) {
        String yes = Messages.ResourceContentProposals_YES;
        String no = Messages.ResourceContentProposals_NO;
        if (KEY_NAME.equals(id)) {
            return this.config.getSubsystem().getSubsystemID();
        }
        if (KEY_DESCRIPTION.equals(id)) {
            return this.config.getDescription();
        }
        if (KEY_CUSTOM.equals(id)) {
            return this.config.isCustom() ? yes : no;
        }
        if (KEY_CONNECTABLE.equals(id)) {
            return this.config.isConnectable() ? yes : no;
        }
        if (KEY_BMP_SUPPORTED.equals(id)) {
            return this.config.isBmpSupported() ? yes : no;
        }
        if (KEY_DLI_SUPPORTED.equals(id)) {
            return this.config.isDliSupported() ? yes : no;
        }
        if (KEY_STATIC_PCB_BMP_SUPPORTED.equals(id)) {
            return this.config.isStaticAccessSupported(ImsRegionType.BMP) ? yes : no;
        }
        if (KEY_STATIC_PCB_DLI_SUPPORTED.equals(id)) {
            return this.config.isStaticAccessSupported(ImsRegionType.DLI) ? yes : no;
        }
        if (KEY_DYNAMIC_PCB_BMP_SUPPORTED.equals(id)) {
            return this.config.isDynamicAccessSupported(ImsRegionType.BMP) ? yes : no;
        }
        if (KEY_DYNAMIC_PCB_DLI_SUPPORTED.equals(id)) {
            return this.config.isDynamicAccessSupported(ImsRegionType.DLI) ? yes : no;
        }
        if (KEY_DYNALLOC.equals(id)) {
            return this.config.isDynalloc() ? yes : no;
        }
        return null;
    }

    public String toString() {
        if (this.config != null && this.config.getSubsystem() != null) {
            return this.config.getSubsystem().getSubsystemID();
        }
        return super.toString();
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

