/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ImsPsbPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ImsPsbPropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_SUBSYSTEM = new Object();
    private static final PropertyDescriptor PROPERTY_NAME = new PropertyDescriptor(KEY_NAME, Messages.ImsPsbPropertySource_Name);
    private static final PropertyDescriptor PROPERTY_SUBSYSTEM = new PropertyDescriptor(KEY_SUBSYSTEM, Messages.ImsPsbPropertySource_Subsystem);
    private static final IPropertyDescriptor[] PROPERTIES = new IPropertyDescriptor[]{PROPERTY_NAME, PROPERTY_SUBSYSTEM};
    private final ImsPsb psb;

    public ImsPsbPropertySource(ImsPsb psb) {
        if (psb == null) {
            String error = "Must pass in non-null ImsPsb";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.psb = psb;
    }

    public Object getEditableValue() {
        return null;
    }

    public String toString() {
        return this.psb.getName();
    }

    public synchronized IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(PROPERTIES, PROPERTIES.length);
    }

    public synchronized Object getPropertyValue(Object id) {
        if (KEY_NAME.equals(id)) {
            return this.psb.getName();
        }
        if (KEY_SUBSYSTEM.equals(id)) {
            return this.psb.getSubsystem().getSubsystemID();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

