/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Db2ObjectQueryPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2ObjectQueryPropertySource.class);
    private static final Object KEY_SUBSYSTEM = new Object();
    private static final Object KEY_TYPE = new Object();
    private static final Object KEY_OWNER = new Object();
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_DATABASE = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new TextPropertyDescriptor(KEY_SUBSYSTEM, Messages.Db2ObjectQueryNode_SUBSYSTEM), new TextPropertyDescriptor(KEY_TYPE, Messages.Db2ObjectQueryNode_TYPE), new TextPropertyDescriptor(KEY_OWNER, Messages.Db2ObjectQueryNode_OWNER), new TextPropertyDescriptor(KEY_NAME, Messages.Db2ObjectQueryNode_NAME), new TextPropertyDescriptor(KEY_DATABASE, Messages.Db2ObjectQueryNode_DATABASE)};
    private Db2ObjectQuery<?> query;

    public Db2ObjectQueryPropertySource(Db2ObjectQuery<?> query) {
        if (query == null) {
            String error = "Must pass in non-null Db2ObjectQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.query = query;
    }

    public Object getEditableValue() {
        return this.query;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (KEY_SUBSYSTEM.equals(id)) {
            return this.query.getSubsystem().getName();
        }
        if (KEY_TYPE.equals(id)) {
            Class type = this.query.getType();
            if (Db2Database.class.equals((Object)type)) {
                return Messages.Db2ObjectQueryNode_TYPE_DATABASE;
            }
            if (Db2Table.class.equals((Object)type)) {
                return Messages.Db2ObjectQueryNode_TYPE_TABLE;
            }
            logger.debug((Object)("Unknown db2 object query type when fetching property! " + type.getCanonicalName()));
            return Messages.Db2ObjectQueryNode_TYPE_UNKNOWN;
        }
        if (KEY_OWNER.equals(id)) {
            return this.query.getOwnerPattern();
        }
        if (KEY_NAME.equals(id)) {
            return this.query.getNamePattern();
        }
        if (KEY_DATABASE.equals(id)) {
            return this.query.getDatabasePattern();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return KEY_OWNER.equals(id) || KEY_NAME.equals(id) || KEY_DATABASE.equals(id);
    }

    public void resetPropertyValue(Object id) {
        if (KEY_OWNER.equals(id)) {
            this.query.setOwnerPattern("");
        } else if (KEY_NAME.equals(id)) {
            this.query.setNamePattern("");
        } else if (KEY_DATABASE.equals(id)) {
            this.query.setDatabasePattern("");
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            Db2ObjectQuery newQuery = this.query.clone();
            boolean doChange = false;
            if (KEY_OWNER.equals(id) && !this.query.getOwnerPattern().equals(strValue)) {
                if (strValue.isEmpty() || Db2ObjectQuery.isValidOwnerPattern((String)strValue)) {
                    newQuery.setOwnerPattern(strValue);
                    doChange = true;
                }
            } else if (KEY_NAME.equals(id) && !this.query.getNamePattern().equals(strValue)) {
                if (strValue.isEmpty() || Db2ObjectQuery.isValidNamePattern((String)strValue)) {
                    newQuery.setNamePattern(strValue);
                    doChange = true;
                }
            } else if (KEY_DATABASE.equals(id) && !this.query.getDatabasePattern().equals(strValue)) {
                if (strValue.isEmpty() || Db2ObjectQuery.isValidDatabasePattern((String)strValue)) {
                    newQuery.setDatabasePattern(strValue);
                    doChange = true;
                }
            } else if (KEY_SUBSYSTEM.equals(id) && !this.query.getSubsystem().getName().equals(strValue) && Db2Subsystem.isValidName((IPDHost)this.query.getSystem(), (String)strValue)) {
                Db2Subsystem newSubsys = new Db2Subsystem(this.query.getSystem(), strValue);
                newQuery = Db2ObjectQuery.create((Db2Subsystem)newSubsys, (Class)this.query.getType());
                newQuery.setOwnerPattern(this.query.getOwnerPattern());
                newQuery.setNamePattern(this.query.getNamePattern());
                newQuery.setDatabasePattern(this.query.getDatabasePattern());
                doChange = true;
            }
            if (doChange) {
                EntityRegistry<Db2ObjectQuery<?>> registry = FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry();
                registry.remove(this.query);
                registry.findOrAdd((Object)newQuery);
            }
        }
    }
}

