/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2DatabasePropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2DatabasePropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_NAME_HEX = new Object();
    private static final Object KEY_SUBSYSTEM = new Object();
    private static final Object KEY_CREATOR = new Object();
    private static final IPropertyDescriptor[] PROPERTIES = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NAME, Messages.Db2DatabaseNode_NAME), new PropertyDescriptor(KEY_NAME_HEX, Messages.Db2DatabaseNode_NAME_HEX), new PropertyDescriptor(KEY_SUBSYSTEM, Messages.Db2DatabaseNode_SUBSYSTEM), new PropertyDescriptor(KEY_CREATOR, Messages.Db2DatabaseNode_CREATOR)};
    private Db2Database database;

    public Db2DatabasePropertySource(Db2Database database) {
        if (database == null) {
            String error = "Must pass in non-null Db2Database";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.database = database;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(PROPERTIES, PROPERTIES.length);
    }

    public Object getPropertyValue(Object id) {
        if (KEY_NAME.equals(id)) {
            return this.database.getName();
        }
        if (KEY_NAME_HEX.equals(id)) {
            if (this.database.getSystem().getHostType().getCommunicationEncoding() != this.database.getSystem().getCodePage()) {
                return StringUtils.convertToHex((String)this.database.getName(), (String)this.database.getSystem().getCodePage());
            }
            return StringUtils.convertToHex((String)this.database.getName(), (String)this.database.getSystem().getHostType().getCommunicationEncoding());
        }
        if (KEY_SUBSYSTEM.equals(id)) {
            return this.database.getSubsystem().getName();
        }
        if (KEY_CREATOR.equals(id)) {
            return this.database.getCreator();
        }
        return null;
    }

    public String toString() {
        return this.database.getName();
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

