/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DataSetQueryPropertySource
implements IPropertySource2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DataSetQueryPropertySource.class);
    private static final String UNKNOWN = Messages._UNKNOWN;
    private static final Object KEY_QUERY = new Object();
    private static final Object KEY_NUMBER_OF_DATASETS = new Object();
    private static final Object KEY_TYPE_FILTER = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NUMBER_OF_DATASETS, Messages.DataSetQueryNode_NUMBER_DATA_SETS), new TextPropertyDescriptor(KEY_QUERY, Messages.DataSetQueryNode_QUERY), new TextPropertyDescriptor(KEY_TYPE_FILTER, Messages.DataSetQueryNode_FILTERED_DATA_SETS)};
    private DataSetQuery query;

    public DataSetQueryPropertySource(DataSetQuery query) {
        if (query == null) {
            String error = "Must pass in non-null DataSetQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.query = query;
    }

    public Object getEditableValue() {
        return this.query;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(KEY_QUERY)) {
            return this.query.getQuery();
        }
        if (id.equals(KEY_NUMBER_OF_DATASETS)) {
            List dataSets = this.query.getDataSets();
            if (dataSets == null) {
                return UNKNOWN;
            }
            return dataSets.size();
        }
        if (id.equals(KEY_TYPE_FILTER)) {
            List typesFiltered = this.query.getTypesFiltered();
            if (typesFiltered.size() == DataSetType.STANDARD_VALUES.size()) {
                return "";
            }
            return ArrayUtils.join((Object[])typesFiltered.toArray(), (String)", ").toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (id.equals(KEY_QUERY)) {
            return true;
        }
        return id.equals(KEY_TYPE_FILTER) && this.query.getTypesFiltered().size() > 0;
    }

    public void resetPropertyValue(Object id) {
        if (id.equals(KEY_TYPE_FILTER)) {
            this.query.setTypesFiltered(new ArrayList());
        }
    }

    public void setPropertyValue(Object id, Object value) {
        DataSetQuery newQuery = this.query.clone();
        boolean doChange = false;
        if (value instanceof String) {
            String stringValue = (String)value;
            if (id.equals(KEY_QUERY)) {
                if (DataSetQuery.isValidQuery((String)stringValue, (String)this.query.getSystem().getCodePage())) {
                    newQuery.setQuery(stringValue);
                    doChange = !newQuery.equals((Object)this.query);
                }
            } else if (id.equals(KEY_TYPE_FILTER)) {
                ArrayList<DataSetType> filters = new ArrayList<DataSetType>();
                if (stringValue.isEmpty()) {
                    filters.addAll(DataSetType.STANDARD_VALUES);
                } else {
                    String[] strings = stringValue.toUpperCase().split(",");
                    if (strings.length > 0) {
                        String[] stringArray = strings;
                        int n = strings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            try {
                                filters.add(DataSetType.valueOf((String)str.trim()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n2;
                        }
                    }
                }
                newQuery.setTypesFiltered(filters);
                boolean bl = doChange = !this.query.getTypesFiltered().equals(newQuery.getTypesFiltered());
            }
        }
        if (newQuery.isLikelyLongRunning()) {
            boolean bl = doChange = doChange && PDDialogs.openQuestion((String)Messages.DataSetQueryNode_WARNING, (String)Messages.DataSetQueryNode_QUERY_MAY_TAKE_ALONG_TIME);
        }
        if (doChange) {
            EntityRegistry<DataSetQuery> registry = FMTreeContentHolder.getInstance().getDataSetContent().getQueryRegistry();
            registry.remove((Object)this.query);
            registry.findOrAdd((Object)newQuery);
        }
    }

    public boolean isPropertyResettable(Object id) {
        if (id.equals(KEY_QUERY)) {
            return false;
        }
        return this.isPropertySet(id);
    }
}

