/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IAbortablePropertySource;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class DataSetPropertySource
implements IPropertySource,
IAbortablePropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(DataSetPropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_TYPE = new Object();
    private static final Object KEY_VOLUMES = new Object();
    private static final PropertyDescriptor PROPERTY_NAME = new PropertyDescriptor(KEY_NAME, Messages.DataSetNode_NAME);
    private static final PropertyDescriptor PROPERTY_TYPE = new PropertyDescriptor(KEY_TYPE, Messages.DataSetNode_TYPE);
    private static final PropertyDescriptor PROPERTY_VOLUMES = new PropertyDescriptor(KEY_VOLUMES, Messages.DataSetNode_VOLUMES);
    private static final int EXTRA_PROPERTIES = 2;
    private final DataSet dataSet;
    private Job loaderJob;

    public DataSetPropertySource(DataSet ds) {
        Job.getJobManager().cancel((Object)ds);
        this.dataSet = ds;
        if (this.dataSet.getProperties() == null || this.dataSet.getProperties().getPropertyCount() == 0) {
            this.loaderJob = new Job(MessageFormat.format(Messages.DataSetNode_LOADING_PROPS_FOR_X, this.dataSet.getFormattedName())){

                public boolean belongsTo(Object family) {
                    return family == DataSetPropertySource.this.dataSet || family != null && family.equals(DataSetPropertySource.this.dataSet);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    logger.trace((Object)("Loading detailed properties for " + DataSetPropertySource.this.dataSet.getFormattedName()));
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        DataSetPropertySource dataSetPropertySource = DataSetPropertySource.this;
                        synchronized (dataSetPropertySource) {
                            DataSetPropertySource.this.dataSet.refreshSelf(howIsGoing);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.trace((Object)("Use cancelled loading properties for " + DataSetPropertySource.this.dataSet.getFormattedName()));
                        return Status.CANCEL_STATUS;
                    }
                    if (DataSetPropertySource.this.dataSet.getProperties() == null) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put(Messages.DataSetPropertySource_DataSetDoesNotExist, MessageFormat.format(Messages.DataSetPropertySource_XWasDeletedOrUncatalogued, DataSetPropertySource.this.dataSet.getFormattedName()));
                        DataSetPropertySource.this.dataSet.setProperties(new DataSetProperties(properties));
                    }
                    logger.trace((Object)("Done loading properties for " + DataSetPropertySource.this.dataSet.getFormattedName() + " - num props loaded = " + DataSetPropertySource.this.dataSet.getProperties().getPropertyCount()));
                    return Status.OK_STATUS;
                }
            };
            this.loaderJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PDSystemsView.refreshPropertyPage();
                            }
                        });
                    }
                }
            });
            this.loaderJob.schedule(20L);
        }
    }

    public void abortLoadingProperties() {
        if (this.loaderJob == null) {
            Job.getJobManager().cancel((Object)this.dataSet);
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public synchronized IPropertyDescriptor[] getPropertyDescriptors() {
        boolean haveVolumeInfo;
        DataSetProperties properties = this.dataSet.getProperties();
        if (properties == null) {
            return new IPropertyDescriptor[0];
        }
        Set keys = properties.getPropertyKeys();
        int extraProps = 2;
        boolean bl = haveVolumeInfo = this.dataSet.getAllVolumes().size() > 0;
        if (haveVolumeInfo) {
            ++extraProps;
        }
        IPropertyDescriptor[] propDescs = new IPropertyDescriptor[keys.size() + extraProps];
        propDescs[0] = PROPERTY_NAME;
        propDescs[1] = PROPERTY_TYPE;
        if (haveVolumeInfo) {
            propDescs[2] = PROPERTY_VOLUMES;
        }
        int i = extraProps;
        for (String key : keys) {
            String displayName = properties.getPropertyName(key);
            if (displayName == null) {
                logger.debug((Object)("Property does not have a localised name, key=" + key));
                displayName = key;
            }
            propDescs[i++] = new PropertyDescriptor((Object)key, displayName);
        }
        return propDescs;
    }

    public synchronized Object getPropertyValue(Object id) {
        if (KEY_NAME.equals(id)) {
            return this.dataSet.getName();
        }
        if (KEY_TYPE.equals(id)) {
            return this.dataSet.getType().toString();
        }
        if (KEY_VOLUMES.equals(id)) {
            return ArrayUtils.join((Object[])this.dataSet.getAllVolumes().toArray(), (String)", ").toString();
        }
        if ("Association".equals(id)) {
            List associatedDataSets = this.dataSet.getAssociatedDataSets();
            StringBuilder assocsSb = new StringBuilder();
            for (DataSet dataSet : associatedDataSets) {
                if (assocsSb.length() > 0) {
                    assocsSb.append(", ");
                }
                assocsSb.append(dataSet.getName());
            }
            return assocsSb.toString();
        }
        return this.dataSet.getProperties().getPropertyValue((String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

