/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class DataSetBrowsePropertySource
implements IPropertySource2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DataSetBrowsePropertySource.class);
    private static final String UNKNOWN = Messages._UNKNOWN;
    private static final Object KEY_NUMBER_OF_DATASETS = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NUMBER_OF_DATASETS, Messages.DataSetQueryNode_NUMBER_DATA_SETS)};
    private DataSetQuery query;

    public DataSetBrowsePropertySource(DataSetQuery query) {
        if (query == null) {
            String error = "Must pass in non-null DataSetQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.query = query;
    }

    public Object getEditableValue() {
        return this.query;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(KEY_NUMBER_OF_DATASETS)) {
            List dataSets = this.query.getDataSets();
            if (dataSets == null) {
                return UNKNOWN;
            }
            return dataSets.size();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return this.isPropertySet(id);
    }
}

