/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.ui.dialog.CicsResourceQueryDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class CicsResourceQueryPropertySource
implements IPropertySource2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CicsResourceQueryPropertySource.class);
    private static final Object KEY_QUERY = new Object();
    private static final Object KEY_NUMBER_OF_RESOURCES = new Object();
    private static final Object KEY_TYPE = new Object();
    private static final Object KEY_SYSTEM_NAME = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new TextPropertyDescriptor(KEY_QUERY, Messages.CICS_QUERY), new ComboBoxPropertyDescriptor(KEY_TYPE, Messages.CICSResourceQueryNode_RESOURCE_TYPE, ArrayUtils.getToStringArray((Object[])CicsResourceQueryDialog.CICS_RESOURCE_TYPE.values())), new PropertyDescriptor(KEY_NUMBER_OF_RESOURCES, Messages.CICSResourceQueryNode_NUMBER_RESOURCES), new TextPropertyDescriptor(KEY_SYSTEM_NAME, Messages.CICS_APPLID_NAME)};
    private final CicsResourceQuery<?> query;

    public CicsResourceQueryPropertySource(CicsResourceQuery<?> query) {
        if (query == null) {
            String error = "Must pass in non-null CicsResourceQuery";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.query = query;
    }

    public Object getEditableValue() {
        return this.query;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(MAIN_DESCRIPTORS, MAIN_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (this.query == null) {
            return "";
        }
        if (KEY_QUERY.equals(id)) {
            return this.query.getQuery();
        }
        if (KEY_TYPE.equals(id)) {
            return ArrayUtils.findIndexOf((Object)((Object)CicsResourceQueryDialog.CICS_RESOURCE_TYPE.fromResourceOrQuery(this.query)), (Object[])CicsResourceQueryDialog.CICS_RESOURCE_TYPE.values(), (int)0);
        }
        if (KEY_NUMBER_OF_RESOURCES.equals(id)) {
            List cicsResources = this.query.getCICSResources();
            if (cicsResources == null) {
                return Messages._UNKNOWN;
            }
            return cicsResources.size();
        }
        if (KEY_SYSTEM_NAME.equals(id)) {
            return this.query.getCICSAppl().getName();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        CicsResourceQuery<? extends CicsResource> newQuery = null;
        if (KEY_QUERY.equals(id)) {
            if (this.query.isValidCICSQuery(this.query.getCICSAppl(), value.toString())) {
                this.query.setQuery(value.toString());
                newQuery = this.query;
            }
        } else if (KEY_SYSTEM_NAME.equals(id)) {
            if (CicsAppl.isValidName((String)value.toString(), (String)this.query.getSystem().getCodePage())) {
                CicsAppl newCICSAppl = CicsAppl.create((IPDHost)this.query.getSystem(), (String)value.toString());
                newQuery = this.query.clone();
                newQuery.setCICSApplID(newCICSAppl);
            }
        } else if (KEY_TYPE.equals(id)) {
            CicsResourceQueryDialog.CICS_RESOURCE_TYPE newType;
            int choice = (Integer)value;
            CicsResourceQueryDialog.CICS_RESOURCE_TYPE currType = CicsResourceQueryDialog.CICS_RESOURCE_TYPE.fromResourceOrQuery(this.query);
            if (currType != (newType = CicsResourceQueryDialog.CICS_RESOURCE_TYPE.values()[choice])) {
                if (newType.isValidQuery(this.query.getCICSAppl(), this.query.getQuery())) {
                    newQuery = newType.createQuery(this.query.getCICSAppl(), this.query.getQuery());
                } else {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CicsResourceQueryPropertySource_ERROR_QUERY_X_NOT_VALID_FOR_QUERY_TYPE_X, this.query.getQuery(), newType.toString()));
                }
            }
        }
        if (newQuery != null) {
            EntityRegistry<CicsResourceQuery<?>> registry = FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry();
            registry.remove(this.query);
            registry.findOrAdd(newQuery);
        }
    }

    public String toString() {
        return this.query.toString();
    }

    public boolean isPropertyResettable(Object id) {
        if (id.equals(KEY_QUERY)) {
            return false;
        }
        return this.isPropertySet(id);
    }
}

