/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.properties;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CicsResourcePropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CicsResourcePropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_NAME_HEX = new Object();
    private static final Object KEY_TD_TYPE = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_NAME, Messages._NAME), new PropertyDescriptor(KEY_NAME_HEX, Messages._NAME_HEX)};
    private final CicsResource cicsResource;

    public CicsResourcePropertySource(CicsResource resource) {
        if (resource == null) {
            String error = "Must pass in non-null CicsResource";
            logger.error((Object)error);
            throw new IllegalArgumentException(error);
        }
        this.cicsResource = resource;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.cicsResource == null) {
            logger.debug((Object)"Cics resource is null");
            return new IPropertyDescriptor[0];
        }
        ImmutableProperties properties = this.cicsResource.getProperties();
        if (properties == null || properties.getPropertyCount() == 0) {
            logger.debug((Object)"No cics resource properties");
            return new IPropertyDescriptor[0];
        }
        ArrayList<IPropertyDescriptor> propDescs = new ArrayList<IPropertyDescriptor>(Arrays.asList(MAIN_DESCRIPTORS));
        if (this.cicsResource instanceof CicsTransientData) {
            propDescs.add((IPropertyDescriptor)new PropertyDescriptor(KEY_TD_TYPE, Messages.CICS_TD_TYPE_DESC));
        }
        Set keys = properties.getPropertyKeys();
        for (String key : keys) {
            String displayName = properties.getPropertyName(key);
            if (displayName == null) {
                logger.debug((Object)("Property does not have a localised name, key=" + key));
                displayName = key;
            }
            propDescs.add((IPropertyDescriptor)new PropertyDescriptor((Object)key, displayName));
        }
        return propDescs.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (this.cicsResource == null) {
            return "";
        }
        if (KEY_NAME.equals(id)) {
            return this.cicsResource.getName();
        }
        if (KEY_NAME_HEX.equals(id)) {
            int ind;
            String fullName = this.cicsResource.getName();
            if (fullName.endsWith("'/") && (ind = fullName.lastIndexOf("\\x'")) > 0) {
                return fullName.substring(ind + 3, fullName.length() - 2);
            }
            if (this.cicsResource.getSystem().getHostType().getCommunicationEncoding() != this.cicsResource.getSystem().getCodePage()) {
                return StringUtils.convertToHex((String)fullName, (String)this.cicsResource.getSystem().getCodePage());
            }
            return StringUtils.convertToHex((String)fullName, (String)this.cicsResource.getSystem().getHostType().getCommunicationEncoding());
        }
        if (KEY_TD_TYPE.equals(id)) {
            if (!(this.cicsResource instanceof CicsTransientData)) {
                logger.debug((Object)("Can't get CICS TD type property for " + String.valueOf(this.cicsResource)));
                return Messages._UNKNOWN;
            }
            CicsTransientData.TD_TYPE type = ((CicsTransientData)this.cicsResource).getTDType();
            if (type == CicsTransientData.TD_TYPE.INDIRECT_TD) {
                return Messages.CICS_TD_TYPE_INDRECT;
            }
            if (type == CicsTransientData.TD_TYPE.EXTRAPARTITION_TD) {
                return Messages.CICS_TD_TYPE_EXTRAPARTITION;
            }
            if (type == CicsTransientData.TD_TYPE.INTRAPARTITION_TD) {
                return Messages.CICS_TD_TYPE_INTRAPARTITION;
            }
            if (type == CicsTransientData.TD_TYPE.REMOTE_TD) {
                return Messages.CICS_TD_TYPE_REMOTE;
            }
            logger.debug((Object)("Unknown CICS TD type: " + String.valueOf(type)));
            return Messages._UNKNOWN;
        }
        return this.cicsResource.getProperties().getPropertyValue(id.toString());
    }

    public String toString() {
        return this.cicsResource.getName();
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

