/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.ui.memento.MessageQueueQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.MqTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.MessageQueueQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class MessageQueueQueryFolderNode
extends SystemsDataNode<MessageQueueManager> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public MessageQueueQueryFolderNode(MessageQueueManager mqm, SystemsTreeNode parent) {
        super((Object)mqm, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<MessageQueueQueryNode> nodes = new ArrayList<MessageQueueQueryNode>();
        for (MessageQueueQuery mqQuery : FMTreeContentHolder.getInstance().getMqContent().getQueriesForManager((MessageQueueManager)this.getDataObject())) {
            if (this.isInRS()) {
                MessageQueueQuery aQuery = MessageQueueQuery.create((MessageQueueManager)((MessageQueueManager)this.getDataObject()), (String)mqQuery.getQuery());
                aQuery.setSystem(((MessageQueueManager)this.getDataObject()).getSystem());
                nodes.add(new MessageQueueQueryNode(aQuery, (SystemsTreeNode)this));
                continue;
            }
            nodes.add(new MessageQueueQueryNode(mqQuery, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public void removeNode() {
        MessageQueueManager entity = (MessageQueueManager)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        MqTreeContent mqContent = FMTreeContentHolder.getInstance().getMqContent();
        List<MessageQueueQuery> queries = mqContent.getQueriesForManager(entity);
        for (MessageQueueQuery query : queries) {
            mqContent.getQueryRegistry().remove((Object)query, false);
        }
        FMTreeContentHolder.getInstance().saveMqQueries(pdHost);
        if (pdHost.getDelegatingHost() == null) {
            for (MessageQueueQuery query : queries) {
                mqContent.getQueryRegistry().announceRemove((Object)query);
            }
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        MqTreeContent mqContent = FMTreeContentHolder.getInstance().getMqContent();
        List<MessageQueueQuery> queries = mqContent.getQueriesForManager((MessageQueueManager)this.getDataObject());
        MessageQueueQuerySaver messageQueueQuerySaver = new MessageQueueQuerySaver(toHost);
        for (MessageQueueQuery query : queries) {
            messageQueueQuerySaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }
}

