/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsBmpBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDliBrowseNode;
import com.ibm.etools.fm.ui.views.systems.properties.ImsSubsystemConfigPropertySource;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.model.ISystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ImsSubsystemNode
extends SystemsDataNode<ImsSubsystem>
implements ISystemsErrorFinder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public ImsSubsystemNode(ImsSubsystem subsystem, SystemsTreeNode parent) {
        super((Object)subsystem, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        ImsSubsystemConfig config = ((ImsSubsystem)this.getDataObject()).getCanonicalConfig();
        if (config != null && config.isConnectable()) {
            if (config.isBmpSupported()) {
                nodes.add(new ImsBmpBrowseNode(config, (SystemsTreeNode)this));
            }
            if (config.isDliSupported()) {
                nodes.add(new ImsDliBrowseNode(config, (SystemsTreeNode)this));
            }
        }
        return nodes;
    }

    public String getErrorText() {
        ImsSubsystemConfig config = ((ImsSubsystem)this.getDataObject()).getCanonicalConfig();
        if (!config.isOnline() && !config.isDliSupported()) {
            return MessageFormat.format(Messages.SystemsErrorFinder_ERROR_OFFLINE_AND_ONLY_BMP_ACCESS_ALLOWED, ((ImsSubsystem)this.getDataObject()).getSubsystemID());
        }
        if (!config.getBmpConfig().isConnectable() && !config.getDliConfig().isConnectable()) {
            return MessageFormat.format(Messages.SystemsErrorFinder_ERROR_BOTH_REGION_TYPES_DISABLED, ((ImsSubsystem)this.getDataObject()).getSubsystemID());
        }
        return null;
    }

    public Object getPropertySource() {
        return new ImsSubsystemConfigPropertySource(((ImsSubsystem)this.getDataObject()).getCanonicalConfig());
    }
}

