/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.memento.ImsSubsystemConfigSaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbQueryNode;
import com.ibm.etools.fm.ui.views.systems.properties.ImsSubsystemConfigPropertySource;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class ImsSubsystemConfigNode
extends SystemsDataNode<ImsSubsystemConfig> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public ImsSubsystemConfigNode(ImsSubsystemConfig config, SystemsTreeNode parent) {
        super((Object)config, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        if (((ImsSubsystemConfig)this.getDataObject()).isConnectable()) {
            ImsPsbQuery aQuery;
            ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
            for (ImsPsbQuery psbQuery : imsContent.getPsbQueriesForSubsystem(((ImsSubsystemConfig)this.getDataObject()).getSubsystem())) {
                if (this.isInRS()) {
                    aQuery = new ImsPsbQuery(((ImsSubsystemConfig)this.getDataObject()).getSubsystem(), psbQuery.getPattern(), psbQuery.getRegionType(), psbQuery.getAccessMode());
                    nodes.add(new ImsPsbQueryNode(aQuery, (SystemsTreeNode)this));
                    continue;
                }
                nodes.add(new ImsPsbQueryNode(psbQuery, (SystemsTreeNode)this));
            }
            for (ImsDatabaseQuery dbQuery : imsContent.getDatabaseQueriesForSubsystem(((ImsSubsystemConfig)this.getDataObject()).getSubsystem())) {
                if (this.isInRS()) {
                    aQuery = new ImsDatabaseQuery(((ImsSubsystemConfig)this.getDataObject()).getSubsystem(), dbQuery.getPattern(), dbQuery.getRegionType(), dbQuery.getAccessMode());
                    aQuery.setSystem(((ImsSubsystemConfig)this.getDataObject()).getSystem());
                    nodes.add(new ImsDatabaseQueryNode((ImsDatabaseQuery)aQuery, (SystemsTreeNode)this));
                    continue;
                }
                nodes.add(new ImsDatabaseQueryNode(dbQuery, (SystemsTreeNode)this));
            }
        }
        return nodes;
    }

    public void removeNode() {
        ImsSubsystemConfig config = (ImsSubsystemConfig)this.getDataObject();
        IPDHost pdHost = config.getSystem();
        ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
        List<ImsPsbQuery> psbQueries = imsContent.getPsbQueriesForSubsystem(config.getSubsystem());
        for (ImsPsbQuery imsPsbQuery : psbQueries) {
            imsContent.getPsbQueries().remove((Object)imsPsbQuery, false);
        }
        List<ImsDatabaseQuery> dbQueries = imsContent.getDatabaseQueriesForSubsystem(config.getSubsystem());
        for (ImsDatabaseQuery dbQuery : dbQueries) {
            imsContent.getDatabaseQueries().remove((Object)dbQuery, false);
        }
        FMTreeContentHolder.getInstance().saveImsQueries(pdHost);
        if (pdHost.getDelegatingHost() == null) {
            for (ImsPsbQuery imsPsbQuery : psbQueries) {
                imsContent.getPsbQueries().announceRemove((Object)imsPsbQuery);
            }
            for (ImsDatabaseQuery dbQuery : dbQueries) {
                imsContent.getDatabaseQueries().announceRemove((Object)dbQuery);
            }
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        ImsSubsystemConfig config = (ImsSubsystemConfig)this.getDataObject();
        ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
        List<ImsPsbQuery> psbQueries = imsContent.getPsbQueriesForSubsystem(config.getSubsystem());
        ImsSubsystemConfigSaver imsSubsystemConfigSaver = new ImsSubsystemConfigSaver(toHost);
        for (ImsPsbQuery imsPsbQuery : psbQueries) {
            imsSubsystemConfigSaver.saveTo(imsPsbQuery);
        }
        List<ImsDatabaseQuery> dbQueries = imsContent.getDatabaseQueriesForSubsystem(config.getSubsystem());
        for (ImsDatabaseQuery dbQuery : dbQueries) {
            imsSubsystemConfigSaver.saveTo(dbQuery);
        }
    }

    public boolean isExportable() {
        return true;
    }

    public Object getPropertySource() {
        return new ImsSubsystemConfigPropertySource(((ImsSubsystemConfig)this.getDataObject()).getSubsystem().getCanonicalConfig());
    }
}

