/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemConfigNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsHostUniqueNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;

public class ImsRootNode
extends SystemsHostUniqueNode
implements IPDPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFERENCE_ID = "ipv.Ims";
    private static BooleanFieldEditor featurePreference = null;

    public ImsRootNode() {
        super((PDFeature)FMFeature.IMS);
    }

    public ImsRootNode(IPDHost host, SystemsTreeNode parent) {
        super(host, parent);
    }

    public boolean hasChildren() {
        return true;
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        nodes.add(new ImsSubsystemBrowseNode(this.getSystem(), this));
        if (!this.queriesLoaded) {
            FMTreeContentHolder.getInstance().loadImsQFromDialogSetting(this.getSystem());
            this.queriesLoaded = true;
        }
        ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
        for (ImsSubsystem subsystem : imsContent.getSubsystemsWithQueriesForHost(this.getSystem())) {
            if (this.isInRS()) {
                ImsSubsystemConfig imsSubsystemConfig = subsystem.getCanonicalConfig();
                ImsSubsystemConfig rsConfig = new ImsSubsystemConfig(imsSubsystemConfig);
                ImsSubsystem rsSubsystem = new ImsSubsystem(this.getSystem(), subsystem.getSubsystemID());
                rsConfig.setSubsystem(rsSubsystem, true);
                nodes.add(new ImsSubsystemConfigNode(rsConfig, (SystemsTreeNode)this));
                continue;
            }
            nodes.add(new ImsSubsystemConfigNode(subsystem.getCanonicalConfig(), (SystemsTreeNode)this));
        }
        return nodes;
    }

    public String getPDLabel() {
        return this.getSubsysName();
    }

    public String getSubsysName() {
        return Messages.ImsRootNode_IMS;
    }

    public String getPDImageName() {
        return "ims_root";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPreferenceId() {
        return PREFERENCE_ID;
    }

    public void setFeaturePreference(BooleanFieldEditor status) {
        featurePreference = status;
    }

    public BooleanFieldEditor getFeaturePreference() {
        return featurePreference;
    }
}

