/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.memento.ImsSubsystemConfigSaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbNode;
import com.ibm.etools.fm.ui.views.systems.properties.ImsPsbQueryPropertySource;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.model.ISystemsErrorFinder;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ImsPsbQueryNode
extends SystemsDataNode<ImsPsbQuery>
implements DelayedNodeHelper.ChildrenCreator<List<ImsPsb>>,
ISystemsErrorFinder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final DelayedNodeHelper<ImsPsbQuery, List<ImsPsb>> HELPER = new DelayedNodeHelper(FMTreeContentHolder.getInstance().getImsContent().getPsbQueryCache());

    public ImsPsbQueryNode(ImsPsbQuery query, SystemsTreeNode parent) {
        super((Object)query, parent);
    }

    public boolean hasChildren() {
        return this.getErrorText() == null && (HELPER.isYetToLoad((IHostProvider)((ImsPsbQuery)this.getDataObject())) || super.hasChildren());
    }

    public List<? extends SystemsTreeNode> getChildren() {
        HELPER.triggerLoad((IHostProvider)((ImsPsbQuery)this.getDataObject()));
        return super.getChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        return HELPER.getKnownChildren((IHostProvider)((ImsPsbQuery)this.getDataObject()), (SystemsTreeNode)this, (DelayedNodeHelper.ChildrenCreator)this);
    }

    public List<? extends SystemsTreeNode> createChildrenFromContent(List<ImsPsb> content, SystemsTreeNode parent) {
        ArrayList<ImsPsbNode> nodes = new ArrayList<ImsPsbNode>();
        if (this.getErrorText() == null) {
            for (ImsPsb psb : content) {
                nodes.add(new ImsPsbNode(psb, parent));
            }
        }
        return nodes;
    }

    public void refreshSelf() {
        HELPER.triggerUnload((IHostProvider)((ImsPsbQuery)this.getDataObject()));
    }

    public DelayedNodeHelper getHelper() {
        return HELPER;
    }

    public String getErrorText() {
        ImsPsbQuery query = (ImsPsbQuery)this.getDataObject();
        ImsSubsystemConfig config = query.getSubsystem().getCanonicalConfig();
        if (!config.isStaticAccessSupported(ImsRegionType.BMP) && !config.isStaticAccessSupported(ImsRegionType.DLI)) {
            return MessageFormat.format(Messages.SystemsErrorFinder_ERROR_STATIC_PSB_ACCESS_DISABLED, query.getSubsystem().getSubsystemID());
        }
        return null;
    }

    public void removeNode() {
        ImsPsbQuery entity = (ImsPsbQuery)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        boolean removed = FMTreeContentHolder.getInstance().getImsContent().getPsbQueries().remove((Object)entity, false);
        FMTreeContentHolder.getInstance().saveImsQueries(pdHost);
        if (removed && pdHost.getDelegatingHost() == null) {
            FMTreeContentHolder.getInstance().getImsContent().getPsbQueries().announceRemove((Object)entity);
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        ImsSubsystemConfigSaver imsSubsystemConfigSaver = new ImsSubsystemConfigSaver(toHost);
        ImsPsbQuery query = (ImsPsbQuery)FMTreeContentHolder.getInstance().getImsContent().getPsbQueries().find((Object)((ImsPsbQuery)this.getDataObject()));
        if (query != null) {
            imsSubsystemConfigSaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }

    public Object getPropertySource() {
        return new ImsPsbQueryPropertySource((ImsPsbQuery)this.getDataObject());
    }
}

