/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.memento.ImsSubsystemConfigSaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseNode;
import com.ibm.etools.fm.ui.views.systems.properties.ImsDatabaseQueryPropertySource;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.model.ISystemsErrorFinder;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ImsDatabaseQueryNode
extends SystemsDataNode<ImsDatabaseQuery>
implements DelayedNodeHelper.ChildrenCreator<List<ImsDatabase>>,
ISystemsErrorFinder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final DelayedNodeHelper<ImsDatabaseQuery, List<ImsDatabase>> HELPER = new DelayedNodeHelper(FMTreeContentHolder.getInstance().getImsContent().getDatabaseQueryCache());

    public ImsDatabaseQueryNode(ImsDatabaseQuery query, SystemsTreeNode parent) {
        super((Object)query, parent);
    }

    public boolean hasChildren() {
        return this.getErrorText() == null && (HELPER.isYetToLoad((IHostProvider)((ImsDatabaseQuery)this.getDataObject())) || super.hasChildren());
    }

    public List<? extends SystemsTreeNode> getChildren() {
        HELPER.triggerLoad((IHostProvider)((ImsDatabaseQuery)this.getDataObject()));
        return super.getChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        return HELPER.getKnownChildren((IHostProvider)((ImsDatabaseQuery)this.getDataObject()), (SystemsTreeNode)this, (DelayedNodeHelper.ChildrenCreator)this);
    }

    public List<? extends SystemsTreeNode> createChildrenFromContent(List<ImsDatabase> content, SystemsTreeNode parent) {
        ArrayList<ImsDatabaseNode> nodes = new ArrayList<ImsDatabaseNode>();
        if (this.getErrorText() == null) {
            for (ImsDatabase db : content) {
                nodes.add(new ImsDatabaseNode(db, parent));
            }
        }
        return nodes;
    }

    public void refreshSelf() {
        HELPER.triggerUnload((IHostProvider)((ImsDatabaseQuery)this.getDataObject()));
    }

    public DelayedNodeHelper getHelper() {
        return HELPER;
    }

    public String getErrorText() {
        ImsDatabaseQuery query = (ImsDatabaseQuery)this.getDataObject();
        ImsSubsystemConfig config = query.getSubsystem().getCanonicalConfig();
        if (!config.isDynamicAccessSupported(ImsRegionType.BMP) && !config.isDynamicAccessSupported(ImsRegionType.DLI)) {
            return MessageFormat.format(Messages.SystemsErrorFinder_ERROR_DYNAMIC_DB_ACCESS_DISABLED_FOR_SUBSYSTEM, query.getSubsystem().getSubsystemID());
        }
        return null;
    }

    public void removeNode() {
        ImsDatabaseQuery entity = (ImsDatabaseQuery)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        boolean removed = FMTreeContentHolder.getInstance().getImsContent().getDatabaseQueries().remove((Object)entity, false);
        FMTreeContentHolder.getInstance().saveImsQueries(pdHost);
        if (removed && pdHost.getDelegatingHost() == null) {
            FMTreeContentHolder.getInstance().getImsContent().getDatabaseQueries().announceRemove((Object)entity);
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        ImsSubsystemConfigSaver imsSubsystemConfigSaver = new ImsSubsystemConfigSaver(toHost);
        ImsDatabaseQuery query = (ImsDatabaseQuery)FMTreeContentHolder.getInstance().getImsContent().getDatabaseQueries().find((Object)((ImsDatabaseQuery)this.getDataObject()));
        if (query != null) {
            imsSubsystemConfigSaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }

    public Object getPropertySource() {
        return new ImsDatabaseQueryPropertySource((ImsDatabaseQuery)this.getDataObject());
    }
}

