/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.ui.memento.Db2ObjectQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.Db2TreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class Db2SubsystemFolderNode
extends SystemsDataNode<Db2Subsystem> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public Db2SubsystemFolderNode(Db2Subsystem subsystem, SystemsTreeNode parent) {
        super((Object)subsystem, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<Db2ObjectQueryNode> nodes = new ArrayList<Db2ObjectQueryNode>();
        for (Db2ObjectQuery<?> query : FMTreeContentHolder.getInstance().getDb2Content().getQueriesForSubsystem((Db2Subsystem)this.getDataObject())) {
            if (this.isInRS()) {
                Db2ObjectQuery aQuery = new Db2ObjectQuery((Db2Subsystem)this.getDataObject(), query.getType());
                aQuery.setOwnerPattern(query.getOwnerPattern());
                aQuery.setNamePattern(query.getNamePattern());
                aQuery.setDatabasePattern(query.getDatabasePattern());
                aQuery.setSystem(((Db2Subsystem)this.getDataObject()).getSystem());
                nodes.add(new Db2ObjectQueryNode(aQuery, (SystemsTreeNode)this));
                continue;
            }
            nodes.add(new Db2ObjectQueryNode(query, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public void removeNode() {
        Db2Subsystem entity = (Db2Subsystem)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        Db2TreeContent db2Content = FMTreeContentHolder.getInstance().getDb2Content();
        List<Db2ObjectQuery<?>> queries = db2Content.getQueriesForSubsystem(entity);
        for (Db2ObjectQuery<?> query : queries) {
            db2Content.getObjectQueryRegistry().remove(query, false);
        }
        FMTreeContentHolder.getInstance().saveDb2Queries(pdHost);
        if (pdHost.getDelegatingHost() == null) {
            for (Db2ObjectQuery<?> query : queries) {
                db2Content.getObjectQueryRegistry().announceRemove(query);
            }
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        Db2TreeContent db2Content = FMTreeContentHolder.getInstance().getDb2Content();
        List<Db2ObjectQuery<?>> queries = db2Content.getQueriesForSubsystem((Db2Subsystem)this.getDataObject());
        Db2ObjectQuerySaver db2ObjectQuerySaver = new Db2ObjectQuerySaver(toHost);
        for (Db2ObjectQuery<?> query : queries) {
            db2ObjectQuerySaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }
}

