/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemFolderNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsHostUniqueNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;

public class Db2ObjectRootNode
extends SystemsHostUniqueNode
implements IPDPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFERENCE_ID = "ipv.DB2";
    private static BooleanFieldEditor featurePreference = null;

    public Db2ObjectRootNode() {
        super((PDFeature)FMFeature.DB2);
    }

    public Db2ObjectRootNode(IPDHost host, SystemsTreeNode parent) {
        super(host, parent);
    }

    public boolean hasChildren() {
        return true;
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        if (this.getSystem().getCodePage() == null) {
            this.getSystem().setCodePage("cp037");
        }
        nodes.add(new Db2SubsystemBrowseNode(this.getSystem(), this));
        if (!this.queriesLoaded) {
            FMTreeContentHolder.getInstance().loadDb2QFromDialogSetting(this.getSystem());
            this.queriesLoaded = true;
        }
        for (Db2Subsystem subsystem : FMTreeContentHolder.getInstance().getDb2Content().getSubsystemsWithQueries(this.getSystem())) {
            Db2Subsystem db2Subsystem = new Db2Subsystem(this.getSystem(), subsystem.getSubsystemID());
            nodes.add(new Db2SubsystemFolderNode(db2Subsystem, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public String getPDLabel() {
        return this.getSubsysName();
    }

    public String getSubsysName() {
        return Messages.Db2ObjectRootNode_DB2_NAME;
    }

    public String getPDImageName() {
        return "db2_root";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPreferenceId() {
        return PREFERENCE_ID;
    }

    public void setFeaturePreference(BooleanFieldEditor status) {
        featurePreference = status;
    }

    public BooleanFieldEditor getFeaturePreference() {
        return featurePreference;
    }
}

