/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.memento.Db2ObjectQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2DatabaseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2TableNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class Db2ObjectQueryNode
extends SystemsDataNode<Db2ObjectQuery<?>>
implements DelayedNodeHelper.ChildrenCreator<List<? extends Db2Object>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final DelayedNodeHelper<Db2ObjectQuery<?>, List<? extends Db2Object>> helper = new DelayedNodeHelper(FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryCache());

    protected Db2ObjectQueryNode(Db2ObjectQuery<?> query, SystemsTreeNode parent) {
        super(query, parent);
    }

    public boolean hasChildren() {
        return helper.isYetToLoad((IHostProvider)((Db2ObjectQuery)this.getDataObject())) || super.hasChildren();
    }

    public List<? extends SystemsTreeNode> getChildren() {
        helper.triggerLoad((IHostProvider)((Db2ObjectQuery)this.getDataObject()));
        return super.getChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        return helper.getKnownChildren((IHostProvider)((Db2ObjectQuery)this.getDataObject()), (SystemsTreeNode)this, (DelayedNodeHelper.ChildrenCreator)this);
    }

    public List<? extends SystemsTreeNode> createChildrenFromContent(List<? extends Db2Object> content, SystemsTreeNode parent) {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        for (Db2Object db2Object : content) {
            if (db2Object instanceof Db2Table) {
                nodes.add(new Db2TableNode((Db2Table)db2Object, (SystemsTreeNode)this));
                continue;
            }
            if (db2Object instanceof Db2Database) {
                nodes.add(new Db2DatabaseNode((Db2Database)db2Object, (SystemsTreeNode)this));
                continue;
            }
            PDLogger.get(((Object)((Object)this)).getClass()).debug((Object)("Don't know how to handle query child of type " + db2Object.getClass().getCanonicalName()));
        }
        return nodes;
    }

    public void refreshSelf() {
        helper.triggerUnload((IHostProvider)((Db2ObjectQuery)this.getDataObject()));
    }

    public DelayedNodeHelper getHelper() {
        return helper;
    }

    public void removeNode() {
        Db2ObjectQuery entity = (Db2ObjectQuery)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        boolean removed = FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry().remove((Object)entity, false);
        FMTreeContentHolder.getInstance().saveDb2Queries(pdHost);
        if (removed && pdHost.getDelegatingHost() == null) {
            FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry().announceRemove((Object)entity);
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        Db2ObjectQuerySaver db2ObjectQuerySaver = new Db2ObjectQuerySaver(toHost);
        Db2ObjectQuery query = (Db2ObjectQuery)FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry().find((Object)((Db2ObjectQuery)this.getDataObject()));
        if (query != null) {
            db2ObjectQuerySaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }
}

