/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.ui.views.systems.handlers.Copy;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetNode;
import com.ibm.etools.fm.ui.views.systems.nodes.MemberNode;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.IPDDragSource;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DataSetNodeDNDSupport {
    private static final PDLogger logger = PDLogger.get(DataSetNodeDNDSupport.class);

    public boolean execute(DataSetNode node, List<IPDDragSource> draggedObjects, int operation) {
        HashMap<DataSet, ArrayList<Member>> toCopy = new HashMap<DataSet, ArrayList<Member>>();
        for (IPDDragSource iPDDragSource : draggedObjects) {
            Member dataObject;
            if (iPDDragSource instanceof MemberNode) {
                dataObject = (Member)((MemberNode)iPDDragSource).getDataObject();
                ArrayList<Member> list = (ArrayList<Member>)toCopy.get(dataObject.asDataSet());
                if (list == null) {
                    list = new ArrayList<Member>();
                }
                list.add(dataObject);
                toCopy.put(dataObject.asDataSet(), list);
                continue;
            }
            if (!(iPDDragSource instanceof DataSetNode) || toCopy.containsKey(dataObject = (DataSet)((DataSetNode)iPDDragSource).getDataObject())) continue;
            toCopy.put(dataObject.asDataSet(), null);
        }
        for (Map.Entry entry : toCopy.entrySet()) {
            CopyModel model = new CopyModel(((DataSet)entry.getKey()).getSystem());
            model.setSourceResource((IZRL)entry.getKey());
            if (entry.getValue() != null) {
                Object members = "";
                for (Member m : (List)entry.getValue()) {
                    members = (String)members + m.getName() + ",";
                }
                model.setMembersList(((String)members).substring(0, ((String)members).length() - 1));
            }
            model.setDestSystem(((DataSet)node.getDataObject()).getSystem());
            model.setDestResource(((DataSet)node.getDataObject()).getFormattedName());
            if (operation != 2 || Copy.showCopyWizard(model) == 0) continue;
            return false;
        }
        return false;
    }

    public boolean isValidInput(DataSetNode node, List<IPDDragSource> draggedObjects) {
        for (IPDDragSource dragged : draggedObjects) {
            Object draggedO;
            if (!(dragged instanceof SystemsDataNode) || !((draggedO = ((SystemsDataNode)dragged).getDataObject()) instanceof DataSet) && !(draggedO instanceof Member)) continue;
            IHostProvider draggedHost = (IHostProvider)draggedO;
            if (((IZRL)node.getDataObject()).getSystem().getHostName().equals(draggedHost.getSystem().getHostName())) continue;
            try {
                return FMHostJhost.isRMSupportedBetween((IPDHost)draggedHost.getSystem(), (IPDHost)((IZRL)node.getDataObject()).getSystem(), (IHowIsGoing)PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CommunicationException | InterruptedException e) {
                logger.error(e);
            }
        }
        return true;
    }
}

