/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetNodeDNDSupport;
import com.ibm.etools.fm.ui.views.systems.nodes.MemberNode;
import com.ibm.etools.fm.ui.views.systems.properties.DataSetPropertySource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.IPDDragSource;
import com.ibm.pdtools.common.component.ui.views.systems.IPDDropTarget;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DataSetNode
extends SystemsDataNode<DataSet>
implements IPDDragSource,
IPDDropTarget {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final DelayedNodeHelper<DataSet, List<Member>> helper = new DelayedNodeHelper(FMTreeContentHolder.getInstance().getDataSetContent().getDataSetContentCache());

    protected DataSetNode(DataSet dataSet, SystemsTreeNode parent) {
        super((Object)dataSet, parent);
    }

    public boolean hasChildren() {
        return ((DataSet)this.getDataObject()).getHasMembers() && (helper.isYetToLoad((IHostProvider)((DataSet)this.getDataObject())) || super.hasChildren());
    }

    public List<? extends SystemsTreeNode> getChildren() {
        helper.triggerLoad((IHostProvider)((DataSet)this.getDataObject()));
        return super.getChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        IContentLoadStatus loadStatus = helper.getEntityContentCache().getLoadStatus((Object)((DataSet)this.getDataObject()));
        List children = helper.getLoadingChildren(loadStatus, (IHostProvider)((DataSet)this.getDataObject()), (SystemsTreeNode)this);
        if (children != null) {
            return children;
        }
        ArrayList<MemberNode> memberNodes = new ArrayList<MemberNode>();
        if (loadStatus != null && loadStatus.getContentOnly() != null) {
            for (Member member : (List)loadStatus.getContentOnly()) {
                memberNodes.add(new MemberNode(member, (SystemsTreeNode)this));
            }
        } else {
            PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)"loadstatus is null...");
        }
        return DelayedNodeHelper.applyGrouping(memberNodes);
    }

    public void refreshSelf() {
        new Job(MessageFormat.format(Messages._REFRESHING_X, ((DataSet)this.getDataObject()).getName())){

            protected IStatus run(IProgressMonitor monitor) {
                Result result = null;
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    result = ((DataSet)DataSetNode.this.getDataObject()).refreshSelf(howIsGoing);
                }
                catch (InterruptedException e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)"cancelled refresh self in data set node");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                if (!result.isSuccessfulWithoutWarnings()) {
                    return new Status(4, "com.ibm.etools.fm.ui", result.getMessagesCombined().toString());
                }
                if (!((DataSet)DataSetNode.this.getDataObject()).getConfirmedExists()) {
                    PDSystemsTreeUpdater.refreshAllRelatedTo((Object)DataSetNode.this.getDataObject());
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PDSystemsView.refreshPropertyPage();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
        helper.triggerUnload((IHostProvider)((DataSet)this.getDataObject()));
    }

    public DelayedNodeHelper getHelper() {
        return helper;
    }

    public Object getPropertySource() {
        return new DataSetPropertySource((DataSet)this.getDataObject());
    }

    public boolean execute(List<IPDDragSource> draggedObjects, int operation) {
        return new DataSetNodeDNDSupport().execute(this, draggedObjects, operation);
    }

    public boolean isValidInput(List<IPDDragSource> draggedObjects) {
        return new DataSetNodeDNDSupport().isValidInput(this, draggedObjects);
    }
}

